/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.LogLevel;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketAppender;

public class LoggingConfiguration {
    private static final int DEFAULT_SOCKET_APPENDER_PORT = 4560;
    private static final int DEFAULT_SOCKET_APPENDER_DELAY = 10000;
    private static final LogLevel DEFAULT_LOGGING_LEVEL = LogLevel.WARN;
    private final LogLevel logLevel;
    private final boolean socketAppenderEnabled;
    private final String socketRemoteAddress;
    private final int socketAppenderPort;

    public LoggingConfiguration() {
        this(DEFAULT_LOGGING_LEVEL);
    }

    public LoggingConfiguration(LogLevel logLevel) {
        this(logLevel, 4560, null, false);
    }

    public LoggingConfiguration(LogLevel logLevel, int socketAppenderPort, String socketRemoteAddress, boolean socketAppenderEnabled) {
        this.logLevel = logLevel;
        this.socketAppenderPort = socketAppenderPort;
        this.socketRemoteAddress = socketRemoteAddress;
        this.socketAppenderEnabled = socketAppenderEnabled;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public int getSocketAppenderPort() {
        return this.socketAppenderPort;
    }

    public String getSocketRemoteAddress() {
        return this.socketRemoteAddress;
    }

    public boolean isSocketAppenderEnabled() {
        return this.socketAppenderEnabled;
    }

    public void apply() {
        SocketAppender socketAppender = this.getSocketAppender();
        if (socketAppender != null) {
            Logger.getRootLogger().removeAppender((Appender)socketAppender);
        }
        if (this.socketAppenderEnabled) {
            this.addSocketAppender(this.socketRemoteAddress, this.socketAppenderPort, 10000);
        }
        LogLog.setQuietMode((boolean)this.socketAppenderEnabled);
        this.changeRootLogLevel(this.logLevel);
    }

    private void addSocketAppender(String socketRemoteAddress, int socketAppenderPort, int socketReconnectionDelay) {
        SocketAppender socketAppender = new SocketAppender(socketRemoteAddress, socketAppenderPort);
        socketAppender.setReconnectionDelay(socketReconnectionDelay);
        Logger.getRootLogger().addAppender((Appender)socketAppender);
    }

    private SocketAppender getSocketAppender() {
        Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender appender = (Appender)allAppenders.nextElement();
            if (!(appender instanceof SocketAppender)) continue;
            return (SocketAppender)appender;
        }
        return null;
    }

    private void changeRootLogLevel(LogLevel logLevel) {
        Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel.toString()));
    }
}

