/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConfiguration {
    private static final DateTimeFormatter fullFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy,HH:mm:ss.SSS");
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy");
    private static final DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"HH:mm");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter shortDateTimeFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm");
    private DateTime dateTimeToSet;
    private final DateTime dateTimeOffset;
    private DateTime fixedDateTime;

    public DateTimeConfiguration() {
        this.dateTimeToSet = null;
        this.dateTimeOffset = null;
        this.fixedDateTime = null;
    }

    public DateTimeConfiguration(DateTime dateTimeToSet, DateTime fixedDateTime) {
        this.dateTimeToSet = dateTimeToSet;
        this.fixedDateTime = fixedDateTime;
        this.dateTimeOffset = DateTime.now();
    }

    public boolean hasConfiguration() {
        return this.dateTimeOffset != null && this.dateTimeToSet != null;
    }

    public DateTime getDateTime() {
        if (this.hasConfiguration()) {
            long offset = DateTime.now().getMillis() - this.dateTimeOffset.getMillis();
            return this.dateTimeToSet.plusMillis((int)offset);
        }
        if (this.fixedDateTime != null) {
            return this.fixedDateTime;
        }
        return DateTime.now();
    }

    public DateTime getDateTimeToSet() {
        return this.dateTimeToSet;
    }

    public DateTime getDateTimeOffset() {
        return this.dateTimeOffset;
    }

    public String getTaskArgumentString() {
        return String.format("%s %s", fullFormatter.print((ReadableInstant)this.dateTimeToSet), fullFormatter.print((ReadableInstant)this.dateTimeOffset));
    }

    public DateTime getFixedDateTime() {
        return this.fixedDateTime;
    }

    public String getFixedDateTimeString() {
        return this.fixedDateTime != null ? dateTimeFormatter.print((ReadableInstant)this.fixedDateTime) : null;
    }

    public static String getLocalDate() {
        return dateFormatter.print((ReadableInstant)DateTime.now());
    }

    public static String getLocalTime() {
        return timeFormatter.print((ReadableInstant)DateTime.now());
    }

    public static String getLocalDateTime() {
        return shortDateTimeFormatter.print((ReadableInstant)DateTime.now());
    }

    public void fixDateTime() {
        if (this.fixedDateTime == null) {
            this.fixedDateTime = DateTime.now();
        }
    }

    public static DateTime getDateTime(String date, String time) throws IllegalArgumentException {
        if (date == null || date.isEmpty()) {
            date = dateFormatter.print((ReadableInstant)DateTime.now());
        }
        if (time == null || time.isEmpty()) {
            time = timeFormatter.print((ReadableInstant)DateTime.now());
        }
        return shortDateTimeFormatter.parseDateTime(String.format("%s %s", date, time));
    }

    public static DateTime parseFixedDateTime(String dateTimeString) {
        return dateTimeFormatter.parseDateTime(dateTimeString);
    }

    public boolean hasChanged() {
        DateTime effectiveDateTimeToSet = this.getDateTimeToSet();
        DateTime currentDateTime = this.getFixedDateTime();
        return effectiveDateTimeToSet.getYear() != currentDateTime.getYear() || effectiveDateTimeToSet.getMonthOfYear() != currentDateTime.getMonthOfYear() || effectiveDateTimeToSet.getDayOfMonth() != currentDateTime.getDayOfMonth() || effectiveDateTimeToSet.getHourOfDay() != currentDateTime.getHourOfDay() || effectiveDateTimeToSet.getMinuteOfHour() != currentDateTime.getMinuteOfHour();
    }
}

