/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.LogLevel;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.core.ESLSystemDefaults;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationForm {
    public static final String WIRELESS_FORM = "wireless-form";
    public static final String NETWORK_FORM = "network-form";
    public static final String DATETIME_FORM = "datetime-form";
    public static final String MSP_FORM = "msp-form";
    public static final String AUTOCONFIG_FORM = "autoConfig-form";
    public static final String BROADCAST_FORM = "broadcast-form";
    public static final String LOGGING_FORM = "logging-form";
    public static final String SERIAL_FORM = "serial-form";
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private final String formName;
    private Map<String, String> values;
    private Map<String, List<String>> messages;

    public ConfigurationForm(String formName) throws InitializationException {
        if (formName.equals(WIRELESS_FORM)) {
            this.initWirelessForm();
        } else if (formName.equals(NETWORK_FORM)) {
            this.initNetworkForm();
        } else if (formName.equals(DATETIME_FORM)) {
            this.initTimesyncForm();
        } else if (formName.equals(MSP_FORM)) {
            this.initMSPForm();
        } else if (formName.equals(AUTOCONFIG_FORM)) {
            this.initAutoConfigForm();
        } else if (formName.equals(BROADCAST_FORM)) {
            this.initBroadcastForm();
        } else if (formName.equals(LOGGING_FORM)) {
            this.initLoggingForm();
        } else if (formName.equals(SERIAL_FORM)) {
            this.initSerialForm();
        } else {
            throw new InitializationException("Form type not supported", new Object[0]);
        }
        this.formName = formName;
    }

    public ConfigurationForm(MSPConfiguration mspConfiguration, boolean autoConfig) throws InitializationException {
        this.formName = MSP_FORM;
        this.initMSPForm();
        this.values.put("relayHostname", mspConfiguration.getHost());
        this.values.put("port", String.valueOf(mspConfiguration.getPort()));
        this.values.put("username", mspConfiguration.getUsername());
        this.values.put("password", mspConfiguration.getPassword());
        this.values.put("path", mspConfiguration.getPath());
        this.values.put("enabled", String.valueOf(mspConfiguration.isEnabled()));
        this.values.put("uploadInterval", String.valueOf(mspConfiguration.getUploadInterval()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(NetworkConfiguration networkInfo, boolean autoConfig) throws InitializationException {
        this.formName = NETWORK_FORM;
        this.initNetworkForm();
        this.values.put("hostname", networkInfo.getHostName());
        this.values.put("dhcp", String.valueOf(networkInfo.isDhcp()));
        this.values.put("address", networkInfo.getAddress());
        this.values.put("gateway", networkInfo.getGateway());
        this.values.put("nameserver1", networkInfo.getNameServer1());
        this.values.put("nameserver2", networkInfo.getNameServer2());
        this.values.put("netmask", networkInfo.getNetmask());
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(TimesyncConfiguration timesyncConfiguration, TimeZoneConfiguration timeZoneConfiguration, boolean autoConfig) throws InitializationException {
        this.formName = DATETIME_FORM;
        this.initTimesyncForm();
        this.values.put("updateInterval", String.valueOf(timesyncConfiguration.getUpdateInterval()));
        this.values.put("timeServer", timesyncConfiguration.getTimeServer());
        this.values.put("enabled", String.valueOf(timesyncConfiguration.isEnabled()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
        this.values.put("timeZone", timeZoneConfiguration.getTimeZoneString());
    }

    public ConfigurationForm(WirelessConfiguration transmissionConfiguration, boolean autoConfig) throws InitializationException {
        this.formName = WIRELESS_FORM;
        this.initWirelessForm();
        this.values.put("autoConfig", String.valueOf(autoConfig));
        this.values.put("wirelessChannel", transmissionConfiguration.getChannel() != null ? Integer.toString(transmissionConfiguration.getChannel().getChannelId()) : "");
    }

    public ConfigurationForm(boolean autoConfig) throws InitializationException {
        this.formName = AUTOCONFIG_FORM;
        this.initAutoConfigForm();
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(BroadcastConfiguration broadcastConfiguration, boolean autoConfig) throws InitializationException {
        this.formName = BROADCAST_FORM;
        this.initBroadcastForm();
        this.values.put("enabled", String.valueOf(broadcastConfiguration.isBroadcastEnabled()));
        this.values.put("broadcastPort", String.valueOf(broadcastConfiguration.getBroadcastPort()));
        this.values.put("broadcastIntervalInMinutes", String.valueOf(broadcastConfiguration.getTimeIntervalInMinutes()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(LoggingConfiguration loggingConfiguration, boolean autoConfig) throws InitializationException {
        this.formName = LOGGING_FORM;
        this.initLoggingForm();
        this.values.put("socketAppenderEnabled", String.valueOf(loggingConfiguration.isSocketAppenderEnabled()));
        this.values.put("socketPort", String.valueOf(loggingConfiguration.getSocketAppenderPort()));
        this.values.put("logLevel", loggingConfiguration.getLogLevel().toString());
        this.values.put("socketRemoteAddress", loggingConfiguration.getSocketRemoteAddress());
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    private void initSerialForm() {
        this.values = new HashMap<String, String>();
        this.values.put("wiSpyEnabled", "");
        this.values.put("startFrequency", "");
        this.values.put("endFrequency", "");
        this.values.put("numberOfSweeps", "");
        this.values.put("channelFilterBandwidth", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("wiSpyEnabled", new ArrayList());
        this.messages.put("startFrequency", new ArrayList());
        this.messages.put("endFrequency", new ArrayList());
        this.messages.put("numberOfSweeps", new ArrayList());
        this.messages.put("channelFilterBandwidth", new ArrayList());
    }

    private void initLoggingForm() {
        this.values = new HashMap<String, String>();
        this.values.put("socketAppenderEnabled", "");
        this.values.put("socketPort", "");
        this.values.put("logLevel", "");
        this.values.put("socketRemoteAddress", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("socketAppenderEnabled", new ArrayList());
        this.messages.put("socketPort", new ArrayList());
        this.messages.put("logLevel", new ArrayList());
        this.messages.put("socketRemoteAddress", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initNetworkForm() {
        this.values = new HashMap<String, String>();
        this.values.put("hostname", "");
        this.values.put("dhcp", "");
        this.values.put("address", "");
        this.values.put("gateway", "");
        this.values.put("nameserver1", "");
        this.values.put("nameserver2", "");
        this.values.put("netmask", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("hostname", new ArrayList());
        this.messages.put("dhcp", new ArrayList());
        this.messages.put("address", new ArrayList());
        this.messages.put("gateway", new ArrayList());
        this.messages.put("nameserver1", new ArrayList());
        this.messages.put("nameserver2", new ArrayList());
        this.messages.put("netmask", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initMSPForm() {
        this.values = new HashMap<String, String>();
        this.values.put("relayHostname", "");
        this.values.put("port", "");
        this.values.put("username", "");
        this.values.put("password", "");
        this.values.put("path", "");
        this.values.put("enabled", "");
        this.values.put("uploadInterval", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("relayHostname", new ArrayList());
        this.messages.put("port", new ArrayList());
        this.messages.put("username", new ArrayList());
        this.messages.put("password", new ArrayList());
        this.messages.put("path", new ArrayList());
        this.messages.put("enabled", new ArrayList());
        this.messages.put("uploadInterval", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initTimesyncForm() {
        this.values = new HashMap<String, String>();
        this.values.put("updateInterval", "");
        this.values.put("timeServer", "");
        this.values.put("enabled", "");
        this.values.put("autoConfig", "");
        this.values.put("timeZone", "");
        this.values.put("day", "");
        this.values.put("month", "");
        this.values.put("year", "");
        this.values.put("hours", "");
        this.values.put("minutes", "");
        this.values.put("fixedDateTime", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("updateInterval", new ArrayList());
        this.messages.put("timeServer", new ArrayList());
        this.messages.put("enabled", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
        this.messages.put("timeZone", new ArrayList());
        this.messages.put("day", new ArrayList());
        this.messages.put("month", new ArrayList());
        this.messages.put("year", new ArrayList());
        this.messages.put("hours", new ArrayList());
        this.messages.put("minutes", new ArrayList());
        this.messages.put("fixedDateTime", new ArrayList());
    }

    private void updateDateTime(DateTimeConfiguration dateTimeConfiguration) {
        dateTimeConfiguration.fixDateTime();
        DateTime dateTime = dateTimeConfiguration.getDateTime();
        this.values.put("day", String.valueOf(dateTime.getDayOfMonth()));
        this.values.put("month", String.valueOf(dateTime.getMonthOfYear()));
        this.values.put("year", String.valueOf(dateTime.getYear()));
        this.values.put("hours", String.valueOf(dateTime.getHourOfDay()));
        this.values.put("minutes", String.valueOf(dateTime.getMinuteOfHour()));
        this.values.put("fixedDateTime", dateTimeConfiguration.getFixedDateTimeString());
    }

    private void initWirelessForm() {
        this.values = new HashMap<String, String>();
        this.values.put("wirelessChannel", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("wirelessChannel", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initAutoConfigForm() {
        this.values = new HashMap<String, String>();
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initBroadcastForm() {
        this.values = new HashMap<String, String>();
        this.values.put("enabled", "");
        this.values.put("broadcastPort", "");
        this.values.put("broadcastIntervalInMinutes", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("enabled", new ArrayList());
        this.messages.put("broadcastPort", new ArrayList());
        this.messages.put("broadcastIntervalInMinutes", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    public String getFormName() {
        return this.formName;
    }

    public void setValue(String key, String value) {
        if (this.values.containsKey(key)) {
            this.values.put(key, value);
        }
    }

    public String getValue(String key) {
        String value = this.values.get(key);
        return value != null ? value : "";
    }

    public void addMessage(String key, String message) {
        if (this.messages.containsKey(key) && !this.messages.get(key).contains(message)) {
            this.messages.get(key).add(message);
        }
    }

    public Map<String, List<String>> getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        for (String fieldName : this.messages.keySet()) {
            this.messages.get(fieldName).clear();
        }
    }

    public Document toXML(DateTimeConfiguration dateTimeConfiguration) {
        String[] timeZones;
        this.updateDateTime(dateTimeConfiguration);
        Document document = this.toXML();
        Element timeZonesElement = document.createElement("timeZones");
        for (String timeZoneId : timeZones = TimeZone.getAvailableIDs()) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            Element timeZoneElement = document.createElement("timeZone");
            timeZoneElement.setAttribute("value", TimeZoneConfiguration.toTimeZoneString(timeZone));
            timeZoneElement.setAttribute("offset", TimeZoneConfiguration.toOffsetString(timeZone));
            timeZoneElement.setAttribute("rawOffset", String.valueOf(timeZone.getRawOffset()));
            timeZonesElement.appendChild(timeZoneElement);
        }
        document.getDocumentElement().appendChild(timeZonesElement);
        return document;
    }

    public Document toXML() {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement(this.formName);
        if (this.formName == WIRELESS_FORM) {
            Element channelsElement = document.createElement("channels");
            for (Enum enum_ : WirelessChannel.values()) {
                Element channelElement = document.createElement("channel");
                channelElement.setAttribute("id", String.valueOf(((WirelessChannel)enum_).getChannelId()));
                channelElement.setAttribute("caption", String.valueOf(((WirelessChannel)enum_).getChannelId()));
                channelElement.setAttribute("frequency", String.format("%.0f", ((WirelessChannel)enum_).getPeakFrequency()));
                channelsElement.appendChild(channelElement);
            }
            root.appendChild(channelsElement);
        } else if (this.formName == LOGGING_FORM) {
            Element logLevelsElement = document.createElement("logLevels");
            for (Enum enum_ : LogLevel.values()) {
                Element logLevelElement = document.createElement("logLevel");
                logLevelElement.setAttribute("id", String.valueOf(enum_.toString()));
                logLevelElement.setAttribute("caption", String.valueOf(enum_.toString()));
                logLevelsElement.appendChild(logLevelElement);
            }
            root.appendChild(logLevelsElement);
        }
        for (String key : this.values.keySet()) {
            Element element = document.createElement(key);
            element.setAttribute("value", this.values.get(key));
            if (this.messages.get(key).size() > 0) {
                element.setAttribute("message", this.messages.get(key).get(0));
            }
            root.appendChild(element);
        }
        document.appendChild(root);
        return document;
    }

    public NetworkConfiguration toNetworkConfiguration() {
        String hostName = this.getValue("hostname");
        boolean dhcp = Boolean.valueOf(this.getValue("dhcp"));
        if (dhcp) {
            return new NetworkConfiguration(hostName);
        }
        return new NetworkConfiguration(hostName, this.getValue("address"), this.getValue("netmask"), this.getValue("gateway"), this.getValue("nameserver1"), this.getValue("nameserver2"));
    }

    public MSPConfiguration toMSPConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        String hostName = this.getValue("relayHostname");
        String username = this.getValue("username");
        String password = this.getValue("password");
        String path = this.getValue("path");
        int uploadInterval = 0;
        int port = 0;
        try {
            port = Integer.parseInt(this.getValue("port"));
        }
        catch (NumberFormatException exc) {
            port = 21;
        }
        try {
            uploadInterval = Integer.parseInt(this.getValue("uploadInterval"));
        }
        catch (NumberFormatException exc) {
            uploadInterval = 15;
        }
        return new MSPConfiguration(hostName, port, username, password, path, uploadInterval, enabled);
    }

    public TimesyncConfiguration toTimesyncConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        String timeServer = this.getValue("timeServer");
        int updateInterval = 0;
        try {
            updateInterval = Integer.parseInt(this.getValue("updateInterval"));
        }
        catch (NumberFormatException exc) {
            updateInterval = 60;
        }
        return new TimesyncConfiguration(enabled, timeServer, updateInterval);
    }

    public TimeZoneConfiguration toTimeZoneConfiguration() {
        String timeZoneString = this.getValue("timeZone");
        TimeZone timeZone = TimeZoneConfiguration.fromString(timeZoneString);
        return new TimeZoneConfiguration(timeZone);
    }

    public WirelessConfiguration toWirelessConfiguration() {
        String channelString = this.getValue("wirelessChannel");
        if (channelString != null && !channelString.isEmpty()) {
            int channelId = Integer.parseInt(channelString);
            return new WirelessConfiguration(WirelessChannel.getFromId(channelId));
        }
        return new WirelessConfiguration();
    }

    public boolean toAutoConfigConfiguration() {
        return Boolean.valueOf(this.getValue("autConfig"));
    }

    public BroadcastConfiguration toBroadcastConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        int broadcastPort = 0;
        int broadcastIntervalInMinutes = 0;
        try {
            broadcastPort = Integer.valueOf(this.getValue("broadcastPort"));
        }
        catch (NumberFormatException exc) {
            broadcastPort = ESLSystemDefaults.DEFAULT_DISCOVERY_BROADCAST_PORT;
        }
        try {
            broadcastIntervalInMinutes = Integer.valueOf(this.getValue("broadcastIntervalInMinutes"));
        }
        catch (NumberFormatException exc) {
            broadcastIntervalInMinutes = BroadcastConfiguration.DEFAULT_DISCOVERY_BROADCAST_INTERVAL_IN_MINUTES;
        }
        return new BroadcastConfiguration(enabled, broadcastIntervalInMinutes, broadcastPort);
    }

    public LoggingConfiguration toLoggingConfiguration() {
        int socketPort;
        boolean socketAppenderEnabled = Boolean.valueOf(this.getValue("socketAppenderEnabled"));
        String socketRemoteAddress = this.getValue("socketRemoteAddress");
        LogLevel logLevel = LogLevel.parseString(this.getValue("logLevel"));
        try {
            socketPort = Integer.valueOf(this.getValue("socketPort"));
        }
        catch (NumberFormatException exc) {
            socketPort = -1;
        }
        if (socketPort > 0 && socketRemoteAddress != null && !socketRemoteAddress.isEmpty()) {
            return new LoggingConfiguration(logLevel, socketPort, socketRemoteAddress, socketAppenderEnabled);
        }
        return new LoggingConfiguration(logLevel);
    }

    public DateTimeConfiguration toDateTimeConfiguration() {
        String day = this.getValue("day");
        String month = this.getValue("month");
        String year = this.getValue("year");
        String hours = this.getValue("hours");
        String minutes = this.getValue("minutes");
        try {
            DateTime dateTime = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm").parseDateTime(String.format("%s.%s.%s %s:%s", day, month, year, hours, minutes));
            DateTime fixedDateTime = DateTimeConfiguration.parseFixedDateTime(this.getValue("fixedDateTime"));
            return new DateTimeConfiguration(dateTime, fixedDateTime);
        }
        catch (IllegalArgumentException exc) {
            return new DateTimeConfiguration();
        }
    }
}

