/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.AutoConfiguration;
import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ConfigurationChangeManager {
    private final MessageDigest md5;

    public ConfigurationChangeManager() throws InitializationException {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public <T> boolean hasChanged(T oldObject, T newObject) {
        return this.compareHashes(this.getHash(oldObject), this.getHash(newObject));
    }

    private <T> String getHash(T object) {
        String message = this.getMessage(object);
        byte[] byteMessage = message.getBytes();
        this.md5.update(byteMessage);
        byte[] digest = this.md5.digest();
        return new BigInteger(1, digest).toString(16);
    }

    private boolean compareHashes(String hash1, String hash2) {
        return !hash1.equals(hash2);
    }

    private <T> String getMessage(T object) {
        if (object instanceof AutoConfiguration) {
            return this.constructMessage((AutoConfiguration)object);
        }
        if (object instanceof WirelessConfiguration) {
            return this.constructMessage((WirelessConfiguration)object);
        }
        if (object instanceof NetworkConfiguration) {
            return this.constructMessage((NetworkConfiguration)object);
        }
        if (object instanceof TimesyncConfiguration) {
            return this.constructMessage((TimesyncConfiguration)object);
        }
        if (object instanceof MSPConfiguration) {
            return this.constructMessage((MSPConfiguration)object);
        }
        if (object instanceof BroadcastConfiguration) {
            return this.constructMessage((BroadcastConfiguration)object);
        }
        if (object instanceof LoggingConfiguration) {
            return this.constructMessage((LoggingConfiguration)object);
        }
        throw new IllegalArgumentException("Unknown type for change manager");
    }

    private String constructMessage(AutoConfiguration autoConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(autoConfiguration.isEnabled());
        return sb.toString();
    }

    private String constructMessage(WirelessConfiguration wirelessConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(wirelessConfiguration.getRadioOutputPowerLevel());
        sb.append(wirelessConfiguration.getPayloadSize());
        sb.append(wirelessConfiguration.getWindowSize());
        if (wirelessConfiguration.getChannel() != null) {
            sb.append(wirelessConfiguration.getChannel().getChannelId());
        }
        return sb.toString();
    }

    private String constructMessage(NetworkConfiguration networkConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(networkConfiguration.getHostName());
        sb.append(networkConfiguration.getAddress());
        sb.append(networkConfiguration.getGateway());
        sb.append(networkConfiguration.getNameServer1());
        sb.append(networkConfiguration.getNameServer2());
        sb.append(networkConfiguration.getNetmask());
        sb.append(networkConfiguration.isDhcp());
        return sb.toString();
    }

    private String constructMessage(TimesyncConfiguration timesyncConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(timesyncConfiguration.isEnabled());
        sb.append(timesyncConfiguration.getTimeServer());
        sb.append(timesyncConfiguration.getUpdateInterval());
        return sb.toString();
    }

    private String constructMessage(MSPConfiguration mspConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(mspConfiguration.getHost());
        sb.append(mspConfiguration.getPort());
        sb.append(mspConfiguration.getUsername());
        sb.append(mspConfiguration.getPassword());
        sb.append(mspConfiguration.getPath());
        sb.append(mspConfiguration.isEnabled());
        sb.append(mspConfiguration.getUploadInterval());
        return sb.toString();
    }

    private String constructMessage(BroadcastConfiguration broadcastConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(broadcastConfiguration.isBroadcastEnabled());
        sb.append(broadcastConfiguration.getBroadcastPort());
        sb.append(broadcastConfiguration.getTimeIntervalInMinutes());
        return sb.toString();
    }

    private String constructMessage(LoggingConfiguration loggingConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(loggingConfiguration.getSocketAppenderPort());
        sb.append(loggingConfiguration.getSocketRemoteAddress());
        sb.append(loggingConfiguration.isSocketAppenderEnabled());
        sb.append(loggingConfiguration.getLogLevel().toString());
        return sb.toString();
    }
}

