/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.AutoConfiguration;
import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.BroadcastMessage;
import at.mrdevelopment.esl.admin.LogLevel;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccessPointConfigurationXMLSerializer
implements XMLSerializer<Object> {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointConfigurationXMLSerializer.class);
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(AccessPointConfiguration accessPointConfiguration) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("configuration");
        root.setAttribute("autoConfig", String.valueOf(accessPointConfiguration.getAutoConfiguration().isEnabled()));
        root.appendChild(this.toXML(accessPointConfiguration.getNetworkConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getWirelessConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getMSPConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getTimesyncConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getBroadcastConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getLoggingConfiguration(), document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(NetworkConfiguration networkInfo, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("network-form");
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.appendChild(this.toXML(networkInfo, document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(WirelessConfiguration transmissionConfiguration, boolean autoConfig) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("wireless-form");
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        Element channelsElement = document.createElement("channels");
        for (WirelessChannel channel : WirelessChannel.values()) {
            Element channelElement = document.createElement("channel");
            channelElement.setAttribute("id", String.valueOf(channel.getChannelId()));
            channelElement.setAttribute("caption", String.valueOf(channel.getChannelId()));
            channelsElement.appendChild(channelElement);
        }
        root.appendChild(channelsElement);
        Element transmissionConfigurationElement = this.toXML(transmissionConfiguration, document);
        if (transmissionConfiguration != null) {
            root.appendChild(transmissionConfigurationElement);
        }
        document.appendChild(root);
        return document;
    }

    public Document toXML(MSPConfiguration mspConfiguration, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("msp-form");
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.appendChild(this.toXML(mspConfiguration, document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(boolean autoConfig) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("autoConfig-form");
        Element configurationElement = document.createElement("configuration");
        configurationElement.setAttribute("autoConfig", String.valueOf(autoConfig));
        root.appendChild(configurationElement);
        document.appendChild(root);
        return document;
    }

    public Document toXML(TimesyncConfiguration timesyncConfiguration, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("timesync-form");
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        root.appendChild(this.toXML(timesyncConfiguration, document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(LoggingConfiguration loggingConfiguration, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("logging-form");
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        root.appendChild(this.toXML(loggingConfiguration, document));
        document.appendChild(root);
        return document;
    }

    public AccessPointConfiguration parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        boolean autoConfigEnabled = Boolean.parseBoolean(root.getAttribute("autoConfig"));
        AutoConfiguration autoConfiguration = new AutoConfiguration(autoConfigEnabled);
        NetworkConfiguration networkConfiguration = null;
        WirelessConfiguration wirelessConfiguration = null;
        MSPConfiguration mspConfiguration = null;
        TimesyncConfiguration timesyncConfiguration = null;
        BroadcastConfiguration broadcastConfiguration = null;
        LoggingConfiguration loggingConfiguration = null;
        NodeList networkNodes = root.getElementsByTagName("network");
        NodeList wirelessNodes = root.getElementsByTagName("wireless");
        NodeList mspNodes = root.getElementsByTagName("msp");
        NodeList timesyncNodes = root.getElementsByTagName("timesync");
        NodeList broadcastNodes = root.getElementsByTagName("broadcast");
        NodeList loggingNodes = root.getElementsByTagName("logging");
        networkConfiguration = networkNodes.getLength() > 0 ? this.parseNetworkInfoXML((Element)networkNodes.item(0)) : new NetworkConfiguration();
        wirelessConfiguration = wirelessNodes.getLength() > 0 ? this.parseTransmissionConfigurationXML((Element)wirelessNodes.item(0)) : new WirelessConfiguration();
        mspConfiguration = mspNodes.getLength() > 0 ? this.parseMSPConfigurationXML((Element)mspNodes.item(0)) : new MSPConfiguration();
        timesyncConfiguration = timesyncNodes.getLength() > 0 ? this.parseTimesyncConfigurationXML((Element)timesyncNodes.item(0)) : new TimesyncConfiguration();
        broadcastConfiguration = broadcastNodes.getLength() > 0 ? this.parseBroadcastConfigurationXML((Element)broadcastNodes.item(0)) : new BroadcastConfiguration();
        loggingConfiguration = loggingNodes.getLength() > 0 ? this.parseLoggingConfigurationXML((Element)loggingNodes.item(0)) : new LoggingConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration);
    }

    public int parseAccessPointSerial(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        return Integer.parseInt(root.getAttribute("serial"));
    }

    private Element toXML(NetworkConfiguration networkConfiguration, Document document) {
        Element networkElement = document.createElement("network");
        networkElement.setAttribute("hostname", networkConfiguration.getHostName());
        networkElement.setAttribute("dhcp", Boolean.toString(networkConfiguration.isDhcp()));
        if (!networkConfiguration.isDhcp()) {
            networkElement.setAttribute("address", networkConfiguration.getAddress());
            networkElement.setAttribute("netmask", networkConfiguration.getNetmask());
            networkElement.setAttribute("gateway", networkConfiguration.getGateway());
            networkElement.setAttribute("nameserver1", networkConfiguration.getNameServer1());
            networkElement.setAttribute("nameserver2", networkConfiguration.getNameServer2());
        }
        return networkElement;
    }

    private Element toXML(LoggingConfiguration loggingConfiguration, Document document) {
        Element loggingElement = document.createElement("logging");
        loggingElement.setAttribute("socketRemoteAddress", loggingConfiguration.getSocketRemoteAddress());
        loggingElement.setAttribute("socketPort", String.valueOf(loggingConfiguration.getSocketAppenderPort()));
        loggingElement.setAttribute("socketAppenderEnabled", Boolean.toString(loggingConfiguration.isSocketAppenderEnabled()));
        loggingElement.setAttribute("logLevel", loggingConfiguration.getLogLevel().toString());
        return loggingElement;
    }

    private Element toXML(TimesyncConfiguration timesyncConfiguration, Document document) {
        Element timesyncElement = document.createElement("timesync");
        timesyncElement.setAttribute("timeServer", timesyncConfiguration.getTimeServer());
        timesyncElement.setAttribute("enabled", Boolean.toString(timesyncConfiguration.isEnabled()));
        timesyncElement.setAttribute("updateInterval", Integer.toString(timesyncConfiguration.getUpdateInterval()));
        return timesyncElement;
    }

    private LoggingConfiguration parseLoggingConfigurationXML(Element loggingElement) throws SerializeException {
        String logLevel = loggingElement.getAttribute("logLevel");
        try {
            String socketRemoteAddress = loggingElement.getAttribute("socketRemoteAddress");
            int socketPort = Integer.parseInt(loggingElement.getAttribute("socketPort"));
            boolean socketAppenderEnabled = Boolean.parseBoolean(loggingElement.getAttribute("socketAppenderEnabled"));
            return new LoggingConfiguration(LogLevel.valueOf(logLevel), socketPort, socketRemoteAddress, socketAppenderEnabled);
        }
        catch (Exception exc) {
            logger.info("Error parsing logging configuration. Logging set to default.");
            return new LoggingConfiguration();
        }
    }

    private NetworkConfiguration parseNetworkInfoXML(Element networkElement) throws SerializeException {
        boolean dhcp;
        String hostName = networkElement.getAttribute("hostname");
        boolean bl = dhcp = networkElement.hasAttribute("dhcp") ? Boolean.parseBoolean(networkElement.getAttribute("dhcp")) : true;
        if (dhcp) {
            return new NetworkConfiguration(hostName);
        }
        String address = networkElement.getAttribute("address");
        String netmask = networkElement.getAttribute("netmask");
        String gateway = networkElement.getAttribute("gateway");
        String nameServer1 = networkElement.getAttribute("nameserver1");
        String nameServer2 = networkElement.getAttribute("nameserver2");
        return new NetworkConfiguration(hostName, address, netmask, gateway, nameServer1, nameServer2);
    }

    private MSPConfiguration parseMSPConfigurationXML(Element mspElement) throws SerializeException {
        try {
            boolean enabled = Boolean.parseBoolean(mspElement.getAttribute("enabled"));
            String hostName = mspElement.getAttribute("relayHostname");
            int port = Integer.parseInt(mspElement.getAttribute("port"));
            String username = mspElement.getAttribute("username");
            String password = mspElement.getAttribute("password");
            String path = mspElement.getAttribute("path");
            int uploadInterval = Integer.parseInt(mspElement.getAttribute("uploadInterval"));
            if (hostName != null && username != null && password != null && path != null) {
                return new MSPConfiguration(hostName, port, username, password, path, uploadInterval, enabled);
            }
            return new MSPConfiguration();
        }
        catch (Exception exc) {
            logger.info("Error parsing MSP configuration. MSP disabled.");
            return new MSPConfiguration();
        }
    }

    private TimesyncConfiguration parseTimesyncConfigurationXML(Element timesyncElement) throws SerializeException {
        try {
            boolean enabled = Boolean.parseBoolean(timesyncElement.getAttribute("enabled"));
            String ntpServer = timesyncElement.getAttribute("timeServer");
            int updateInterval = Integer.parseInt(timesyncElement.getAttribute("updateInterval"));
            if (ntpServer != null) {
                return new TimesyncConfiguration(enabled, ntpServer, updateInterval);
            }
            return new TimesyncConfiguration();
        }
        catch (Exception exc) {
            logger.info("Error parsing timesync configuration. Timesync disabled.");
            return new TimesyncConfiguration();
        }
    }

    private Element toXML(WirelessConfiguration transmissionConfiguration, Document document) {
        Element wirlessElement = document.createElement("wireless");
        if (transmissionConfiguration.getChannel() != null) {
            wirlessElement.setAttribute("channel", Integer.toString(transmissionConfiguration.getChannel().getChannelId()));
        }
        return wirlessElement;
    }

    private WirelessConfiguration parseTransmissionConfigurationXML(Element wirelessElement) throws SerializeException {
        try {
            if (wirelessElement.hasAttribute("channel")) {
                int channelId = Integer.parseInt(wirelessElement.getAttribute("channel"));
                return new WirelessConfiguration(WirelessChannel.getFromId(channelId));
            }
            return new WirelessConfiguration();
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Element toXML(MSPConfiguration mspConfiguration, Document document) {
        Element mspElement = document.createElement("msp");
        if (mspConfiguration.getHost() != null) {
            mspElement.setAttribute("relayHostname", mspConfiguration.getHost());
        }
        if (mspConfiguration.getPassword() != null) {
            mspElement.setAttribute("password", mspConfiguration.getPassword());
        }
        if (mspConfiguration.getPath() != null) {
            mspElement.setAttribute("path", mspConfiguration.getPath());
        }
        if (mspConfiguration.getUsername() != null) {
            mspElement.setAttribute("username", mspConfiguration.getUsername());
        }
        mspElement.setAttribute("port", String.valueOf(mspConfiguration.getPort()));
        mspElement.setAttribute("enabled", String.valueOf(mspConfiguration.isEnabled()));
        mspElement.setAttribute("uploadInterval", String.valueOf(mspConfiguration.getUploadInterval()));
        return mspElement;
    }

    private BroadcastConfiguration parseBroadcastConfigurationXML(Element broadcastElement) {
        boolean broadcastEnabled = Boolean.parseBoolean(broadcastElement.getAttribute("enabled"));
        try {
            int broadcastInterval = Integer.parseInt(broadcastElement.getAttribute("broadcastIntervalInMinutes"));
            int broadcastPort = Integer.parseInt(broadcastElement.getAttribute("broadcastPort"));
            return new BroadcastConfiguration(broadcastEnabled, broadcastInterval, broadcastPort);
        }
        catch (Exception exc) {
            return new BroadcastConfiguration(broadcastEnabled);
        }
    }

    private Element toXML(BroadcastConfiguration broadcastConfiguration, Document document) {
        Element broadcastElement = document.createElement("broadcast");
        broadcastElement.setAttribute("enabled", String.valueOf(broadcastConfiguration.isBroadcastEnabled()));
        broadcastElement.setAttribute("broadcastPort", String.valueOf(broadcastConfiguration.getBroadcastPort()));
        broadcastElement.setAttribute("broadcastIntervalInMinutes", String.valueOf(broadcastConfiguration.getTimeIntervalInMinutes()));
        return broadcastElement;
    }

    public Document toBroadcastMessageXML(BroadcastMessage broadcastMessage) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("broadcastMessage");
        root.setAttribute("id", Integer.toString(broadcastMessage.getAccessPointId()));
        root.setAttribute("version", broadcastMessage.getVersion().getVersionString());
        root.setAttribute("autoConfig", Boolean.toString(broadcastMessage.isAutoConfig()));
        root.setAttribute("ssl", Boolean.toString(broadcastMessage.isSsl()));
        root.setAttribute("port", Integer.toString(broadcastMessage.getPort()));
        document.appendChild(root);
        return document;
    }

    public BroadcastMessage parseBroadcastMessageXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        Version version = Version.UNDEFINED;
        try {
            version = Version.fromString((String)root.getAttribute("version"));
            int accessPointId = Integer.parseInt(root.getAttribute("id"));
            boolean autoConfig = Boolean.parseBoolean(root.getAttribute("autoConfig"));
            boolean ssl = Boolean.parseBoolean(root.getAttribute("ssl"));
            int port = Integer.parseInt(root.getAttribute("port"));
            return new BroadcastMessage(accessPointId, autoConfig, version, ssl, port);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public String toString(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return writer.toString();
    }

    private Element toXML(String error, List<String> messages, Document document) {
        Element errorElement = document.createElement("error");
        errorElement.setAttribute("message", error);
        int causeCount = 0;
        for (String message : messages) {
            errorElement.setAttribute("cause" + String.valueOf(++causeCount), message);
        }
        return errorElement;
    }

    public Document createChangePasswordXML() {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("root");
        Element changePasswordElement = document.createElement("changePassword");
        root.appendChild(changePasswordElement);
        document.appendChild(root);
        return document;
    }
}

