/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.AutoConfiguration;
import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.msp.MSPConfiguration;

public class AccessPointConfiguration {
    private final AutoConfiguration autoConfiguration;
    private final WirelessConfiguration wirelessConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final TimesyncConfiguration timesyncConfiguration;
    private final MSPConfiguration mspConfiguration;
    private final BroadcastConfiguration broadcastConfiguration;
    private final LoggingConfiguration loggingConfiguration;

    public static AccessPointConfiguration newDefaultConfiguration() {
        AutoConfiguration autoConfiguration = new AutoConfiguration();
        WirelessConfiguration wirelessConfiguration = new WirelessConfiguration();
        NetworkConfiguration networkConfiguration = new NetworkConfiguration();
        TimesyncConfiguration timesyncConfiguration = new TimesyncConfiguration();
        MSPConfiguration mspConfiguration = new MSPConfiguration();
        BroadcastConfiguration broadcastConfiguration = new BroadcastConfiguration();
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration);
    }

    public static AccessPointConfiguration newDefaultConfiguration(int accessPointId) {
        AutoConfiguration autoConfiguration = new AutoConfiguration();
        WirelessConfiguration wirelessConfiguration = new WirelessConfiguration();
        NetworkConfiguration networkConfiguration = AccessPointConfiguration.newDefaultNetworkConfiguration(accessPointId);
        TimesyncConfiguration timesyncConfiguration = new TimesyncConfiguration();
        MSPConfiguration mspConfiguration = new MSPConfiguration();
        BroadcastConfiguration broadcastConfiguration = new BroadcastConfiguration();
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration);
    }

    public static NetworkConfiguration newDefaultNetworkConfiguration(int accessPointId) {
        return new NetworkConfiguration(AccessPointConfiguration.newDefaultHostName(accessPointId));
    }

    public static NetworkConfiguration newNetworkConfiguration(int accessPointId, NetworkConfiguration networkConfiguration) {
        return new NetworkConfiguration(AccessPointConfiguration.newDefaultHostName(accessPointId), networkConfiguration);
    }

    private static String newDefaultHostName(int accessPointId) {
        return String.format("ap-%s", accessPointId);
    }

    public AccessPointConfiguration(AutoConfiguration autoConfiguration, WirelessConfiguration wirelessConfiguration, NetworkConfiguration networkConfiguration, TimesyncConfiguration timesyncConfiguration, MSPConfiguration mspConfiguration, BroadcastConfiguration broadcastConfiguration, LoggingConfiguration loggingConfiguration) {
        this.autoConfiguration = autoConfiguration;
        this.wirelessConfiguration = wirelessConfiguration;
        this.networkConfiguration = networkConfiguration;
        this.timesyncConfiguration = timesyncConfiguration;
        this.mspConfiguration = mspConfiguration;
        this.broadcastConfiguration = broadcastConfiguration;
        this.loggingConfiguration = loggingConfiguration;
    }

    public AutoConfiguration getAutoConfiguration() {
        return this.autoConfiguration;
    }

    public WirelessConfiguration getWirelessConfiguration() {
        return this.wirelessConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public TimesyncConfiguration getTimesyncConfiguration() {
        return this.timesyncConfiguration;
    }

    public MSPConfiguration getMSPConfiguration() {
        return this.mspConfiguration;
    }

    public BroadcastConfiguration getBroadcastConfiguration() {
        return this.broadcastConfiguration;
    }

    public LoggingConfiguration getLoggingConfiguration() {
        return this.loggingConfiguration;
    }
}

