/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;

    public Code39Reader() {
        this.usingCheckDigit = false;
        this.extendedMode = false;
    }

    public Code39Reader(boolean usingCheckDigit) {
        this.usingCheckDigit = usingCheckDigit;
        this.extendedMode = false;
    }

    public Code39Reader(boolean usingCheckDigit, boolean extendedMode) {
        this.usingCheckDigit = usingCheckDigit;
        this.extendedMode = extendedMode;
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws NotFoundException, ChecksumException, FormatException {
        int i;
        int lastStart;
        char decodedChar;
        int[] start = Code39Reader.findAsteriskPattern(row);
        int nextStart = start[1];
        int end = row.getSize();
        while (nextStart < end && !row.get(nextStart)) {
            ++nextStart;
        }
        StringBuffer result = new StringBuffer(20);
        int[] counters = new int[9];
        do {
            Code39Reader.recordPattern(row, nextStart, counters);
            int pattern = Code39Reader.toNarrowWidePattern(counters);
            if (pattern < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            decodedChar = Code39Reader.patternToChar(pattern);
            result.append(decodedChar);
            lastStart = nextStart;
            i = 0;
            while (i < counters.length) {
                nextStart += counters[i];
                ++i;
            }
            while (nextStart < end && !row.get(nextStart)) {
                ++nextStart;
            }
        } while (decodedChar != '*');
        result.deleteCharAt(result.length() - 1);
        int lastPatternSize = 0;
        i = 0;
        while (i < counters.length) {
            lastPatternSize += counters[i];
            ++i;
        }
        int whiteSpaceAfterEnd = nextStart - lastStart - lastPatternSize;
        if (nextStart != end && whiteSpaceAfterEnd / 2 < lastPatternSize) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.usingCheckDigit) {
            int max = result.length() - 1;
            int total = 0;
            int i2 = 0;
            while (i2 < max) {
                total += ALPHABET_STRING.indexOf(result.charAt(i2));
                ++i2;
            }
            if (result.charAt(max) != ALPHABET[total % 43]) {
                throw ChecksumException.getChecksumInstance();
            }
            result.deleteCharAt(max);
        }
        if (result.length() == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        String resultString = this.extendedMode ? Code39Reader.decodeExtended(result) : result.toString();
        float left = (float)(start[1] + start[0]) / 2.0f;
        float right = (float)(nextStart + lastStart) / 2.0f;
        return new Result(resultString, null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray row) throws NotFoundException {
        int width = row.getSize();
        int rowOffset = 0;
        while (rowOffset < width) {
            if (row.get(rowOffset)) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int[] counters = new int[9];
        int patternStart = rowOffset;
        boolean isWhite = false;
        int patternLength = counters.length;
        int i = rowOffset;
        while (i < width) {
            boolean pixel = row.get(i);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == patternLength - 1) {
                    if (Code39Reader.toNarrowWidePattern(counters) == ASTERISK_ENCODING && row.isRange(Math.max(0, patternStart - (i - patternStart) / 2), patternStart, false)) {
                        return new int[]{patternStart, i};
                    }
                    patternStart += counters[0] + counters[1];
                    int y = 2;
                    while (y < patternLength) {
                        counters[y - 2] = counters[y];
                        ++y;
                    }
                    counters[patternLength - 2] = 0;
                    counters[patternLength - 1] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] counters) {
        int wideCounters;
        int numCounters = counters.length;
        int maxNarrowCounter = 0;
        do {
            int counter;
            int minCounter = Integer.MAX_VALUE;
            int i = 0;
            while (i < numCounters) {
                int counter2 = counters[i];
                if (counter2 < minCounter && counter2 > maxNarrowCounter) {
                    minCounter = counter2;
                }
                ++i;
            }
            maxNarrowCounter = minCounter;
            wideCounters = 0;
            int totalWideCountersWidth = 0;
            int pattern = 0;
            int i2 = 0;
            while (i2 < numCounters) {
                counter = counters[i2];
                if (counters[i2] > maxNarrowCounter) {
                    pattern |= 1 << numCounters - 1 - i2;
                    ++wideCounters;
                    totalWideCountersWidth += counter;
                }
                ++i2;
            }
            if (wideCounters != 3) continue;
            i2 = 0;
            while (i2 < numCounters && wideCounters > 0) {
                counter = counters[i2];
                if (counters[i2] > maxNarrowCounter) {
                    --wideCounters;
                    if (counter << 1 >= totalWideCountersWidth) {
                        return -1;
                    }
                }
                ++i2;
            }
            return pattern;
        } while (wideCounters > 3);
        return -1;
    }

    private static char patternToChar(int pattern) throws NotFoundException {
        int i = 0;
        while (i < CHARACTER_ENCODINGS.length) {
            if (CHARACTER_ENCODINGS[i] == pattern) {
                return ALPHABET[i];
            }
            ++i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(StringBuffer encoded) throws FormatException {
        int length = encoded.length();
        StringBuffer decoded = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = encoded.charAt(i);
            if (c == '+' || c == '$' || c == '%' || c == '/') {
                char next = encoded.charAt(i + 1);
                int decodedChar = 0;
                switch (c) {
                    case '+': {
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = (char)(next + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '$': {
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = (char)(next - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '%': {
                        if (next >= 'A' && next <= 'E') {
                            decodedChar = (char)(next - 38);
                            break;
                        }
                        if (next >= 'F' && next <= 'W') {
                            decodedChar = (char)(next - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '/': {
                        if (next >= 'A' && next <= 'O') {
                            decodedChar = (char)(next - 32);
                            break;
                        }
                        if (next == 'Z') {
                            decodedChar = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                decoded.append((char)decodedChar);
                ++i;
            } else {
                decoded.append(c);
            }
            ++i;
        }
        return decoded.toString();
    }
}

