/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix image) {
        super(image);
    }

    MultiFinderPatternFinder(BitMatrix image, ResultPointCallback resultPointCallback) {
        super(image, resultPointCallback);
    }

    private FinderPattern[][] selectBestPatterns() throws NotFoundException {
        Vector possibleCenters = this.getPossibleCenters();
        int size = possibleCenters.size();
        if (size < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (size == 3) {
            return new FinderPattern[][]{{(FinderPattern)possibleCenters.elementAt(0), (FinderPattern)possibleCenters.elementAt(1), (FinderPattern)possibleCenters.elementAt(2)}};
        }
        Collections.insertionSort(possibleCenters, new ModuleSizeComparator());
        Vector<ResultPoint[]> results = new Vector<ResultPoint[]>();
        int i1 = 0;
        while (i1 < size - 2) {
            FinderPattern p1 = (FinderPattern)possibleCenters.elementAt(i1);
            if (p1 != null) {
                int i2 = i1 + 1;
                while (i2 < size - 1) {
                    FinderPattern p2 = (FinderPattern)possibleCenters.elementAt(i2);
                    if (p2 != null) {
                        float vModSize12 = (p1.getEstimatedModuleSize() - p2.getEstimatedModuleSize()) / Math.min(p1.getEstimatedModuleSize(), p2.getEstimatedModuleSize());
                        float vModSize12A = Math.abs(p1.getEstimatedModuleSize() - p2.getEstimatedModuleSize());
                        if (vModSize12A > 0.5f && vModSize12 >= 0.05f) break;
                        int i3 = i2 + 1;
                        while (i3 < size) {
                            FinderPattern p3 = (FinderPattern)possibleCenters.elementAt(i3);
                            if (p3 != null) {
                                float dCpy;
                                float vPyC;
                                float vABBC;
                                float vModSize23 = (p2.getEstimatedModuleSize() - p3.getEstimatedModuleSize()) / Math.min(p2.getEstimatedModuleSize(), p3.getEstimatedModuleSize());
                                float vModSize23A = Math.abs(p2.getEstimatedModuleSize() - p3.getEstimatedModuleSize());
                                if (vModSize23A > 0.5f && vModSize23 >= 0.05f) break;
                                ResultPoint[] test = new FinderPattern[]{p1, p2, p3};
                                ResultPoint.orderBestPatterns(test);
                                FinderPatternInfo info = new FinderPatternInfo((FinderPattern[])test);
                                float dA = ResultPoint.distance(info.getTopLeft(), info.getBottomLeft());
                                float dC = ResultPoint.distance(info.getTopRight(), info.getBottomLeft());
                                float dB = ResultPoint.distance(info.getTopLeft(), info.getTopRight());
                                float estimatedModuleCount = (dA + dB) / p1.getEstimatedModuleSize() / 2.0f;
                                if (!(estimatedModuleCount > 180.0f || estimatedModuleCount < 9.0f || (vABBC = Math.abs((dA - dB) / Math.min(dA, dB))) >= 0.1f || (vPyC = Math.abs((dC - (dCpy = (float)Math.sqrt(dA * dA + dB * dB))) / Math.min(dC, dCpy))) >= 0.1f)) {
                                    results.addElement(test);
                                }
                            }
                            ++i3;
                        }
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        if (!results.isEmpty()) {
            FinderPattern[][] resultArray = new FinderPattern[results.size()][];
            int i = 0;
            while (i < results.size()) {
                resultArray[i] = (FinderPattern[])results.elementAt(i);
                ++i;
            }
            return resultArray;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Hashtable hints) throws NotFoundException {
        boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        BitMatrix image = this.getImage();
        int maxI = image.getHeight();
        int maxJ = image.getWidth();
        int iSkip = (int)((float)maxI / 228.0f * 3.0f);
        if (iSkip < 3 || tryHarder) {
            iSkip = 3;
        }
        int[] stateCount = new int[5];
        int i = iSkip - 1;
        while (i < maxI) {
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            stateCount[3] = 0;
            stateCount[4] = 0;
            int currentState = 0;
            int j = 0;
            while (j < maxJ) {
                if (image.get(j, i)) {
                    if (currentState & true) {
                        // empty if block
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                } else if (!(currentState & true)) {
                    if (currentState == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(stateCount)) {
                            boolean confirmed = this.handlePossibleCenter(stateCount, i, j);
                            if (!confirmed) {
                                while (++j < maxJ && !image.get(j, i)) {
                                }
                                --j;
                            }
                            currentState = 0;
                            stateCount[0] = 0;
                            stateCount[1] = 0;
                            stateCount[2] = 0;
                            stateCount[3] = 0;
                            stateCount[4] = 0;
                        } else {
                            stateCount[0] = stateCount[2];
                            stateCount[1] = stateCount[3];
                            stateCount[2] = stateCount[4];
                            stateCount[3] = 1;
                            stateCount[4] = 0;
                            currentState = 3;
                        }
                    } else {
                        int n = ++currentState;
                        stateCount[n] = stateCount[n] + 1;
                    }
                } else {
                    int n = currentState;
                    stateCount[n] = stateCount[n] + 1;
                }
                ++j;
            }
            if (MultiFinderPatternFinder.foundPatternCross(stateCount)) {
                this.handlePossibleCenter(stateCount, i, maxJ);
            }
            i += iSkip;
        }
        FinderPattern[][] patternInfo = this.selectBestPatterns();
        Vector<FinderPatternInfo> result = new Vector<FinderPatternInfo>();
        int i2 = 0;
        while (i2 < patternInfo.length) {
            ResultPoint[] pattern = patternInfo[i2];
            ResultPoint.orderBestPatterns(pattern);
            result.addElement(new FinderPatternInfo((FinderPattern[])pattern));
            ++i2;
        }
        if (result.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        FinderPatternInfo[] resultArray = new FinderPatternInfo[result.size()];
        int i3 = 0;
        while (i3 < result.size()) {
            resultArray[i3] = (FinderPatternInfo)result.elementAt(i3);
            ++i3;
        }
        return resultArray;
    }

    private static class ModuleSizeComparator
    implements Comparator {
        private ModuleSizeComparator() {
        }

        @Override
        public int compare(Object center1, Object center2) {
            float value = ((FinderPattern)center2).getEstimatedModuleSize() - ((FinderPattern)center1).getEstimatedModuleSize();
            return (double)value < 0.0 ? -1 : ((double)value > 0.0 ? 1 : 0);
        }
    }
}

