/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 40;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;

    public WhiteRectangleDetector(BitMatrix image) {
        this.image = image;
        this.height = image.getHeight();
        this.width = image.getWidth();
    }

    public ResultPoint[] detect() throws NotFoundException {
        int left = this.width - 40 >> 1;
        int right = this.width + 40 >> 1;
        int up = this.height - 40 >> 1;
        int down = this.height + 40 >> 1;
        boolean sizeExceeded = false;
        boolean aBlackPointFoundOnBorder = true;
        boolean atLeastOneBlackPointFoundOnBorder = false;
        while (aBlackPointFoundOnBorder) {
            aBlackPointFoundOnBorder = false;
            boolean rightBorderNotWhite = true;
            while (rightBorderNotWhite && right < this.width) {
                rightBorderNotWhite = this.containsBlackPoint(up, down, right, false);
                if (!rightBorderNotWhite) continue;
                ++right;
                aBlackPointFoundOnBorder = true;
            }
            if (right >= this.width) {
                sizeExceeded = true;
                break;
            }
            boolean bottomBorderNotWhite = true;
            while (bottomBorderNotWhite && down < this.height) {
                bottomBorderNotWhite = this.containsBlackPoint(left, right, down, true);
                if (!bottomBorderNotWhite) continue;
                ++down;
                aBlackPointFoundOnBorder = true;
            }
            if (down >= this.height) {
                sizeExceeded = true;
                break;
            }
            boolean leftBorderNotWhite = true;
            while (leftBorderNotWhite && left >= 0) {
                leftBorderNotWhite = this.containsBlackPoint(up, down, left, false);
                if (!leftBorderNotWhite) continue;
                --left;
                aBlackPointFoundOnBorder = true;
            }
            if (left < 0) {
                sizeExceeded = true;
                break;
            }
            boolean topBorderNotWhite = true;
            while (topBorderNotWhite && up >= 0) {
                topBorderNotWhite = this.containsBlackPoint(left, right, up, true);
                if (!topBorderNotWhite) continue;
                --up;
                aBlackPointFoundOnBorder = true;
            }
            if (up < 0) {
                sizeExceeded = true;
                break;
            }
            if (!aBlackPointFoundOnBorder) continue;
            atLeastOneBlackPointFoundOnBorder = true;
        }
        if (!sizeExceeded && atLeastOneBlackPointFoundOnBorder) {
            int maxSize = right - left;
            ResultPoint z = null;
            int i = 1;
            while (i < maxSize) {
                z = this.getBlackPointOnSegment(left, down - i, left + i, down);
                if (z != null) break;
                ++i;
            }
            if (z == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint t = null;
            int i2 = 1;
            while (i2 < maxSize) {
                t = this.getBlackPointOnSegment(left, up + i2, left + i2, up);
                if (t != null) break;
                ++i2;
            }
            if (t == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint x = null;
            int i3 = 1;
            while (i3 < maxSize) {
                x = this.getBlackPointOnSegment(right, up + i3, right - i3, up);
                if (x != null) break;
                ++i3;
            }
            if (x == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint y = null;
            int i4 = 1;
            while (i4 < maxSize) {
                y = this.getBlackPointOnSegment(right, down - i4, right - i4, down);
                if (y != null) break;
                ++i4;
            }
            if (y == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges(y, z, x, t);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int round(float d) {
        return (int)(d + 0.5f);
    }

    private ResultPoint getBlackPointOnSegment(float aX, float aY, float bX, float bY) {
        int dist = WhiteRectangleDetector.distanceL2(aX, aY, bX, bY);
        float xStep = (bX - aX) / (float)dist;
        float yStep = (bY - aY) / (float)dist;
        int i = 0;
        while (i < dist) {
            int y;
            int x = WhiteRectangleDetector.round(aX + (float)i * xStep);
            if (this.image.get(x, y = WhiteRectangleDetector.round(aY + (float)i * yStep))) {
                return new ResultPoint(x, y);
            }
            ++i;
        }
        return null;
    }

    private static int distanceL2(float aX, float aY, float bX, float bY) {
        float xDiff = aX - bX;
        float yDiff = aY - bY;
        return WhiteRectangleDetector.round((float)Math.sqrt(xDiff * xDiff + yDiff * yDiff));
    }

    private ResultPoint[] centerEdges(ResultPoint y, ResultPoint z, ResultPoint x, ResultPoint t) {
        float yi = y.getX();
        float yj = y.getY();
        float zi = z.getX();
        float zj = z.getY();
        float xi = x.getX();
        float xj = x.getY();
        float ti = t.getX();
        float tj = t.getY();
        if (yi < (float)(this.width / 2)) {
            return new ResultPoint[]{new ResultPoint(ti - 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj + 1.0f), new ResultPoint(xi - 1.0f, xj - 1.0f), new ResultPoint(yi + 1.0f, yj - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(ti + 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj - 1.0f), new ResultPoint(xi - 1.0f, xj + 1.0f), new ResultPoint(yi - 1.0f, yj - 1.0f)};
    }

    private boolean containsBlackPoint(int a, int b, int fixed, boolean horizontal) {
        if (horizontal) {
            int x = a;
            while (x <= b) {
                if (this.image.get(x, fixed)) {
                    return true;
                }
                ++x;
            }
        } else {
            int y = a;
            while (y <= b) {
                if (this.image.get(fixed, y)) {
                    return true;
                }
                ++y;
            }
        }
        return false;
    }
}

