/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AbstractDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressParsedResult;

final class EmailDoCoMoResultParser
extends AbstractDoCoMoResultParser {
    private static final char[] ATEXT_SYMBOLS = new char[]{'@', '.', '!', '#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'};

    EmailDoCoMoResultParser() {
    }

    public static EmailAddressParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText == null || !rawText.startsWith("MATMSG:")) {
            return null;
        }
        String[] rawTo = EmailDoCoMoResultParser.matchDoCoMoPrefixedField("TO:", rawText, true);
        if (rawTo == null) {
            return null;
        }
        String to = rawTo[0];
        if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress(to)) {
            return null;
        }
        String subject = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("SUB:", rawText, false);
        String body = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("BODY:", rawText, false);
        return new EmailAddressParsedResult(to, subject, body, "mailto:" + to);
    }

    static boolean isBasicallyValidEmailAddress(String email) {
        if (email == null) {
            return false;
        }
        boolean atFound = false;
        int i = 0;
        while (i < email.length()) {
            char c = email.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || EmailDoCoMoResultParser.isAtextSymbol(c))) {
                return false;
            }
            if (c == '@') {
                if (atFound) {
                    return false;
                }
                atFound = true;
            }
            ++i;
        }
        return atFound;
    }

    private static boolean isAtextSymbol(char c) {
        int i = 0;
        while (i < ATEXT_SYMBOLS.length) {
            if (c == ATEXT_SYMBOLS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

