/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.help.examples;

import at.mrdevelopment.esl.template.help.examples.TemplateExample;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.definition.ExampleCategory;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateExampleXMLSerializer
implements XMLSerializer<TemplateExample> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Element toXML(Document document, TemplateExample example) {
        Element templateExampleElement = document.createElement("Example");
        Element titleElement = document.createElement("Title");
        titleElement.setTextContent(example.getTitle());
        templateExampleElement.appendChild(titleElement);
        Element idElement = document.createElement("Id");
        idElement.setTextContent(example.getId());
        templateExampleElement.appendChild(idElement);
        Element categoriesElement = document.createElement("Categories");
        for (ExampleCategory category : example.getCategories()) {
            Element categoryElement = document.createElement("Category");
            categoryElement.setAttribute("id", category.getCategoryId());
            categoryElement.setAttribute("name", category.getCategoryName());
            categoriesElement.appendChild(categoryElement);
        }
        templateExampleElement.appendChild(categoriesElement);
        Element descriptionElement = document.createElement("Description");
        descriptionElement.setTextContent(example.getDescription());
        templateExampleElement.appendChild(descriptionElement);
        Element recordElement = document.createElement("Record");
        recordElement.setTextContent(example.getRecordFilename());
        templateExampleElement.appendChild(recordElement);
        Element templateElement = document.createElement("Template");
        templateElement.setTextContent(example.getTemplateFilename());
        templateExampleElement.appendChild(templateElement);
        Element labelElement = document.createElement("LabelId");
        labelElement.setTextContent(example.getLabelId().getLabelIdString());
        templateExampleElement.appendChild(labelElement);
        Element imageElement = document.createElement("Image");
        if (example.getImage() != null) {
            try {
                imageElement.setTextContent(ImageSerializer.toBase64String(example.getImage()));
            }
            catch (DOMException exc) {
                example.getStatus().addElement(new ExceptionElement(exc));
            }
            catch (SerializeException exc) {
                example.getStatus().addElement(new ExceptionElement(exc));
            }
        }
        templateExampleElement.appendChild(imageElement);
        if (example.getStatus().getElements().size() > 0) {
            Element executionStatusElement = document.createElement("ExecutionStatus");
            for (ExecutionStatusElement<?> element : example.getStatus().getElements()) {
                Element xmlElement = document.createElement("Element");
                if (element instanceof ExceptionElement) {
                    Exception e = (Exception)element.getElement();
                    String message = e.getMessage() != null ? e.getMessage() : (e.getCause() != null ? e.getCause().getMessage() : null);
                    String identifier = e.getClass().getSimpleName();
                    xmlElement.setTextContent(identifier + ": " + message);
                } else {
                    xmlElement.setTextContent(element.getElement().toString());
                }
                executionStatusElement.appendChild(xmlElement);
            }
            templateExampleElement.appendChild(executionStatusElement);
        }
        return templateExampleElement;
    }

    public Document toXML(TemplateExample example) {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(document, example));
        return document;
    }
}

