/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.help.examples;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.definition.Example;
import at.mrdevelopment.toolkit.definition.ExampleCategory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateExample {
    private BufferedImage image;
    private ExecutionStatus status;
    private UpdateImageFactory updateImageFactory;
    private XMLToolkit xmlToolkit;
    private final String directory;
    private String templateSourceCode;
    private String recordSourceCode;
    private final Example example;

    public TemplateExample(Example example, String directory) throws InitializationException {
        this.example = example;
        this.directory = new File(directory).getAbsolutePath();
        this.updateImageFactory = new UpdateImageFactory();
        this.xmlToolkit = new XMLToolkit();
        try {
            this.templateSourceCode = FileUtils.readFileToString((File)new File(FilenameUtils.concat((String)this.directory, (String)example.getTemplateFilename())));
            this.recordSourceCode = FileUtils.readFileToString((File)new File(FilenameUtils.concat((String)this.directory, (String)example.getRecordFilename())));
        }
        catch (IOException exc) {
            throw new InitializationException(exc);
        }
    }

    public String getTitle() {
        return this.example.getTitle();
    }

    public String getDescription() {
        return this.example.getDescription();
    }

    public String getTemplateFilename() {
        return this.example.getTemplateFilename();
    }

    public String getTemplateSourceCode() {
        return this.templateSourceCode;
    }

    public String getRecordFilename() {
        return this.example.getRecordFilename();
    }

    public String getRecordSourceCode() {
        return this.recordSourceCode;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void process() {
        this.status = new ExecutionStatus();
        try {
            ESLImage eslImage = this.updateImageFactory.createFromTemplateTask(this.createTemplateTask(), this.status, false, true);
            this.image = eslImage.getImage();
            for (ExecutionStatusElement<?> element : eslImage.getStatus().getElements()) {
                this.status.addElement(element);
            }
        }
        catch (Exception exc) {
            this.status.addElement(new ExceptionElement(exc));
        }
    }

    private TemplateTask createTemplateTask() throws FileNotFoundException, SerializeException {
        return new TemplateXMLTask(this.getLabelId(), TaskPriority.DEFAULT, 0L, false, (TemplateSource)new FileTemplateSource(new File(FilenameUtils.concat((String)this.directory, (String)this.example.getTemplateFilename()))), this.getRecord(), Page.PAGE_0, false);
    }

    private Document getRecord() throws FileNotFoundException, SerializeException {
        if (this.example.getRecordFilename() == null) {
            Document newDocument = this.xmlToolkit.newDocument();
            Element valuesElement = newDocument.createElement("Values");
            newDocument.appendChild(valuesElement);
            return newDocument;
        }
        return this.xmlToolkit.getDocumentRootFromFile(new File(FilenameUtils.concat((String)this.directory, (String)this.example.getRecordFilename()))).getOwnerDocument();
    }

    public LabelId getLabelId() {
        return new LabelId(Address.fromString((String)this.example.getLabelId()));
    }

    public String getId() {
        return this.example.getId();
    }

    public ExampleCategory[] getCategories() {
        return this.example.getCategories();
    }
}

