/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.help;

import at.mrdevelopment.esl.template.TemplateUtils;
import at.mrdevelopment.esl.template.UtilsDescription;
import at.mrdevelopment.esl.template.UtilsParameter;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.lang.reflect.Method;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UtilsXMLSerializer
implements XMLSerializer<TemplateUtils> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Class<? extends TemplateUtils> utilsClass) {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(utilsClass, document));
        return document;
    }

    public Element toXML(Class<? extends TemplateUtils> utilsClass, Document document) {
        Method[] methods;
        Element utilsElement = document.createElement("Utils");
        utilsElement.setAttribute("name", utilsClass.getSimpleName());
        for (Method method : methods = utilsClass.getMethods()) {
            if (method.getAnnotation(UtilsDescription.class) == null) continue;
            Element methodElement = document.createElement("Method");
            methodElement.setAttribute("name", method.getName());
            methodElement.setAttribute("description", method.getAnnotation(UtilsDescription.class).description());
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> type = method.getParameterTypes()[i];
                Element parameterElement = document.createElement("Parameter");
                parameterElement.setAttribute("type", type.getSimpleName());
                String description = "";
                try {
                    description = ((UtilsParameter)method.getParameterAnnotations()[i][0]).description();
                }
                catch (Exception exc) {
                    // empty catch block
                }
                parameterElement.setAttribute("description", description);
                methodElement.appendChild(parameterElement);
            }
            utilsElement.appendChild(methodElement);
        }
        return utilsElement;
    }
}

