/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.help;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Example;
import at.mrdevelopment.toolkit.definition.TemplateDefinitionTree;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateNodeXMLSerializer
implements XMLSerializer<TemplateDefinitionTree> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Map<String, Document> toXML() {
        TemplateNode[] templateNodes = TemplateNode.values();
        TreeMap<String, Document> documents = new TreeMap<String, Document>();
        Document indexDocument = this.xmlToolkit.newDocument();
        Element root = indexDocument.createElement("TemplateNodes");
        for (TemplateNode templateNode : templateNodes) {
            Document document = this.xmlToolkit.newDocument();
            Element xml = this.toXML(document, templateNode);
            if (xml == null) continue;
            document.appendChild(xml);
            documents.put(templateNode.name(), document);
            Element nodeElement = indexDocument.createElement("Node");
            nodeElement.setTextContent(templateNode.name());
            nodeElement.setAttribute("key", templateNode.getKey());
            root.appendChild(nodeElement);
        }
        indexDocument.appendChild(root);
        documents.put("index", indexDocument);
        return documents;
    }

    public Element toXML(Document document, TemplateNode templateNode) {
        TemplateDefinitionTree.TemplateDefinitionNode definitionNode = this.getTemplateDefinitionNode(templateNode);
        if (definitionNode != null) {
            Element templateNodeElement = document.createElement("TemplateNode");
            templateNodeElement.setAttribute("name", templateNode.name());
            templateNodeElement.setAttribute("key", templateNode.getKey());
            templateNodeElement.appendChild(this.toXML(templateNode.getAttributeList(), document));
            templateNodeElement.setAttribute("description", templateNode.getDescription());
            templateNodeElement.setAttribute("multipleOccurrences", String.valueOf(templateNode.isMultipleOccurrences()));
            if (definitionNode.getParent() != null) {
                templateNodeElement.setAttribute("parent", definitionNode.getParent().getTemplateNode().name());
            }
            templateNodeElement.appendChild(this.examplesToXML(document, templateNode.getExamples()));
            Element childsElement = document.createElement("Childs");
            for (TemplateDefinitionTree.TemplateDefinitionNode childNode : definitionNode.getChilds()) {
                Element childElement = document.createElement("Child");
                childElement.setAttribute("name", childNode.getTemplateNode().name());
                childElement.setAttribute("key", childNode.getTemplateNode().getKey());
                childsElement.appendChild(childElement);
            }
            templateNodeElement.appendChild(childsElement);
            if (templateNode.equals((Object)TemplateNode.BARCODE)) {
                templateNodeElement.appendChild(this.barcodeInformationToXML(document));
            }
            return templateNodeElement;
        }
        return null;
    }

    private Element examplesToXML(Document document, Example[] examples) {
        Element examplesElement = document.createElement("Examples");
        if (examples != null) {
            for (Example example : examples) {
                Element exampleElement = document.createElement("Example");
                exampleElement.setAttribute("id", example.getId());
                exampleElement.setAttribute("title", example.getTitle());
                examplesElement.appendChild(exampleElement);
            }
        }
        return examplesElement;
    }

    private Element barcodeInformationToXML(Document document) {
        Element barcodesElement = document.createElement("Barcodes");
        for (TemplateNode barcodeNode : TemplateNode.values()) {
            if (!barcodeNode.name().startsWith("BARCODE_")) continue;
            Element barcodeElement = document.createElement("Barcode");
            barcodeElement.setAttribute("name", barcodeNode.name());
            barcodeElement.setAttribute("key", barcodeNode.getKey());
            barcodeElement.appendChild(this.toXML(barcodeNode.getAttributeList(), document));
            barcodesElement.appendChild(barcodeElement);
        }
        return barcodesElement;
    }

    private TemplateDefinitionTree.TemplateDefinitionNode getTemplateDefinitionNode(TemplateNode templateNode) {
        TemplateDefinitionTree.TemplateDefinitionNode rootNode = TemplateDefinitionTree.getTree().getRoot();
        return this.getTemplateDefinitionNode(templateNode, rootNode);
    }

    private TemplateDefinitionTree.TemplateDefinitionNode getTemplateDefinitionNode(TemplateNode templateNode, TemplateDefinitionTree.TemplateDefinitionNode currentNode) {
        if (currentNode.getTemplateNode().equals((Object)templateNode)) {
            return currentNode;
        }
        for (TemplateDefinitionTree.TemplateDefinitionNode definitionNode : currentNode.getChilds()) {
            TemplateDefinitionTree.TemplateDefinitionNode templateDefinitionNode;
            if (definitionNode.getTemplateNode().equals((Object)TemplateNode.FIELD) && !currentNode.getTemplateNode().equals((Object)TemplateNode.ROOT_IMAGE) || (templateDefinitionNode = this.getTemplateDefinitionNode(templateNode, definitionNode)) == null) continue;
            return templateDefinitionNode;
        }
        return null;
    }

    private Element toXML(List<Attribute> attributeList, Document document) {
        Element attributeListElement = document.createElement("AttributeList");
        for (Attribute attribute : attributeList) {
            Element attributeElement = document.createElement("Attribute");
            attributeElement.setAttribute("name", attribute.getKey());
            attributeElement.setAttribute("description", attribute.getDescription().getDescription());
            attributeElement.setAttribute("possibleValues", attribute.getDescription().getPossibleValueDescription());
            attributeElement.setAttribute("inheritated", String.valueOf(attribute.isInheritate()));
            try {
                String defaultValue = attribute.getDefaultValue();
                if (defaultValue != null) {
                    defaultValue = defaultValue.toLowerCase();
                }
                attributeElement.setAttribute("defaultValue", defaultValue);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            attributeElement.appendChild(this.examplesToXML(document, attribute.getExamples()));
            attributeListElement.appendChild(attributeElement);
        }
        return attributeListElement;
    }
}

