/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.help;

import at.mrdevelopment.esl.template.DefaultTemplateUtils;
import at.mrdevelopment.esl.template.help.TemplateNodeXMLSerializer;
import at.mrdevelopment.esl.template.help.UtilsXMLSerializer;
import at.mrdevelopment.esl.template.help.examples.TemplateExample;
import at.mrdevelopment.esl.template.help.examples.TemplateExampleXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.definition.Example;
import at.mrdevelopment.toolkit.definition.ExampleCategory;
import at.mrdevelopment.toolkit.http.XMLContentProducer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateHelpGenerator {
    static ESLLogger logger;
    private static final String HELP_SRC_DIRECTORY = "data/help/src";
    public static final String HELP_DST_DIRECTORY = "../../help/";
    private static final String GENERAL_XML_FILE = "general.xml";
    public static final String INDEX_XML_FILE = "index.xml";
    private XMLToolkit xmlToolkit;
    private TemplateExampleXMLSerializer serializer;
    private final Transformer transformer;
    private String destinationFolder;

    public static void main(String[] args) {
        try {
            if (args != null && args.length > 0) {
                new TemplateHelpGenerator(args[0]);
            } else {
                new TemplateHelpGenerator();
            }
        }
        catch (InitializationException e) {
            e.printStackTrace();
        }
    }

    public TemplateHelpGenerator(String destinationFolder) throws InitializationException {
        this.destinationFolder = destinationFolder;
        this.xmlToolkit = new XMLToolkit();
        this.serializer = new TemplateExampleXMLSerializer();
        if (new File(destinationFolder).exists()) {
            FileUtils.deleteQuietly((File)new File(destinationFolder));
        }
        try {
            this.createOutputDirectory(HELP_SRC_DIRECTORY, destinationFolder);
            this.transformer = this.createTransformer(new StreamSource(new File(destinationFolder, "reference.xsl")));
            this.transformFile(new File(HELP_SRC_DIRECTORY, INDEX_XML_FILE), new File(destinationFolder, "index.html"));
            this.transformFile(new File(HELP_SRC_DIRECTORY, GENERAL_XML_FILE), new File(destinationFolder, "general.html"));
            UtilsXMLSerializer utilsSerializer = new UtilsXMLSerializer();
            this.writeDocument(new File(destinationFolder, "utils.html"), utilsSerializer.toXML(DefaultTemplateUtils.class));
            TemplateNodeXMLSerializer nodeSerializer = new TemplateNodeXMLSerializer();
            Map<String, Document> documents = nodeSerializer.toXML();
            for (String key : documents.keySet()) {
                if (key.equals("index")) {
                    this.writeDocument(new File(destinationFolder, String.format("elements.html", key)), documents.get(key));
                    continue;
                }
                this.writeDocument(new File(destinationFolder, String.format("fields/%s.html", key)), documents.get(key));
                this.xmlToolkit.transform(new DOMSource(documents.get(key)), new StreamResult(new File("test.xml")));
            }
            ArrayList<TemplateExample> templateExamples = new ArrayList<TemplateExample>();
            for (Example example : Example.values()) {
                logger.info("Processing example %s (%s)", example.getId(), example.getTemplateFilename());
                TemplateExample templateExample = new TemplateExample(example, destinationFolder);
                templateExample.process();
                templateExamples.add(templateExample);
            }
            this.writeTemplateExample(templateExamples);
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
    }

    public TemplateHelpGenerator() throws InitializationException {
        this(HELP_DST_DIRECTORY);
    }

    private Transformer createTransformer(Source xsltSource) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
        catch (TransformerConfigurationException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void createOutputDirectory(String helpSrcDirectory, String helpDstDirectory) throws IOException {
        File srcDirectory = new File(helpSrcDirectory);
        File dstDirectory = new File(helpDstDirectory);
        FileUtils.copyDirectory((File)srcDirectory, (File)dstDirectory, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)".svn")));
        FileUtils.deleteQuietly((File)new File(this.destinationFolder, GENERAL_XML_FILE));
        FileUtils.deleteQuietly((File)new File(this.destinationFolder, INDEX_XML_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(File destinationFile, Document document) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(destinationFile);
            XMLContentProducer contentProducer = new XMLContentProducer(document, this.transformer, null);
            contentProducer.writeTo(outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformFile(File sourceFile, File targetFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
            StreamSource source = new StreamSource(sourceFile);
            StreamResult result = new StreamResult(outputStream);
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(source, result);
            }
        }
        catch (TransformerException exc) {
            try {
                throw new IOException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                throw throwable;
            }
        }
        StreamUtils.close(outputStream);
    }

    private void writeTemplateExample(List<TemplateExample> examples) throws IOException, SerializeException {
        TreeMap categoryMap = new TreeMap();
        for (TemplateExample example : examples) {
            for (ExampleCategory category : example.getCategories()) {
                if (!categoryMap.containsKey((Object)category)) {
                    categoryMap.put(category, new ArrayList());
                }
                ((List)categoryMap.get((Object)category)).add(example);
            }
            Document document = this.xmlToolkit.newDocument();
            Element exampleElement = this.serializer.toXML(document, example);
            Element root = document.createElement("SingleExample");
            root.appendChild(exampleElement);
            document.appendChild(root);
            this.writeDocument(new File(this.destinationFolder, String.format("examples/%s.html", example.getId())), document);
        }
        Document categoryIndexDocument = this.xmlToolkit.newDocument();
        Element rootCategoryElement = categoryIndexDocument.createElement("Categories");
        for (ExampleCategory category : categoryMap.keySet()) {
            Element categoryElement = categoryIndexDocument.createElement("Category");
            categoryElement.setAttribute("id", category.getCategoryId());
            categoryElement.setTextContent(category.getCategoryName());
            rootCategoryElement.appendChild(categoryElement);
            Document categoryDocument = this.xmlToolkit.newDocument();
            Element examplesElement = categoryDocument.createElement("Examples");
            for (TemplateExample example : (List)categoryMap.get((Object)category)) {
                Element exampleElement = this.serializer.toXML(categoryDocument, example);
                examplesElement.appendChild(exampleElement);
            }
            categoryDocument.appendChild(examplesElement);
            this.writeDocument(new File(this.destinationFolder, String.format("examples/%s.html", category.getCategoryId())), categoryDocument);
        }
        categoryIndexDocument.appendChild(rootCategoryElement);
        this.writeDocument(new File(this.destinationFolder, "examples/categories.html"), categoryIndexDocument);
    }

    static {
        ESLLogger.initLogger(true);
        logger = ESLLogger.getLogger(TemplateHelpGenerator.class);
    }
}

