/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components.celleditor.actions;

import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.actions.EditorActionListener;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.tree.ConstructiblePath;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImageFileChooserActionListener
extends EditorActionListener {
    private File workingDirectory;
    private JFileChooser fileChooser;
    private EventDispatcher eventDispatcher;
    private Path optionPath;
    private int fieldId;
    private TemplateModel templateModel;
    private final boolean toBase64;

    public ImageFileChooserActionListener(boolean toBase64, File workingDirectory, EventDispatcher eventDispatcher, Path optionPath, int fieldId, TemplateModel templateModel) {
        this.toBase64 = toBase64;
        this.workingDirectory = workingDirectory;
        this.eventDispatcher = eventDispatcher;
        this.optionPath = optionPath;
        this.fieldId = fieldId;
        this.templateModel = templateModel;
        this.initFileChooser();
    }

    private void initFileChooser() {
        this.fileChooser = new JFileChooser(new File(this.templateModel.getXSLFileName()));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".jpg") || f.isDirectory() || f.getName().toLowerCase().endsWith(".bmp") || f.getName().toLowerCase().endsWith(".png");
            }

            @Override
            public String getDescription() {
                return "Image Files (*jpeg, *.jpg, *.bmp, *.png)";
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnValue = this.fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            this.proccess();
        }
    }

    private File getWorkingDirectory() {
        return this.workingDirectory;
    }

    private JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    private EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    private Path getOptionPath() {
        return this.optionPath;
    }

    private int getFieldId() {
        return this.fieldId;
    }

    private void proccessFileAsBase64(Path optionPath) {
        try {
            File selectedFile = this.getFileChooser().getSelectedFile();
            BufferedImage image = ImageIO.read(selectedFile);
            String base64String = ImageSerializer.toBase64String(image);
            if (base64String.length() > 65535) {
                if (this.getOptionPath().equals(optionPath)) {
                    if (JOptionPane.showConfirmDialog(null, "The selected image is too large to embed it into the template. Do you want to link it to the template?", "Image too large", 0) == 0) {
                        ConstructiblePath path = new ConstructiblePath((ConstructiblePath)this.getOptionPath());
                        try {
                            this.processFile(path.removeLastElement().addLastElement("src"));
                        }
                        catch (Exception exc) {
                            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
                            JOptionPane.showMessageDialog(null, "Unable get a relative path from template file to image file.", "Relative Path Error", 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "The selected image is too large to embed it into the template.", "Image too large", 0);
                }
                return;
            }
            if (!this.getOptionPath().equals(optionPath)) {
                this.notifyResultListener("");
                this.getEventDispatcher().dispatchEvent(new OptionChangeEvent(optionPath, this.getFieldId(), base64String));
                this.templateModel.refresh();
            } else {
                this.getEventDispatcher().dispatchEvent(new OptionChangeEvent(optionPath, this.getFieldId(), base64String));
            }
        }
        catch (SerializeException exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
            JOptionPane.showMessageDialog(null, exc.getMessage(), exc.getClass().getSimpleName(), 0);
        }
        catch (IOException exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
            JOptionPane.showMessageDialog(null, exc.getMessage(), exc.getClass().getSimpleName(), 0);
        }
    }

    private void proccess() {
        block4: {
            if (this.toBase64) {
                this.proccessFileAsBase64(this.getOptionPath());
            } else {
                try {
                    this.processFile(this.getOptionPath());
                }
                catch (Exception exc) {
                    if (JOptionPane.showConfirmDialog(null, "Unable get a relative path from template file to image file. Do you want to embed it?", "Relative Path Error", 0) != 0) break block4;
                    ConstructiblePath path = new ConstructiblePath((ConstructiblePath)this.getOptionPath());
                    this.proccessFileAsBase64(path.removeLastElement().addLastElement("data"));
                }
            }
        }
    }

    private void processFile(Path optionPath) {
        File selectedFile = this.getFileChooser().getSelectedFile();
        if (this.getWorkingDirectory().getAbsolutePath() != null) {
            String relativePath = FileUtils.getRelativePath(selectedFile.getAbsolutePath(), this.getWorkingDirectory().getAbsolutePath(), System.getProperty("file.separator"));
            if (!this.getOptionPath().equals(optionPath)) {
                this.notifyResultListener("");
                this.getEventDispatcher().dispatchEvent(new OptionChangeEvent(optionPath, this.getFieldId(), relativePath));
                this.templateModel.refresh();
            } else {
                this.notifyResultListener(relativePath);
                this.getEventDispatcher().dispatchEvent(new OptionChangeEvent(optionPath, this.getFieldId(), relativePath));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Save template before inserting image.", "Save Template", 0);
        }
    }
}

