/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components.celleditor;

import at.mrdevelopment.esl.template.editor.view.components.celleditor.actions.EditorActionListener;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.actions.EditorResultListener;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TextEditor
extends AbstractCellEditor
implements TableCellEditor,
EditorResultListener {
    private final DisplayableOption option;
    private JTextField textField;
    private JPanel panel;
    private JButton button;
    private int fieldId;
    private Path optionPath;
    private EditorActionListener actionListener;

    public TextEditor(TableModel tableModel, int row, int col, final EventDispatcher eventDispatcher, int fieldId, DisplayableOption option, Path optionPath, EditorActionListener actionListener) {
        this.fieldId = fieldId;
        this.option = option;
        this.optionPath = optionPath;
        this.actionListener = actionListener;
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent paramChangeEvent) {
                OptionChangeEvent oce = new OptionChangeEvent(TextEditor.this.optionPath, TextEditor.this.fieldId, TextEditor.this.textField.getText());
                eventDispatcher.dispatchEvent(oce);
            }

            @Override
            public void editingCanceled(ChangeEvent paramChangeEvent) {
            }
        });
        this.panel = new JPanel(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setBorder(null);
        this.textField.setText(this.option.getValue());
        this.panel.add((Component)this.textField, "Center");
        this.button = new JButton("...");
        this.button.setMargin(new Insets(1, 1, 1, 1));
        if (actionListener != null) {
            actionListener.setResultListener(this);
            this.button.addActionListener(actionListener);
        }
        this.panel.add((Component)this.button, "East");
    }

    @Override
    public Object getCellEditorValue() {
        return this.option.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(this.option.getValue());
        return this.panel;
    }

    @Override
    public void notifyActionResult(final String resultText) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextEditor.this.textField.setText(resultText);
            }
        });
    }

    public void triggerAction() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(null);
        }
    }
}

