/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components.celleditor;

import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.CheckBoxEditor;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.CollapseTableCellEditor;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.ComboEditor;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.FontListRenderer;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.TextEditor;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.actions.EditOptionDialogActionListener;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.actions.EditSliderActionListener;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.actions.ImageFileChooserActionListener;
import at.mrdevelopment.toolkit.gui.CellEditorFactory;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.options.ButtonEditor;
import at.mrdevelopment.toolkit.gui.options.CellComponentEntry;
import at.mrdevelopment.toolkit.gui.options.ColorTableCell;
import at.mrdevelopment.toolkit.gui.options.OptionsTableCellRenderer;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import at.mrdevelopment.toolkit.gui.options.OptionsTableModel;
import at.mrdevelopment.toolkit.gui.options.SingleButtonEditor;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class OptionsTableCellEditorFactory
implements CellEditorFactory {
    static ESLLogger logger = ESLLogger.getLogger(OptionsTableCellEditorFactory.class);
    private static List<String> rootImageRotationChoices = null;
    private static List<String> fontList = null;
    private EventDispatcher eventDispatcher;
    private ViewState viewState;
    private DesignTemplateModel templateModel;
    private OptionsTableCellRenderer optionsTableCellRenderer;
    private Map<CellComponentEntry, TableCellEditor> map = new HashMap<CellComponentEntry, TableCellEditor>();

    public OptionsTableCellEditorFactory(EventDispatcher eventDispatcher, ViewState viewState, DesignTemplateModel templateModel) {
        this.eventDispatcher = eventDispatcher;
        this.viewState = viewState;
        this.templateModel = templateModel;
        this.optionsTableCellRenderer = new OptionsTableCellRenderer(eventDispatcher, viewState);
    }

    public TableCellEditor add(TableCellEditor comp, OptionsTableEntry value, int col) {
        CellComponentEntry entry = new CellComponentEntry(value, col);
        if (this.map.containsKey(entry)) {
            return this.map.get(entry);
        }
        this.map.put(entry, comp);
        return comp;
    }

    @Override
    public TableCellEditor getEditor(TableModel tableModel, int row, int col) {
        try {
            if (tableModel == null) {
                return null;
            }
            OptionsTableEntry optionEntry = (OptionsTableEntry)tableModel.getValueAt(row, 1);
            if (col == 1) {
                if (optionEntry == null) {
                    return null;
                }
                Path optionPath = optionEntry.getPath();
                DisplayableOption option = optionEntry.getDisplayableOption();
                return this.getEditor(tableModel, optionPath, option, row, col);
            }
            Object key = tableModel.getValueAt(row, 0);
            return this.add(new CollapseTableCellEditor(this.optionsTableCellRenderer.getKeyComponent((OptionsTableModel)tableModel, row, key.toString(), optionEntry, optionEntry.getDisplayableOption() != null ? optionEntry.getDisplayableOption().getToolTip() : null)), optionEntry, col);
        }
        catch (Exception e) {
            logger.logException(e);
            return null;
        }
    }

    private TableCellEditor getEditor(TableModel tableModel, Path optionPath, DisplayableOption option, int row, int col) throws OptionException {
        if (col == 0) {
            throw new OptionException(String.format("Key column is not editable: row: %s, column: %s", row, col));
        }
        OptionsTableEntry optionEntry = (OptionsTableEntry)tableModel.getValueAt(row, 1);
        if (option.getOptionType().equals("BooleanOption")) {
            return new CheckBoxEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath);
        }
        if (option.getOptionType().equals("EnumOption")) {
            block19: {
                try {
                    Class<?> enumClass = option.getEnum().getClass();
                    Field[] fields = enumClass.getDeclaredFields();
                    ArrayList<String> enumNames = new ArrayList<String>();
                    for (Field field : fields) {
                        if (!field.isEnumConstant()) continue;
                        enumNames.add(field.getName());
                    }
                    TreeMap<String, ImageIcon> icons = new TreeMap<String, ImageIcon>();
                    if (enumNames.size() == 2) {
                        if (IconUtils.isIconAvailable(optionPath.getLastElement())) {
                            String enabledValue = ((String)enumNames.get(0)).equals("normal") || ((String)enumNames.get(0)).equals("none") ? ((String)enumNames.get(0)).toLowerCase() : ((String)enumNames.get(1)).toLowerCase();
                            String disabledvalue = ((String)enumNames.get(0)).equals("normal") || ((String)enumNames.get(0)).equals("none") ? ((String)enumNames.get(1)).toLowerCase() : ((String)enumNames.get(0)).toLowerCase();
                            return this.add(new SingleButtonEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, IconUtils.loadImageIcon(optionPath.getLastElement()), enabledValue, disabledvalue), optionEntry, col);
                        }
                        break block19;
                    }
                    for (String enumName : enumNames) {
                        String iconName = String.format("%s_%s", optionPath.getLastElement(), enumName.toLowerCase());
                        if (IconUtils.isIconAvailable(iconName)) {
                            icons.put(enumName, IconUtils.loadImageIcon(iconName));
                            continue;
                        }
                        return this.add(new ComboEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath), optionEntry, col);
                    }
                    return this.add(new ButtonEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, icons), optionEntry, col);
                }
                catch (Exception exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
            return this.add(new ComboEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath), optionEntry, col);
        }
        if (option.getOptionType().equals("StringChoiceOption")) {
            return this.add(new ComboEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath), optionEntry, col);
        }
        if (option.getOptionType().equals("ColorOption")) {
            return this.add(new ColorTableCell(option, this.eventDispatcher, this.viewState), optionEntry, col);
        }
        if (optionPath.getLastElement().equals("font-family") || optionPath.getLastElement().equals("fontName")) {
            if (fontList == null) {
                this.initFontList();
            }
            return this.add(new ComboEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath, fontList, true, new FontListRenderer()), optionEntry, col);
        }
        if (optionPath.getLastElement().equals("src") || optionPath.getLastElement().equals("background-image")) {
            ImageFileChooserActionListener actionListener = new ImageFileChooserActionListener(false, new File(this.templateModel.getXSLFileName()), this.eventDispatcher, optionPath, this.viewState.getElementFocused(), this.templateModel);
            return this.add(new TextEditor(tableModel, row, col, this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath, actionListener), optionEntry, col);
        }
        if (optionPath.getLastElement().equals("data")) {
            ImageFileChooserActionListener actionListener = new ImageFileChooserActionListener(true, new File(this.templateModel.getXSLFileName()), this.eventDispatcher, optionPath, this.viewState.getElementFocused(), this.templateModel);
            return this.add(new TextEditor(tableModel, row, col, this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath, actionListener), optionEntry, col);
        }
        if (optionPath.getFirstElement().equals("rotation") && this.viewState.getElementFocused() < 0) {
            if (rootImageRotationChoices == null) {
                this.initRotationChoices();
            }
            return this.add(new ComboEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath, rootImageRotationChoices, false, null), optionEntry, col);
        }
        if (optionPath.getLastElement().equals("rotation")) {
            EditSliderActionListener actionListener = new EditSliderActionListener(this.eventDispatcher, this.viewState.getElementFocused(), optionPath, option);
            return this.add(new TextEditor(tableModel, row, col, this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath, actionListener), optionEntry, col);
        }
        EditOptionDialogActionListener actionListener = new EditOptionDialogActionListener(this.eventDispatcher, this.viewState.getElementFocused(), optionPath, option, this.templateModel);
        return this.add(new TextEditor(tableModel, row, col, this.eventDispatcher, this.viewState.getElementFocused(), option, optionPath, actionListener), optionEntry, col);
    }

    private void initFontList() {
        Object[] availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(availableFonts);
        fontList = new ArrayList<String>();
        for (Object font : availableFonts) {
            fontList.add((String)font);
        }
    }

    private void initRotationChoices() {
        rootImageRotationChoices = new ArrayList<String>();
        rootImageRotationChoices.add("0");
        rootImageRotationChoices.add("90");
        rootImageRotationChoices.add("180");
        rootImageRotationChoices.add("270");
    }
}

