/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components.celleditor;

import at.mrdevelopment.esl.template.editor.view.components.celleditor.AutoCompleteDocument;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.TableCellEditor;

public class ComboEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final DisplayableOption option;
    private JComboBox comboBox;

    public ComboEditor(final EventDispatcher eventDispatcher, final int fieldId, DisplayableOption option, final Path optionPath, List<String> choices, boolean editable, BasicComboBoxRenderer renderer) {
        this.option = option;
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent paramChangeEvent) {
                OptionChangeEvent oce = new OptionChangeEvent(optionPath, fieldId, (String)ComboEditor.this.comboBox.getSelectedItem());
                eventDispatcher.dispatchEvent(oce);
            }

            @Override
            public void editingCanceled(ChangeEvent paramChangeEvent) {
            }
        });
        this.comboBox = GUIUtils.getComboBox(choices, this.option.getValue());
        this.comboBox.setEditable(editable);
        this.comboBox.setBorder(null);
        if (renderer != null) {
            this.comboBox.setRenderer(renderer);
        }
        if (this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField textField = (JTextField)this.comboBox.getEditor().getEditorComponent();
            textField.setDocument(new AutoCompleteDocument(this.comboBox, textField, choices));
            textField.setText(this.option.getValue());
        }
        this.comboBox.setSelectedItem(this.option.getValue());
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                if (ComboEditor.this.comboBox.isPopupVisible() && (long)paramActionEvent.getModifiers() == 16L) {
                    ComboEditor.this.fireEditingStopped();
                }
            }
        });
    }

    public ComboEditor(EventDispatcher eventDispatcher, int fieldId, DisplayableOption option, Path optionPath) {
        this(eventDispatcher, fieldId, option, optionPath, option.getChoices(), false, null);
    }

    @Override
    public Object getCellEditorValue() {
        return this.option.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.comboBox.setSelectedItem(this.option.getValue());
        return this.comboBox;
    }
}

