/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components.celleditor;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.converter.BooleanStringConverter;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class CheckBoxEditor
extends AbstractCellEditor
implements TableCellEditor {
    static ESLLogger logger = ESLLogger.getLogger(CheckBoxEditor.class);
    private BooleanStringConverter stringConverter = new BooleanStringConverter();
    private final DisplayableOption option;
    private JCheckBox checkBox;

    public CheckBoxEditor(final EventDispatcher eventDispatcher, final int fieldId, DisplayableOption option, final Path optionPath) {
        this.option = option;
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent paramChangeEvent) {
                OptionChangeEvent oce = new OptionChangeEvent(optionPath, fieldId, String.valueOf(CheckBoxEditor.this.checkBox.isSelected()));
                eventDispatcher.dispatchEvent(oce);
            }

            @Override
            public void editingCanceled(ChangeEvent paramChangeEvent) {
            }
        });
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected(this.getOptionValueAsBoolean());
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                CheckBoxEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.getOptionValueAsBoolean();
    }

    private Boolean getOptionValueAsBoolean() {
        try {
            return this.stringConverter.reconvert(this.option.getValue());
        }
        catch (ConversionException e) {
            logger.logException(e);
            return false;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.checkBox.setSelected(this.getOptionValueAsBoolean());
        return this.checkBox;
    }
}

