/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components.celleditor;

import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AutoCompleteDocument
extends PlainDocument {
    private List<String> autoCompleteData;
    private JComboBox autoComboBox;
    private JTextField editorComponent;

    public AutoCompleteDocument(JComboBox autoComboBox, JTextField editorComponent, List<String> autoCompleteData) {
        this.autoComboBox = autoComboBox;
        this.editorComponent = editorComponent;
        this.autoCompleteData = autoCompleteData;
    }

    @Override
    public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
        super.remove(i, j);
        this.insertString(i, s, attributeset);
    }

    @Override
    public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
        if (s == null || "".equals(s)) {
            return;
        }
        String s1 = this.getText(0, i);
        String s2 = this.getMatch(s1 + s);
        int j = i + s.length() - 1;
        if (this.isStrict() && s2 == null) {
            s2 = this.getMatch(s1);
            --j;
        } else if (!this.isStrict() && s2 == null) {
            super.insertString(i, s, attributeset);
            return;
        }
        if (this.autoComboBox != null && s2 != null) {
            this.autoComboBox.setSelectedItem(s2);
        }
        super.remove(0, this.getLength());
        super.insertString(0, s2, attributeset);
        this.editorComponent.setSelectionStart(j + 1);
        this.editorComponent.setSelectionEnd(this.getLength());
    }

    @Override
    public void remove(int i, int j) throws BadLocationException {
        int k = this.editorComponent.getSelectionStart();
        if (k > 0) {
            --k;
        }
        String s = this.getMatch(this.getText(0, k));
        if (!this.isStrict() && s == null) {
            super.remove(i, j);
        } else {
            super.remove(0, this.getLength());
            super.insertString(0, s, null);
        }
        if (this.autoComboBox != null && s != null) {
            this.autoComboBox.setSelectedItem(s);
        }
        try {
            this.editorComponent.setSelectionStart(k);
            this.editorComponent.setSelectionEnd(this.getLength());
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private String getMatch(String s) {
        for (int i = 0; i < this.autoCompleteData.size(); ++i) {
            String s1 = this.autoCompleteData.get(i).toString();
            if (s1 == null) continue;
            if (!this.isCaseSensitive() && s1.toLowerCase().startsWith(s.toLowerCase())) {
                return s1;
            }
            if (!this.isCaseSensitive() || !s1.startsWith(s)) continue;
            return s1;
        }
        return null;
    }

    public boolean isStrict() {
        return true;
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

