/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view.components;

import at.mrdevelopment.esl.template.editor.controller.event.DragAndDropEvent;
import at.mrdevelopment.esl.template.editor.controller.undoredo.UndoRedoKeyListener;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTemplate;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.AutoDockingCanvas;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.resizeable.CanvasBorder;
import at.mrdevelopment.toolkit.gui.resizeable.ResizeableBorder;
import at.mrdevelopment.toolkit.gui.resizeable.ResizeableCanvasElement;
import at.mrdevelopment.toolkit.gui.resizeable.TwoPointBorder;
import at.mrdevelopment.toolkit.image.BufferedImagePanel;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JFrame;

public class TemplateCanvas
extends AutoDockingCanvas
implements DropTargetListener {
    static ESLLogger logger = ESLLogger.getLogger(TemplateCanvas.class);
    private BufferedImagePanel bufferedImagePanel;

    public TemplateCanvas(UndoRedoKeyListener keyListener, EventDispatcher eventDispatcher, JFrame parentFrame) throws InitializationException {
        super(eventDispatcher, parentFrame);
        this.getPanel().addKeyListener(keyListener);
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this);
        }
        catch (TooManyListenersException exc) {
            throw new InitializationException(exc);
        }
        this.getPanel().setDropTarget(dropTarget);
    }

    public void refreshCanvas(DesignTemplateModel templateModel) {
        this.fixViewState(templateModel);
        XSLTemplate xslTemplate = templateModel.getTemplate();
        BufferedImage bufferedImage = templateModel.getImage();
        if (this.bufferedImagePanel == null) {
            this.bufferedImagePanel = new BufferedImagePanel(bufferedImage, this.getViewState().getScale());
            this.bufferedImagePanel.setBounds(new Rectangle(this.getViewState().getViewX(), this.getViewState().getViewY(), this.bufferedImagePanel.getPreferredSize().width, this.bufferedImagePanel.getPreferredSize().height));
            this.getPanel().add(this.bufferedImagePanel);
            this.bufferedImagePanel.setVisible(true);
            this.adjustPanelSize();
        } else {
            this.bufferedImagePanel.setScale(this.getViewState().getScale());
            this.bufferedImagePanel.changeImage(bufferedImage);
            this.bufferedImagePanel.setBounds(new Rectangle(this.getViewState().getViewX(), this.getViewState().getViewY(), this.bufferedImagePanel.getPreferredSize().width, this.bufferedImagePanel.getPreferredSize().height));
            this.adjustPanelSize();
        }
        if (!this.getViewState().isUserEditing()) {
            this.removeAllCanvasElements();
            if (xslTemplate != null) {
                this.refreshRotationAndImageHeightAndWidth(xslTemplate);
                for (int i : xslTemplate.getFieldIds()) {
                    Shape origBounds = xslTemplate.getFieldBounds(i);
                    Shape bounds = xslTemplate.getFieldBounds(i);
                    if (this.rotation == 90 || this.rotation == 180 || this.rotation == 270) {
                        bounds = ImageUtils.rotate(this.rotation, bounds.getBounds(), this.imageHeight, this.imageWidth);
                    }
                    CanvasBorder border = xslTemplate.isTwoPointBorder(i) ? new TwoPointBorder() : new ResizeableBorder();
                    ResizeableCanvasElement canvasElement = new ResizeableCanvasElement(this, i, bounds.getBounds().x * this.getViewState().getScale() + this.getViewState().getViewX(), bounds.getBounds().y * this.getViewState().getScale() + this.getViewState().getViewY(), bounds.getBounds().width * this.getViewState().getScale(), bounds.getBounds().height * this.getViewState().getScale(), origBounds, this.imageHeight, this.imageWidth, this.rotation, border);
                    this.addCanvasElement(canvasElement);
                }
            }
        }
    }

    private void adjustPanelSize() {
        int imageWidth = this.bufferedImagePanel.getPreferredSize().width;
        int imageHeight = this.bufferedImagePanel.getPreferredSize().height;
        int panelWidth = this.getPanel().getPreferredSize().width;
        int panelHeight = this.getPanel().getPreferredSize().height;
        if (imageWidth > panelWidth) {
            this.getPanel().setPreferredSize(new Dimension(imageWidth, panelHeight));
        }
        if (imageHeight > panelHeight) {
            this.getPanel().setPreferredSize(new Dimension(panelWidth, imageHeight));
        }
    }

    private void refreshRotationAndImageHeightAndWidth(XSLTemplate xslTemplate) {
        try {
            this.rotation = Integer.valueOf(xslTemplate.getTemplateOptions().getNode("rotation").getNodeElement().getValue().toString());
        }
        catch (Exception exc) {
            this.rotation = 0;
        }
        try {
            this.imageHeight = Integer.valueOf(xslTemplate.getTemplateOptions().getNode("height").getNodeElement().getValue().toString());
        }
        catch (Exception e) {
            this.imageHeight = 0;
        }
        try {
            this.imageWidth = Integer.valueOf(xslTemplate.getTemplateOptions().getNode("width").getNodeElement().getValue().toString());
        }
        catch (Exception e) {
            this.imageWidth = 0;
        }
    }

    private void fixViewState(DesignTemplateModel templateModel) {
        if (!templateModel.hasFieldId(this.getViewState().getElementFocused())) {
            this.getViewState().setElementFocused(-1);
        }
        if (!templateModel.hasFieldId(this.getViewState().getElementSlightlyFocused())) {
            this.getViewState().setElementSlightlyFocused(-1);
        }
    }

    @Override
    public int getWidth() {
        return this.bufferedImagePanel.getImageWidth();
    }

    @Override
    public int getHeight() {
        return this.bufferedImagePanel.getImageHeight();
    }

    @Override
    public String getTitle() {
        return "Design";
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            dtde.acceptDrop(1);
            List droppedFiles = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            this.eventDispatcher.dispatchEvent(new DragAndDropEvent(droppedFiles, dtde.getLocation()));
        }
        catch (Exception exc) {
            logger.warn("Error during drop: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
    }
}

