/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.controller.TemplateController;
import at.mrdevelopment.esl.template.editor.controller.undoredo.UndoRedoKeyListener;
import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLFileRecordsContainer;
import at.mrdevelopment.esl.template.editor.model.XMLRecordContainerListener;
import at.mrdevelopment.esl.template.editor.model.XMLRecordInterface;
import at.mrdevelopment.esl.template.editor.view.DefaultTemplateView;
import at.mrdevelopment.esl.template.editor.view.SourceEditorView;
import at.mrdevelopment.esl.template.editor.view.TextModificationListener;
import at.mrdevelopment.esl.template.editor.view.XMLRecordNavigationPanel;
import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.CrossMark;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class XMLRecordsView
extends AbstractView
implements View,
Observer,
TextModificationListener,
XMLRecordContainerListener {
    static ESLLogger logger = ESLLogger.getLogger(XMLRecordsView.class);
    private final DefaultTemplateView templateView;
    private final UndoRedoKeyListener keyListener;
    private final AbstractTemplateModel templateModel;
    private final String title;
    private final CrossMark CROSS_BLACK = new CrossMark(Color.BLACK, 1);
    private final CrossMark CROSS_DARK_GRAY = new CrossMark(Color.DARK_GRAY, 1);
    private final CrossMark CROSS_LIGHT_GRAY = new CrossMark(Color.LIGHT_GRAY, 1);
    private JPanel panel;
    private JLabel recordIdentifierLabel;
    private JPanel mainPanel;
    private JButton closeRecordButton;
    private JPanel navigationPanel;
    private XMLRecordNavigationPanel xmlRecordNavigationPanel;
    private SourceEditorView sourceView;
    private JButton toggleMenuButton;
    private JMenuItem closeOtherItem;
    private TemplateController templateController;
    private JButton reloadButton;
    private JToolBar toolBar;

    public XMLRecordsView(DefaultTemplateView templateView, TemplateController templateController, UndoRedoKeyListener keyListener, final AbstractTemplateModel templateModel, String title) {
        this.templateController = templateController;
        this.xmlRecordNavigationPanel = new XMLRecordNavigationPanel(this);
        this.templateView = templateView;
        this.keyListener = keyListener;
        this.templateModel = templateModel;
        this.title = title;
        templateModel.getRecordsContainer().addRecordListener(this);
        templateModel.addObserver(this);
        this.panel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        this.panel.add((Component)topPanel, "North");
        this.recordIdentifierLabel = new JLabel("");
        this.recordIdentifierLabel.setHorizontalAlignment(0);
        topPanel.add((Component)this.recordIdentifierLabel, "Center");
        this.navigationPanel = new JPanel(new FlowLayout(2));
        this.toolBar = new JToolBar();
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.toolBar.setLayout(new FlowLayout(3, 0, 0));
        this.toolBar.setMargin(new Insets(0, 0, 0, 0));
        this.reloadButton = new JButton(IconUtils.loadIcon("reload"));
        this.reloadButton.setFocusable(false);
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordsView.this.onReloadRecord();
            }
        });
        this.reloadButton.setEnabled(false);
        this.toolBar.add(this.reloadButton);
        this.toggleMenuButton = new JButton(IconUtils.loadIcon("down"));
        this.toggleMenuButton.setMargin(new Insets(3, 3, 3, 3));
        this.toggleMenuButton.setFocusable(false);
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem closeAllItem = new JMenuItem("Close all");
        closeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordsView.this.onCloseAllRecordsItem();
            }
        });
        menu.add(closeAllItem);
        this.closeOtherItem = new JMenuItem("Close other");
        this.closeOtherItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordsView.this.onCloseOtherRecordsItem();
            }
        });
        menu.add(this.closeOtherItem);
        menu.setVisible(false);
        this.toggleMenuButton.setComponentPopupMenu(menu);
        this.toggleMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (menu.isVisible()) {
                    menu.setVisible(false);
                } else {
                    menu.pack();
                    Point pos = new Point();
                    pos.x = 0;
                    pos.y = XMLRecordsView.this.toggleMenuButton.getHeight();
                    menu.show(XMLRecordsView.this.toggleMenuButton, pos.x, pos.y);
                    menu.setVisible(true);
                }
            }
        });
        this.toolBar.add(this.toggleMenuButton);
        this.closeRecordButton = new JButton(this.CROSS_LIGHT_GRAY);
        this.closeRecordButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (templateModel.getRecordsContainer().getCurrentRecord() != null) {
                    XMLRecordsView.this.closeRecordButton.setIcon(XMLRecordsView.this.CROSS_DARK_GRAY);
                } else {
                    XMLRecordsView.this.closeRecordButton.setIcon(XMLRecordsView.this.CROSS_LIGHT_GRAY);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (templateModel.getRecordsContainer().hasRecords()) {
                    XMLRecordsView.this.closeRecordButton.setIcon(XMLRecordsView.this.CROSS_BLACK);
                } else {
                    XMLRecordsView.this.closeRecordButton.setIcon(XMLRecordsView.this.CROSS_LIGHT_GRAY);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.closeRecordButton.setFocusable(false);
        this.closeRecordButton.setEnabled(false);
        this.closeRecordButton.setPressedIcon(this.CROSS_LIGHT_GRAY);
        this.closeRecordButton.setOpaque(true);
        this.closeRecordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordsView.this.onCloseRecordButton();
            }
        });
        this.toolBar.add(this.closeRecordButton);
        this.navigationPanel.add(this.toolBar);
        topPanel.add((Component)this.navigationPanel, "East");
        this.mainPanel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.mainPanel, "Center");
    }

    protected void onReloadRecord() {
        this.templateModel.getRecordsContainer().reloadCurrentRecord();
        this.changeView(this.templateModel.getRecordsContainer().getCurrentRecord());
        this.templateModel.refresh();
    }

    protected void onCloseOtherRecordsItem() {
        if (this.templateModel.getRecordsContainer() instanceof XMLFileRecordsContainer && this.templateModel.getRecordsContainer().getTotalRecordsCount() > 1) {
            for (XMLRecordInterface record : this.templateModel.getRecordsContainer().getAllRecords()) {
                this.templateController.closeRecord(record, false);
            }
            this.templateModel.refresh();
        }
    }

    protected void onCloseAllRecordsItem() {
        if (this.templateModel.hasXSLFileName()) {
            if (this.templateModel.getRecordsContainer().hasRecords()) {
                this.templateController.closeAllRecords();
            }
            this.updateButtons();
            this.updateViewIdentifier();
            this.templateModel.refresh();
        }
    }

    public XMLRecordNavigationPanel getNavigationPanel() {
        return this.xmlRecordNavigationPanel;
    }

    public void onLastButton() {
        if (this.templateModel.getRecordsContainer().hasRecords()) {
            this.changeView(this.templateModel.getRecordsContainer().getLastRecord());
        }
    }

    public void onFirstButton() {
        if (this.templateModel.getRecordsContainer().hasRecords()) {
            this.changeView(this.templateModel.getRecordsContainer().getFirstRecord());
        }
    }

    protected void onCloseRecordButton() {
        this.templateController.closeRecord(this.templateModel.getRecordsContainer().getCurrentRecord(), true);
    }

    public void onRightButton() {
        this.changeView(this.templateModel.getRecordsContainer().getNextRecord());
    }

    private void changeView(final XMLRecordInterface record) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (XMLRecordsView.this.sourceView != null) {
                    XMLRecordsView.this.templateModel.deleteObserver(XMLRecordsView.this.sourceView);
                    XMLRecordsView.this.mainPanel.remove(XMLRecordsView.this.sourceView.getComponent());
                    XMLRecordsView.this.mainPanel.invalidate();
                    XMLRecordsView.this.sourceView.close();
                    XMLRecordsView.this.sourceView = null;
                }
                if (record != null) {
                    XMLRecordsView.this.reloadButton.setEnabled(record.isReloadable());
                    XMLRecordsView.this.sourceView = new SourceEditorView(XMLRecordsView.this.templateView, XMLRecordsView.this.keyListener, XMLRecordsView.this.templateModel, record, null, record.getDisplayName(), true, false, XMLRecordsView.this, null, false, true);
                    XMLRecordsView.this.mainPanel.add(XMLRecordsView.this.sourceView.getComponent());
                    XMLRecordsView.this.mainPanel.revalidate();
                    XMLRecordsView.this.mainPanel.validate();
                    XMLRecordsView.this.mainPanel.repaint();
                    XMLRecordsView.this.updateViewIdentifier();
                    XMLRecordsView.this.templateModel.clearExecutionStatus();
                    XMLRecordsView.this.templateModel.refresh();
                }
            }
        });
    }

    public void onLeftButton() {
        this.changeView(this.templateModel.getRecordsContainer().getPreviousRecord());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.sourceView != null) {
            if (this.templateModel.getRecordsContainer().getCurrentRecord() != null && !this.templateModel.getRecordsContainer().getCurrentRecord().equals(this.sourceView.getIdentifier())) {
                this.changeView(this.templateModel.getRecordsContainer().getCurrentRecord());
            } else if (this.templateModel.getRecordsContainer().getCurrentRecord() == null) {
                this.templateModel.deleteObserver(this.sourceView);
                this.mainPanel.remove(this.sourceView.getComponent());
                this.mainPanel.invalidate();
                this.sourceView.close();
                this.sourceView = null;
            }
            this.updateViewIdentifier();
            this.updateButtons();
        }
    }

    private void updateViewIdentifier() {
        if (this.templateModel.getRecordsContainer().hasRecords()) {
            this.closeRecordButton.setEnabled(true);
            this.toggleMenuButton.setEnabled(true);
            if (this.templateModel.getRecordsContainer().getTotalRecordsCount() > 1) {
                this.closeOtherItem.setEnabled(true);
            } else {
                this.closeOtherItem.setEnabled(false);
            }
            if (this.sourceView != null && this.templateModel.getRecordsContainer().getCurrentRecord() != null) {
                XMLRecordInterface record = this.templateModel.getRecordsContainer().getCurrentRecord();
                String recordName = new File(record.getDisplayName()).getName();
                this.recordIdentifierLabel.setText(recordName);
                this.xmlRecordNavigationPanel.updateViewIdentifier(this.templateModel.getRecordsContainer().getCurrentRecordIndex() + 1, this.templateModel.getRecordsContainer().getTotalRecordsCount(), recordName);
            }
        } else {
            this.closeRecordButton.setEnabled(false);
            this.toggleMenuButton.setEnabled(false);
            this.recordIdentifierLabel.setText("");
            this.xmlRecordNavigationPanel.updateViewIdentifier(0, 0, "");
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int selectedIndex = this.templateModel.getRecordsContainer().getCurrentRecordIndex();
        if (selectedIndex == -1) {
            this.closeRecordButton.setEnabled(false);
        } else if (this.templateModel.getRecordsContainer().getTotalRecordsCount() > 1 && selectedIndex == this.templateModel.getRecordsContainer().getTotalRecordsCount() - 1) {
            this.closeRecordButton.setEnabled(true);
        } else if (this.templateModel.getRecordsContainer().getTotalRecordsCount() > 1 && selectedIndex == 0) {
            this.closeRecordButton.setEnabled(true);
        } else if (this.templateModel.getRecordsContainer().getTotalRecordsCount() == 1) {
            this.closeRecordButton.setEnabled(true);
        } else {
            this.closeRecordButton.setEnabled(true);
        }
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public boolean containsView(SourceEditorView view) {
        return this.templateModel.getRecordsContainer().hasRecord(view.getIdentifier().toString());
    }

    public void activateView(String identifier) {
        XMLRecordInterface record = this.templateModel.getRecordsContainer().setRecordSelected(identifier);
        this.changeView(record);
    }

    @Override
    public void notifyTextModified(SourceEditorView view) {
        XMLRecordInterface record = this.templateModel.getRecordsContainer().getCurrentRecord();
        if (record != null) {
            Document document = view.getDocument();
            try {
                record.updateContentString(document.getText(0, document.getLength()));
                this.updateViewIdentifier();
            }
            catch (BadLocationException exc) {
                logger.warn("Exception during updating record %s", view.getFileName());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }

    public RSyntaxTextArea getTextArea() {
        return this.sourceView != null ? this.sourceView.getTextArea() : null;
    }

    public SourceEditorView getCurrentView() {
        return this.sourceView != null ? this.sourceView : null;
    }

    @Override
    public void recordAdded(String id) {
        this.changeView(this.templateModel.getRecordsContainer().getCurrentRecord());
    }

    @Override
    public void recordRemoved(String id) {
        this.changeView(this.templateModel.getRecordsContainer().getCurrentRecord());
    }

    @Override
    public void allRecordsRemoved() {
        if (this.sourceView != null) {
            this.mainPanel.remove(this.sourceView.getComponent());
            this.sourceView = null;
        }
    }

    public void printCurrentRecord() throws PrinterException {
        if (this.sourceView != null) {
            this.sourceView.print();
        }
    }
}

