/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.view.XMLRecordsView;
import at.mrdevelopment.toolkit.gui.IconUtils;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class XMLRecordNavigationPanel {
    private JButton leftButton;
    private JButton rightButton;
    private JButton lastButton;
    private JButton firstButton;
    private JPanel navigationPanel;
    private JLabel viewCounter;
    private final XMLRecordsView xmlRecordsView;

    public XMLRecordNavigationPanel(XMLRecordsView xmlRecordsView) {
        this.xmlRecordsView = xmlRecordsView;
        this.navigationPanel = new JPanel(new FlowLayout(0, 0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.firstButton = new JButton(IconUtils.loadIcon("First"));
        this.firstButton.setFocusable(false);
        this.firstButton.setOpaque(true);
        this.firstButton.setEnabled(false);
        this.firstButton.setToolTipText("Select first record");
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordNavigationPanel.this.onFirstButton();
            }
        });
        toolBar.add(this.firstButton);
        this.leftButton = new JButton(IconUtils.loadIcon("Previous"));
        this.leftButton.setFocusable(false);
        this.leftButton.setOpaque(true);
        this.leftButton.setEnabled(false);
        this.leftButton.setToolTipText("Select previous record");
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordNavigationPanel.this.onLeftButton();
            }
        });
        toolBar.add(this.leftButton);
        this.viewCounter = new JLabel("0/0");
        toolBar.add(this.viewCounter);
        this.rightButton = new JButton(IconUtils.loadIcon("Next"));
        this.rightButton.setFocusable(false);
        this.rightButton.setOpaque(true);
        this.rightButton.setEnabled(false);
        this.rightButton.setToolTipText("Select next record");
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordNavigationPanel.this.onRightButton();
            }
        });
        toolBar.add(this.rightButton);
        this.lastButton = new JButton(IconUtils.loadIcon("Last"));
        this.lastButton.setFocusable(false);
        this.lastButton.setOpaque(true);
        this.lastButton.setEnabled(false);
        this.lastButton.setToolTipText("Select last record");
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLRecordNavigationPanel.this.onLastButton();
            }
        });
        toolBar.add(this.lastButton);
        this.navigationPanel.add(toolBar);
    }

    protected void onLastButton() {
        this.xmlRecordsView.onLastButton();
    }

    protected void onRightButton() {
        this.xmlRecordsView.onRightButton();
    }

    protected void onLeftButton() {
        this.xmlRecordsView.onLeftButton();
    }

    protected void onFirstButton() {
        this.xmlRecordsView.onFirstButton();
    }

    public void updateViewIdentifier(int index, int count, String name) {
        this.viewCounter.setText(String.format("%s (%d/%d)", name, index, count));
        this.updateButtons(index, count);
    }

    private void updateButtons(int index, int count) {
        if (index == 0) {
            this.leftButton.setEnabled(false);
            this.rightButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.firstButton.setEnabled(false);
        } else if (count > 1 && index == count) {
            this.leftButton.setEnabled(true);
            this.rightButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.firstButton.setEnabled(true);
        } else if (count > 1 && index == 1) {
            this.rightButton.setEnabled(true);
            this.leftButton.setEnabled(false);
            this.lastButton.setEnabled(true);
            this.firstButton.setEnabled(false);
        } else if (count == 1) {
            this.rightButton.setEnabled(false);
            this.leftButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.firstButton.setEnabled(false);
        } else {
            this.rightButton.setEnabled(true);
            this.leftButton.setEnabled(true);
            this.lastButton.setEnabled(true);
            this.firstButton.setEnabled(true);
        }
    }

    public JPanel getComponent() {
        return this.navigationPanel;
    }
}

