/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.controller.TemplateController;
import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.EventListener;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashSet;
import java.util.Observer;
import java.util.Set;
import javax.swing.JTextArea;
import javax.swing.undo.UndoManager;

public abstract class TemplateView
extends EventDispatcher
implements Observer,
EventListener,
Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(TemplateView.class);
    protected TemplateController templateController;
    protected AbstractTemplateModel templateModel;
    private Set<Shutdownable> shutdownables = new HashSet<Shutdownable>();

    public TemplateView(TemplateController templateController, AbstractTemplateModel templateModel) {
        this.templateController = templateController;
        this.templateModel = templateModel;
        this.templateModel.addObserver(this);
        this.registerEventListener(this);
    }

    public void registerShutdownable(Shutdownable shutdownable) {
        this.shutdownables.add(shutdownable);
    }

    @Override
    public void shutdown() {
        logger.info("Shutdown imagotag Template Editor");
        for (Shutdownable shutdownable : this.shutdownables) {
            shutdownable.shutdown();
        }
        System.exit(0);
    }

    public abstract void show();

    public abstract JTextArea getCurrentTextArea();

    public abstract UndoManager getCurrentlyActiveUndoManager();

    public abstract String showSaveAsDialog();

    public abstract String showSaveDialog(String var1);

    public abstract int showConfirmDialog(String var1);
}

