/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.template.editor.controller.TemplateCreationController;
import at.mrdevelopment.esl.template.editor.model.TemplateEditorTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TemplateCreationView {
    private final JDialog dialog;
    private final TemplateCreationController controller;
    private JList templateList;
    private JLabel descriptionLabel;
    private Map<Dimension, JCheckBox> labelTypes;
    private JButton createButton;
    private JPanel checkBoxPanel;

    public TemplateCreationView(JFrame parentFrame, TemplateCreationController controller) {
        this.controller = controller;
        this.dialog = new JDialog(parentFrame, "New Template", true);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(2);
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.templateList = new JList<TemplateEditorTemplate>(TemplateEditorTemplate.values());
        this.templateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TemplateCreationView.this.createButton.setEnabled(TemplateCreationView.this.templateList.getSelectedIndex() >= 0);
                TemplateCreationView.this.updateDetailView();
            }
        });
        leftPanel.add((Component)this.templateList, "Center");
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.descriptionLabel = new JLabel();
        rightPanel.add((Component)this.descriptionLabel, "North");
        this.checkBoxPanel = new JPanel(new FlowLayout());
        this.labelTypes = new HashMap<Dimension, JCheckBox>();
        for (LabelType labelType : LabelType.values()) {
            Dimension dimension = new Dimension(labelType.getDisplayWidth(), labelType.getDisplayHeight());
            if (this.labelTypes.containsKey(dimension) || dimension.width <= 0 || dimension.height <= 0) continue;
            JCheckBox checkBox = new JCheckBox(String.format("%d x %d", dimension.width, dimension.height));
            this.checkBoxPanel.add(checkBox);
            this.labelTypes.put(dimension, checkBox);
        }
        this.checkBoxPanel.setVisible(false);
        rightPanel.add((Component)this.checkBoxPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(3));
        this.createButton = new JButton("Create");
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateCreationView.this.onCreateButton();
            }
        });
        buttonPanel.add(this.createButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateCreationView.this.onCancelButton();
            }
        });
        buttonPanel.add(cancelButton);
        this.dialog.add((Component)buttonPanel, "South");
        JSplitPane splitPane = new JSplitPane(1, leftPanel, rightPanel);
        this.dialog.add((Component)splitPane, "Center");
        this.dialog.setPreferredSize(new Dimension(400, 300));
        this.dialog.setResizable(false);
        this.dialog.getRootPane().setDefaultButton(this.createButton);
        this.registerEscapeKeyAction();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentFrame);
        this.templateList.setSelectedIndex(0);
        this.dialog.setVisible(true);
    }

    protected void updateDetailView() {
        if (this.templateList.getSelectedIndex() >= 0) {
            final TemplateEditorTemplate template = (TemplateEditorTemplate)((Object)this.templateList.getSelectedValue());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplateCreationView.this.descriptionLabel.setText(template.getDescription());
                    if (template.isDynamic()) {
                        TemplateCreationView.this.checkBoxPanel.setVisible(true);
                    } else {
                        TemplateCreationView.this.checkBoxPanel.setVisible(false);
                    }
                }
            });
        }
    }

    protected void onCancelButton() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    protected void onCreateButton() {
        if (this.templateList.getSelectedIndex() >= 0) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.controller.createTemplate((TemplateEditorTemplate)((Object)this.templateList.getSelectedValue()), this.labelTypes);
        }
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateCreationView.this.dialog.setVisible(false);
                TemplateCreationView.this.dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

