/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.common.TemplateLanguageSupport;
import at.mrdevelopment.esl.template.editor.controller.undoredo.UndoRedoKeyListener;
import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.esl.template.editor.view.DefaultTemplateView;
import at.mrdevelopment.esl.template.editor.view.TextModificationListener;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.undo.UndoManager;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.xml.XmlParser;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RUndoManager;

public class SourceEditorView
extends AbstractView
implements View,
Observer {
    static ESLLogger logger = ESLLogger.getLogger(SourceEditorView.class);
    private static final long DEFAULT_KEY_PRESSED_TIMEOUT = 1500L;
    private JPanel panel;
    private final AbstractTemplateModel model;
    private boolean ignoreChanges = true;
    private final Object identifier;
    private final UndoManager undoManager;
    private String fileName;
    private final boolean editable;
    private volatile long lastKeyPressed = 0L;
    private KeyPressTimer keyPressedTimer;
    private String title;
    private String modified = "";
    private final UndoRedoKeyListener keyListener;
    private final TextModificationListener modificationListener;
    private RSyntaxTextArea textArea;
    private DocumentListener documentListener;

    public SourceEditorView(final DefaultTemplateView templateView, UndoRedoKeyListener keyListener, AbstractTemplateModel templateModel, Object identifier, UndoManager undoManager, String title, boolean editable, boolean notifyOnInitialization, TextModificationListener modificationListener, String xsdContent, boolean autoCompleteEnabled, boolean codeFoldingEnabled) {
        Object parserProperty;
        this.keyListener = keyListener;
        this.model = templateModel;
        this.identifier = identifier;
        this.title = title;
        this.editable = editable;
        this.modificationListener = modificationListener;
        this.keyPressedTimer = new KeyPressTimer();
        new Thread(this.keyPressedTimer).start();
        this.panel = new JPanel(new BorderLayout());
        this.textArea = new RSyntaxTextArea(20, 60);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.textArea);
        LanguageSupportFactory.get().register(this.textArea);
        this.textArea.setSyntaxEditingStyle("text/xml");
        this.textArea.setCodeFoldingEnabled(codeFoldingEnabled);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setCloseMarkupTags(true);
        this.textArea.setHighlightCurrentLine(true);
        TemplateLanguageSupport support = new TemplateLanguageSupport();
        support.setAutoCompleteEnabled(autoCompleteEnabled);
        support.install(this.textArea);
        try {
            Theme theme = Theme.load((InputStream)Theme.class.getResourceAsStream("/eclipse.xml"));
            theme.apply(this.textArea);
        }
        catch (IOException exc) {
            logger.debug("Could not find specified theme for editor");
        }
        if (xsdContent != null && (parserProperty = this.textArea.getClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser")) != null && parserProperty instanceof XmlParser) {
            XmlParser xmlParser = (XmlParser)parserProperty;
            xmlParser.setValidate(xsdContent);
        }
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setEditable(editable);
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.textArea);
        scrollPane.setFoldIndicatorEnabled(true);
        this.panel.add((Component)scrollPane, "Center");
        this.updateTextArea(notifyOnInitialization);
        this.model.setSourceCode(this, identifier);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(0);
        this.textArea.addKeyListener((KeyListener)keyListener);
        this.documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceEditorView.this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceEditorView.this.documentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textArea.getDocument().addDocumentListener(this.documentListener);
        this.undoManager = undoManager != null ? undoManager : this.textArea.getUndoManager();
        this.textArea.getDocument().removeUndoableEditListener(this.undoManager);
        this.textArea.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                if (SourceEditorView.this.editable && SourceEditorView.this.panel.isVisible() && !SourceEditorView.this.ignoreChanges) {
                    if (SourceEditorView.this.undoManager instanceof RUndoManager) {
                        ((RUndoManager)SourceEditorView.this.undoManager).undoableEditHappened(e);
                    } else {
                        SourceEditorView.this.undoManager.addEdit(e.getEdit());
                    }
                    templateView.update(null, null);
                }
            }
        });
        this.model.addObserver(this);
    }

    private void documentChanged() {
        if (!this.ignoreChanges && this.lastKeyPressed == 0L) {
            if (this.modificationListener != null) {
                this.modificationListener.notifyTextModified(this);
            }
            this.lastKeyPressed = System.currentTimeMillis();
            this.textArea.getDocument().removeDocumentListener(this.documentListener);
        }
    }

    private void updateTextArea(boolean notifyModel) {
        this.ignoreChanges = true;
        this.lastKeyPressed = 0L;
        this.textArea.getDocument().removeDocumentListener(this.documentListener);
        final boolean notify = notifyModel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String text = SourceEditorView.this.model.getSourceString(SourceEditorView.this.identifier);
                    if (text != null) {
                        text = text.replaceAll("    ", "\t");
                    }
                    List<Fold> folds = SourceEditorView.this.getFolds();
                    SourceEditorView.this.textArea.getDocument().remove(0, SourceEditorView.this.textArea.getDocument().getLength());
                    if (text != null) {
                        SourceEditorView.this.textArea.getDocument().insertString(0, text, null);
                        SourceEditorView.this.textArea.getFoldManager().setFolds(folds);
                        SourceEditorView.this.textArea.repaint();
                    }
                    if (notify) {
                        SourceEditorView.this.model.sourceCodeUpdated(SourceEditorView.this, SourceEditorView.this.identifier);
                    }
                }
                catch (Exception exc) {
                    logger.debug(exc.getMessage());
                    logger.logExceptionIfDebugEnabled(exc);
                }
                SourceEditorView.this.ignoreChanges = false;
                SourceEditorView.this.lastKeyPressed = 0L;
                SourceEditorView.this.textArea.getDocument().addDocumentListener(SourceEditorView.this.documentListener);
            }
        });
    }

    protected List<Fold> getFolds() {
        ArrayList<Fold> foldList = new ArrayList<Fold>();
        for (int index = 0; index < this.textArea.getFoldManager().getFoldCount(); ++index) {
            Fold fold = this.textArea.getFoldManager().getFold(index);
            foldList.add(fold);
        }
        return foldList;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getTitle() {
        return this.fileName != null ? this.title + " (" + new File(this.fileName).getName() + ")" + this.modified : this.title;
    }

    public String getSourceString() {
        try {
            return this.textArea.getDocument().getText(0, this.textArea.getDocument().getLength());
        }
        catch (BadLocationException exc) {
            logger.logException(exc);
            return "";
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg != null && arg.equals(this.identifier)) {
            this.updateTextArea(true);
        }
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    public void goTo(int lineNumber, int columnNumber) {
        Element root;
        if (lineNumber > 0 && columnNumber > 0 && (root = this.textArea.getDocument().getDefaultRootElement()).getElement(lineNumber - 1) != null) {
            this.textArea.setCaretPosition(root.getElement(lineNumber - 1).getStartOffset());
            this.textArea.moveCaretPosition(root.getElement(lineNumber - 1).getStartOffset() + columnNumber - 1);
            this.textArea.getCaret().setSelectionVisible(true);
        }
    }

    public void updateDocument(String stringFromDOMSource) {
        this.ignoreChanges = true;
        this.lastKeyPressed = 0L;
        try {
            if (stringFromDOMSource != null) {
                stringFromDOMSource = stringFromDOMSource.replaceAll("    ", "\t").replaceAll("\r\n", "\n");
            }
            String stringToInsert = stringFromDOMSource;
            List<Fold> folds = this.getFolds();
            this.getDocument().remove(0, this.getDocument().getLength());
            this.getDocument().insertString(0, stringToInsert, null);
            this.textArea.getFoldManager().setFolds(folds);
            this.textArea.repaint();
        }
        catch (Exception exc) {
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        this.ignoreChanges = false;
        this.lastKeyPressed = 0L;
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void close() {
        this.getComponent().setVisible(false);
        this.textArea.removeKeyListener((KeyListener)this.keyListener);
    }

    public void setModified(boolean xslModified) {
        this.modified = xslModified ? "*" : "";
    }

    public RSyntaxTextArea getTextArea() {
        return this.textArea;
    }

    public UndoManager getUndoManager() {
        return this.textArea.getUndoManager();
    }

    public void print() throws PrinterException {
        this.getTextArea().print();
    }

    private class KeyPressTimer
    implements Shutdownable,
    Runnable {
        private long timeout = 100L;
        private boolean shutdownRequested = false;

        private KeyPressTimer() {
        }

        @Override
        public void run() {
            while (!this.shutdownRequested) {
                if (SourceEditorView.this.lastKeyPressed > 0L && System.currentTimeMillis() - SourceEditorView.this.lastKeyPressed > 1500L) {
                    SourceEditorView.this.model.sourceCodeUpdated(SourceEditorView.this, SourceEditorView.this.identifier);
                    SourceEditorView.this.lastKeyPressed = 0L;
                    SourceEditorView.this.textArea.getDocument().addDocumentListener(SourceEditorView.this.documentListener);
                }
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public void shutdown() {
            this.shutdownRequested = true;
        }
    }
}

