/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.view.TemplateView;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class SearchAndReplaceDialog {
    private JDialog dialog;
    private JComboBox searchForText;
    private JComboBox replaceWithText;
    private JButton replaceAllButton;
    private JButton findNextButton;
    private JRadioButton forwardButton;
    private JRadioButton backwardButton;
    private JRadioButton scopeAllButton;
    private JRadioButton scopeSelectedButton;
    private JCheckBox caseSensitiveBox;
    private JCheckBox wholeWordBox;
    private JCheckBox regularExpressionsBox;
    private JButton replaceButton;
    private final TemplateView templateView;
    private final DefaultComboBoxModel searchForModel;
    private final DefaultComboBoxModel replaceWithModel;

    public SearchAndReplaceDialog(JFrame parent, TemplateView templateView) {
        this.templateView = templateView;
        this.searchForModel = new DefaultComboBoxModel();
        this.replaceWithModel = new DefaultComboBoxModel();
        this.dialog = new JDialog(parent, "Find/Replace", false);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setResizable(false);
        InputChangedListener listener = new InputChangedListener();
        JPanel topPanel = new JPanel(new SpringLayout());
        topPanel.add(new JLabel("Find:"));
        this.searchForText = new JComboBox(this.searchForModel);
        this.searchForText.setEditable(true);
        ((JTextComponent)this.searchForText.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
        this.searchForText.addItemListener(listener);
        topPanel.add(this.searchForText);
        topPanel.add(new JLabel("Replace with:"));
        this.replaceWithText = new JComboBox(this.replaceWithModel);
        this.replaceWithText.setEditable(true);
        ((JTextComponent)this.replaceWithText.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
        this.replaceWithText.addItemListener(listener);
        topPanel.add(this.replaceWithText);
        this.dialog.add((Component)topPanel, "North");
        JPanel directionPanel = new JPanel(new GridLayout(0, 1, 3, 3));
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.forwardButton = new JRadioButton("Forward", true);
        this.forwardButton.addItemListener(listener);
        this.backwardButton = new JRadioButton("Backward");
        this.backwardButton.addItemListener(listener);
        directionPanel.add(this.forwardButton);
        directionPanel.add(this.backwardButton);
        ButtonGroup directionGroup = new ButtonGroup();
        directionGroup.add(this.forwardButton);
        directionGroup.add(this.backwardButton);
        topPanel.add(directionPanel);
        JPanel scopePanel = new JPanel(new GridLayout(0, 1, 3, 3));
        scopePanel.setBorder(BorderFactory.createTitledBorder("Scope"));
        this.scopeAllButton = new JRadioButton("All", true);
        this.scopeAllButton.addItemListener(listener);
        this.scopeSelectedButton = new JRadioButton("Selected lines");
        this.scopeSelectedButton.addItemListener(listener);
        scopePanel.add(this.scopeAllButton);
        scopePanel.add(this.scopeSelectedButton);
        ButtonGroup scopeGroup = new ButtonGroup();
        scopeGroup.add(this.scopeAllButton);
        scopeGroup.add(this.scopeSelectedButton);
        topPanel.add(scopePanel);
        JPanel optionsPanel = new JPanel(new GridLayout(0, 2, 3, 3));
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        this.caseSensitiveBox = new JCheckBox("Case sensitive");
        this.caseSensitiveBox.addItemListener(listener);
        this.wholeWordBox = new JCheckBox("Whole word");
        this.wholeWordBox.addItemListener(listener);
        this.regularExpressionsBox = new JCheckBox("Regular expressions");
        this.regularExpressionsBox.addItemListener(listener);
        optionsPanel.add(this.caseSensitiveBox);
        optionsPanel.add(this.wholeWordBox);
        optionsPanel.add(this.regularExpressionsBox);
        this.dialog.add((Component)optionsPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.findNextButton = new JButton("Find");
        this.dialog.getRootPane().setDefaultButton(this.findNextButton);
        this.findNextButton.setEnabled(false);
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchAndReplaceDialog.this.findNextButton.isEnabled()) {
                    SearchAndReplaceDialog.this.onFindNextButton();
                }
            }
        });
        buttonPanel.add(this.findNextButton);
        this.replaceButton = new JButton("Replace");
        this.replaceButton.setEnabled(false);
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchAndReplaceDialog.this.replaceButton.isEnabled()) {
                    SearchAndReplaceDialog.this.onReplaceButton();
                }
            }
        });
        buttonPanel.add(this.replaceButton);
        this.replaceAllButton = new JButton("Replace All");
        this.replaceAllButton.setEnabled(false);
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchAndReplaceDialog.this.replaceAllButton.isEnabled()) {
                    SearchAndReplaceDialog.this.onReplaceAllButton();
                }
            }
        });
        buttonPanel.add(this.replaceAllButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchAndReplaceDialog.this.dialog.setVisible(false);
            }
        });
        buttonPanel.add(closeButton);
        this.dialog.add((Component)buttonPanel, "South");
        SpringUtilities.makeCompactGrid(topPanel, 3, 2, 5, 5, 5, 15);
        this.dialog.setVisible(false);
        this.dialog.getRootPane().setDefaultButton(this.findNextButton);
        this.registerEscapeKey();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
    }

    private void registerEscapeKey() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchAndReplaceDialog.this.hideDialog();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void onReplaceButton() {
        JTextArea textArea = this.templateView.getCurrentTextArea();
        String searchFor = this.getSearchForText();
        String replaceWith = this.getReplaceWithText();
        if (searchFor != null && searchFor.length() > 0 && replaceWith != null && replaceWith.length() > 0) {
            if (this.searchForModel.getIndexOf(searchFor) < 0) {
                this.searchForModel.addElement(searchFor);
            }
            if (this.replaceWithModel.getIndexOf(replaceWith) < 0) {
                this.replaceWithModel.addElement(replaceWith);
            }
        } else {
            return;
        }
        if (textArea != null && textArea.isEditable() && textArea instanceof RTextArea) {
            RTextArea rTextArea = (RTextArea)textArea;
            SearchContext context = this.createSearchContext();
            context.setSearchFor(searchFor);
            context.setReplaceWith(replaceWith);
            boolean found = SearchEngine.replace((RTextArea)rTextArea, (SearchContext)context);
            if (!found) {
                int oldCaretPosition = textArea.getCaretPosition();
                textArea.setCaretPosition(this.forwardButton.isSelected() ? 0 : textArea.getDocument().getEndPosition().getOffset() - 1);
                found = SearchEngine.replace((RTextArea)rTextArea, (SearchContext)context);
                if (!found) {
                    textArea.setCaretPosition(oldCaretPosition);
                    this.showNotFoundMessage(searchFor);
                }
            }
        }
    }

    protected void onReplaceAllButton() {
        JTextArea textArea = this.templateView.getCurrentTextArea();
        String searchFor = this.getSearchForText();
        String replaceWith = this.getReplaceWithText();
        if (searchFor != null && searchFor.length() > 0 && replaceWith != null && replaceWith.length() > 0) {
            if (this.searchForModel.getIndexOf(searchFor) < 0) {
                this.searchForModel.addElement(searchFor);
            }
            if (this.replaceWithModel.getIndexOf(replaceWith) < 0) {
                this.replaceWithModel.addElement(replaceWith);
            }
        } else {
            return;
        }
        if (textArea != null && textArea.isEditable() && textArea instanceof RTextArea) {
            RTextArea rTextArea = (RTextArea)textArea;
            SearchContext context = this.createSearchContext();
            context.setSearchFor(searchFor);
            context.setReplaceWith(replaceWith);
            int found = SearchEngine.replaceAll((RTextArea)rTextArea, (SearchContext)context);
            if (found == 0) {
                this.showNotFoundMessage(searchFor);
            } else {
                this.showReplacedMessage(searchFor, replaceWith, found);
            }
        }
    }

    private void showReplacedMessage(String searchFor, String replaceWith, int numberOfReplacements) {
        JOptionPane.showMessageDialog(this.dialog, String.format("%d matches replaced", numberOfReplacements), "Replaced", 1);
    }

    protected void onFindNextButton() {
        boolean found;
        String searchFor = this.getSearchForText();
        if (searchFor != null && searchFor.length() > 0) {
            if (this.searchForModel.getIndexOf(searchFor) < 0) {
                this.searchForModel.addElement(searchFor);
            }
        } else {
            return;
        }
        SearchContext context = this.createSearchContext();
        context.setSearchFor(searchFor);
        JTextArea textArea = this.templateView.getCurrentTextArea();
        if (textArea != null && !(found = SearchEngine.find((JTextArea)textArea, (SearchContext)context))) {
            int oldCaretPosition = textArea.getCaretPosition();
            textArea.setCaretPosition(this.forwardButton.isSelected() ? 0 : textArea.getDocument().getEndPosition().getOffset() - 1);
            found = SearchEngine.find((JTextArea)textArea, (SearchContext)context);
            if (!found) {
                textArea.setCaretPosition(oldCaretPosition);
                this.showNotFoundMessage(searchFor);
            }
        }
    }

    private String getSearchForText() {
        return ((JTextField)this.searchForText.getEditor().getEditorComponent()).getText();
    }

    private String getReplaceWithText() {
        return ((JTextField)this.replaceWithText.getEditor().getEditorComponent()).getText();
    }

    private void showNotFoundMessage(String searchFor) {
        JOptionPane.showMessageDialog(this.dialog, String.format("String \"%s\" not found", searchFor), "Not found", 1);
    }

    private SearchContext createSearchContext() {
        SearchContext context = new SearchContext();
        context.setMatchCase(this.caseSensitiveBox.isSelected());
        context.setRegularExpression(this.regularExpressionsBox.isSelected());
        context.setSearchForward(this.forwardButton.isSelected());
        context.setSearchSelectionOnly(this.scopeSelectedButton.isSelected());
        context.setWholeWord(this.wholeWordBox.isSelected());
        return context;
    }

    public void showDialog() {
        this.dialog.getRootPane().setDefaultButton(this.findNextButton);
        this.registerEscapeKey();
        this.dialog.setVisible(true);
    }

    public void hideDialog() {
        this.dialog.setVisible(false);
    }

    public void inputChanged() {
        this.enableButtons(!this.getSearchForText().isEmpty());
        this.wholeWordBox.setEnabled(!this.regularExpressionsBox.isSelected());
    }

    private void enableButtons(boolean enable) {
        this.findNextButton.setEnabled(enable);
        this.replaceAllButton.setEnabled(enable);
        this.replaceButton.setEnabled(enable);
    }

    private class InputChangedListener
    implements DocumentListener,
    ItemListener {
        private InputChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchAndReplaceDialog.this.inputChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchAndReplaceDialog.this.inputChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchAndReplaceDialog.this.inputChanged();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SearchAndReplaceDialog.this.inputChanged();
        }
    }
}

