/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.common.CoordinatesMouseListener;
import at.mrdevelopment.esl.template.editor.controller.undoredo.UndoRedoKeyListener;
import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.esl.template.editor.view.ChooseLabelsView;
import at.mrdevelopment.esl.template.editor.view.DefaultTemplateView;
import at.mrdevelopment.esl.template.editor.view.ImagePreviewView;
import at.mrdevelopment.esl.template.editor.view.SourceEditorView;
import at.mrdevelopment.esl.template.editor.view.Zoomable;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PreviewView
extends AbstractView
implements View,
Observer,
Zoomable {
    static ESLLogger logger = ESLLogger.getLogger(PreviewView.class);
    private final AbstractTemplateModel templateModel;
    private JTabbedPane panel;
    private SourceEditorView recordSource;
    private SourceEditorView imageSource;
    private ImagePreviewView imageView;
    private BufferedImage image;
    private JScrollPane imageScrollPane;
    private JPopupMenu contextMenu;
    private JMenuItem saveImageAsItem;
    private JLabel zoomLabel;
    private JCheckBox debugCheckBox;
    private JCheckBox renderAllRecordsCheckBox;
    private JComboBox rotationBox;
    private JMenuItem sendImageToLabelsItem;

    public PreviewView(DefaultTemplateView templateView, UndoRedoKeyListener keyListener, AbstractTemplateModel templateModel) throws InitializationException {
        this.templateModel = templateModel;
        this.contextMenu = new JPopupMenu();
        this.saveImageAsItem = new JMenuItem("Save Preview Image");
        this.saveImageAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewView.this.onSaveImage();
            }
        });
        this.contextMenu.add(this.saveImageAsItem);
        this.sendImageToLabelsItem = new JMenuItem("Send Preview Image");
        this.sendImageToLabelsItem.setEnabled(false);
        this.sendImageToLabelsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewView.this.onSendImageToLabelsButton();
            }
        });
        this.contextMenu.add(this.sendImageToLabelsItem);
        this.panel = new JTabbedPane();
        this.imageView = new ImagePreviewView(templateModel.getDefaultImage(), 10.0);
        this.imageView.addMouseMotionListener(new CoordinatesMouseListener(templateView, this));
        this.imageView.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PreviewView.this.showContextMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.imageView.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() >= 0) {
                    PreviewView.this.imageView.zoomOut();
                } else {
                    PreviewView.this.imageView.zoomIn();
                }
                PreviewView.this.adjustPanel();
            }
        });
        this.recordSource = new SourceEditorView(templateView, keyListener, templateModel, "RECORD", null, "Record Source", false, true, null, null, false, false);
        this.panel.addTab("Record", this.recordSource.getComponent());
        String xsdContent = null;
        try {
            xsdContent = IOUtils.toString((InputStream)XMLToolkit.class.getResourceAsStream("/xsd/image.xsd"));
        }
        catch (IOException exc) {
            throw new InitializationException(exc);
        }
        this.imageSource = new SourceEditorView(templateView, keyListener, templateModel, "RENDERING", null, "Rendering Source", false, true, null, xsdContent, false, false);
        this.panel.add("Rendering Source", this.imageSource.getComponent());
        this.imageScrollPane = new JScrollPane(this.imageView);
        this.imageScrollPane.setBorder(null);
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.add((Component)this.imageScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel statusPanel = new JPanel(new FlowLayout(2));
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        this.zoomLabel = new JLabel("Zoom: 100%");
        statusPanel.add(this.zoomLabel);
        JPanel debugPanel = new JPanel(new FlowLayout(0));
        this.debugCheckBox = new JCheckBox("Enable Debug Preview", templateModel.isDebugEnabled());
        this.debugCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.debugCheckBox.setBorder(null);
        this.debugCheckBox.setEnabled(templateModel.hasXSLFileName());
        this.debugCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreviewView.this.templateModel.setDebugEnabled(PreviewView.this.debugCheckBox.isSelected());
            }
        });
        debugPanel.add(this.debugCheckBox);
        this.renderAllRecordsCheckBox = new JCheckBox("Render All Records", templateModel.isRenderAllRecordsEnabled());
        this.renderAllRecordsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.renderAllRecordsCheckBox.setBorder(null);
        this.renderAllRecordsCheckBox.setEnabled(templateModel.hasXSLFileName());
        this.renderAllRecordsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreviewView.this.templateModel.setRenderAllRecordsEnabled(PreviewView.this.renderAllRecordsCheckBox.isSelected());
            }
        });
        debugPanel.add(this.renderAllRecordsCheckBox);
        debugPanel.add(new JLabel("Rotation:"));
        this.rotationBox = new JComboBox<Integer>(new Integer[]{0, 90, 180, 270});
        this.rotationBox.setEditable(false);
        this.rotationBox.setEnabled(templateModel.hasXSLFileName());
        this.rotationBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreviewView.this.adjustPanel();
            }
        });
        this.rotationBox.setSelectedIndex(0);
        debugPanel.add(this.rotationBox);
        bottomPanel.add((Component)debugPanel, "West");
        bottomPanel.add((Component)statusPanel, "East");
        imagePanel.add((Component)bottomPanel, "South");
        this.panel.addTab("Image", imagePanel);
        templateModel.addObserver(this);
    }

    protected void onSendImageToLabelsButton() {
        this.sendImageToLabels();
    }

    public void changeView(SourceEditorView view) {
        this.panel.setSelectedComponent(view.getComponent());
    }

    public void zoomIn() {
        this.imageView.zoomIn();
        this.adjustPanel();
    }

    public void zoomOut() {
        this.imageView.zoomOut();
        this.adjustPanel();
    }

    public void saveImage() {
        this.onSaveImage();
    }

    public void sendImageToLabels() {
        if (this.templateModel.canSendImageToLabels()) {
            try {
                new ChooseLabelsView(null, this.templateModel.getServerAddress(), this.templateModel);
            }
            catch (InitializationException exc) {
                logger.warn("Could not load labels: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
                this.templateModel.addExecutionStatus(new ExceptionElement(exc));
            }
        }
    }

    protected void onSaveImage() {
        JFileChooser fileChooser = new JFileChooser(DefaultTemplateView.DEFAULT_TEMPLATE_PATH);
        fileChooser.setFileFilter(new FileNameExtensionFilter("PNG (.png)", "png"));
        int returnVal = fileChooser.showSaveDialog(this.getComponent());
        if (returnVal == 0) {
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (!FilenameUtils.isExtension((String)fileName, (String)"png")) {
                fileName = fileName + ".png";
            }
            try {
                ImageIO.write((RenderedImage)((BufferedImage)this.templateModel.getRenderedImage()), "PNG", new File(fileName));
            }
            catch (IOException exc) {
                this.templateModel.addExecutionStatus(new ExceptionElement(exc));
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.debugCheckBox.setEnabled(this.templateModel.hasXSLFileName());
        this.debugCheckBox.setSelected(this.templateModel.isDebugEnabled());
        this.renderAllRecordsCheckBox.setEnabled(this.templateModel.hasXSLFileName());
        this.rotationBox.setEnabled(this.templateModel.hasXSLFileName());
        this.sendImageToLabelsItem.setEnabled(this.templateModel.canSendImageToLabels());
        Image newImage = null;
        newImage = arg != null && arg instanceof Image ? (Image)arg : this.templateModel.getRenderedImage();
        this.image = (BufferedImage)newImage;
        this.adjustPanel();
    }

    private void adjustPanel() {
        this.zoomLabel.setText("Zoom: " + String.valueOf(Math.round(this.imageView.getZoomedTo())) + "%");
        Integer rotation = (Integer)this.rotationBox.getSelectedItem();
        if (rotation != null && rotation > 0) {
            this.imageView.setImage(ImageUtils.rotate(this.image, rotation));
        } else {
            this.imageView.setImage(this.image);
        }
        this.imageView.repaint();
        this.imageView.revalidate();
        this.imageScrollPane.revalidate();
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return "Preview";
    }

    public void setCaretToField(int fieldId) {
        try {
            String sourceCode = this.imageSource.getDocument().getText(0, this.imageSource.getDocument().getLength());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sourceCode.getBytes());
            Document document = new PositionalXMLReader().readXML(inputStream);
            ((InputStream)inputStream).close();
            NodeList fieldNodeList = document.getElementsByTagName("field");
            if (fieldId < fieldNodeList.getLength()) {
                Integer lineNumber = Integer.valueOf(fieldNodeList.item(fieldId).getUserData("lineNumber").toString());
                Integer columnNumber = Integer.valueOf(fieldNodeList.item(fieldId).getUserData("columnNumber").toString());
                if (lineNumber != null && columnNumber != null) {
                    this.imageSource.goTo(lineNumber, columnNumber);
                }
                this.panel.setSelectedComponent(this.imageSource.getComponent());
            }
        }
        catch (IOException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (SAXException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (BadLocationException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    public void setCaretToTableElement(int fieldId, int rowNumber, int columnNumber) {
        try {
            String sourceCode = this.imageSource.getDocument().getText(0, this.imageSource.getDocument().getLength());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sourceCode.getBytes());
            Document document = new PositionalXMLReader().readXML(inputStream);
            ((InputStream)inputStream).close();
            int lineNumber = 0;
            int caretColumnNumber = 0;
            NodeList fieldNodeList = document.getElementsByTagName("field");
            if (fieldId > 0 && fieldNodeList.getLength() >= fieldId) {
                Element fieldElement = (Element)fieldNodeList.item(fieldId - 1);
                NodeList tableRowNodeList = fieldElement.getElementsByTagName("tr");
                if (rowNumber > 0 && tableRowNodeList.getLength() >= rowNumber) {
                    Element tableRowElement = (Element)tableRowNodeList.item(rowNumber - 1);
                    NodeList tableDataNodeList = tableRowElement.getElementsByTagName("td");
                    if (columnNumber > 0 && tableDataNodeList.getLength() >= columnNumber) {
                        Node tableDataNode = tableDataNodeList.item(columnNumber - 1);
                        lineNumber = Integer.valueOf(tableDataNode.getUserData("lineNumber").toString());
                        caretColumnNumber = Integer.valueOf(tableDataNode.getUserData("columnNumber").toString());
                    } else {
                        lineNumber = Integer.valueOf(tableRowElement.getUserData("lineNumber").toString());
                        caretColumnNumber = Integer.valueOf(tableRowElement.getUserData("columnNumber").toString());
                    }
                } else {
                    lineNumber = Integer.valueOf(fieldElement.getUserData("lineNumber").toString());
                    caretColumnNumber = Integer.valueOf(fieldElement.getUserData("columnNumber").toString());
                }
                this.imageSource.goTo(lineNumber, caretColumnNumber);
                this.panel.setSelectedComponent(this.imageSource.getComponent());
            }
        }
        catch (IOException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (SAXException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (BadLocationException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    private void showContextMenu(int x, int y) {
        this.saveImageAsItem.setEnabled(this.templateModel.getRenderedImage() != null && this.templateModel.getRenderedImage() instanceof BufferedImage);
        this.contextMenu.show(this.imageView, x, y);
    }

    @Override
    public int getXCoordinate(int mouseXCoordinate) {
        return Math.round((float)mouseXCoordinate / (float)(this.imageView.getZoomedTo() / 100.0));
    }

    @Override
    public int getYCoordinate(int mouseYCoordinate) {
        return Math.round((float)mouseYCoordinate / (float)(this.imageView.getZoomedTo() / 100.0));
    }

    public Component getSelectedComponent() {
        return this.panel.getSelectedComponent();
    }

    private class PositionalXMLReader {
        public static final String LINE_NUMBER_KEY_NAME = "lineNumber";
        public static final String COLUMN_NUMBER_KEY_NAME = "columnNumber";

        private PositionalXMLReader() {
        }

        public Document readXML(InputStream inputStream) throws IOException, SAXException {
            Document doc;
            SAXParser parser;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                parser = factory.newSAXParser();
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                doc = docBuilder.newDocument();
            }
            catch (ParserConfigurationException exc) {
                throw new RuntimeException("Can't create SAX parser / DOM builder.", exc);
            }
            final Stack elementStack = new Stack();
            final StringBuilder textBuffer = new StringBuilder();
            DefaultHandler handler = new DefaultHandler(){
                private Locator locator;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.addTextIfNeeded();
                    Element el = doc.createElement(qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                    }
                    el.setUserData(PositionalXMLReader.LINE_NUMBER_KEY_NAME, String.valueOf(this.locator.getLineNumber()), null);
                    el.setUserData(PositionalXMLReader.COLUMN_NUMBER_KEY_NAME, String.valueOf(this.locator.getColumnNumber()), null);
                    elementStack.push(el);
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    this.addTextIfNeeded();
                    Element closedEl = (Element)elementStack.pop();
                    if (elementStack.isEmpty()) {
                        doc.appendChild(closedEl);
                    } else {
                        Element parentEl = (Element)elementStack.peek();
                        parentEl.appendChild(closedEl);
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    textBuffer.append(ch, start, length);
                }

                private void addTextIfNeeded() {
                    if (textBuffer.length() > 0) {
                        Element el = (Element)elementStack.peek();
                        Text textNode = doc.createTextNode(textBuffer.toString());
                        el.appendChild(textNode);
                        textBuffer.delete(0, textBuffer.length());
                    }
                }
            };
            parser.parse(inputStream, handler);
            return doc;
        }
    }
}

