/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.core.DefaultLabelTypeMapping;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.gui.editor.LabelIdEditor;
import at.mrdevelopment.esl.gui.editor.LongEditor;
import at.mrdevelopment.esl.gui.editor.StringEditor;
import at.mrdevelopment.esl.gui.editor.TagEditor;
import at.mrdevelopment.esl.template.editor.model.EnvironmentEntryTableModel;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelSettingsView {
    static ESLLogger logger = ESLLogger.getLogger(LabelSettingsView.class);
    private final TemplateModel templateModel;
    private JPanel generalPanel;
    private JComboBox pageList;
    private LongEditor longEditor;
    private JComboBox typeList;
    private final Map<DisplayLabelType, LabelId> typeMap = new HashMap<DisplayLabelType, LabelId>();
    private JDialog dialog;
    private LabelIdEditor labelEditor;
    private boolean labelChangesInProgress = false;
    private DefaultListModel listModel;
    private JList labelTagList;
    private TagEditor labelTagEditor;
    private StringEditor environmentKeyEditor;
    private StringEditor environmentValueEditor;
    private EnvironmentEntryTableModel environmentTableModel;
    private JTable environmentTable;

    public LabelSettingsView(TemplateModel templateModel, JFrame parentFrame) {
        this.dialog = new JDialog(parentFrame, "Label Record Settings", true);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(2);
        this.initTypeMap();
        this.templateModel = templateModel;
        JTabbedPane mainPanel = new JTabbedPane();
        this.generalPanel = new JPanel(new SpringLayout());
        this.generalPanel.add(new JLabel("Label ID:"));
        this.labelEditor = new LabelIdEditor();
        this.labelEditor.setLabelId(templateModel.getLabelId());
        ((JTextField)this.labelEditor.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                LabelSettingsView.this.labelContentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LabelSettingsView.this.labelContentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LabelSettingsView.this.labelContentChanged();
            }
        });
        this.generalPanel.add(this.labelEditor.getEditorComponent());
        this.generalPanel.add(new JLabel("Label Type:"));
        this.createTypeList();
        LabelId labelId = templateModel.getLabelId();
        LabelType labelType = labelId.getLabelType();
        for (DisplayLabelType type : this.typeMap.keySet()) {
            if (!type.getLabelType().equals((Object)labelType)) continue;
            this.typeList.setSelectedItem(type);
        }
        this.addChangeListener();
        this.generalPanel.add(new JLabel("Page Number:"));
        this.createPageList();
        this.pageList.setSelectedItem(templateModel.getPage());
        this.generalPanel.add(new JLabel("External ID:"));
        this.longEditor = new LongEditor();
        this.longEditor.setCanBeNull(false);
        this.longEditor.setValue((Object)templateModel.getExternalId());
        this.generalPanel.add(this.longEditor.getEditorComponent());
        SpringUtilities.makeCompactGrid(this.generalPanel, 4, 2, 5, 5, 3, 5);
        JPanel generalMainPanel = new JPanel(new BorderLayout());
        generalMainPanel.add((Component)this.generalPanel, "North");
        mainPanel.addTab("General", generalMainPanel);
        JPanel labelTagsPanel = new JPanel(new BorderLayout());
        JPanel labelTagsTopPanel = new JPanel(new FlowLayout());
        this.listModel = new DefaultListModel();
        for (String tag : templateModel.getLabelTags()) {
            this.listModel.addElement(tag);
        }
        this.labelTagList = new JList(this.listModel);
        labelTagsPanel.add((Component)new JScrollPane(this.labelTagList), "Center");
        this.labelTagEditor = new TagEditor();
        ((JTextField)this.labelTagEditor.getEditorComponent()).setColumns(19);
        ((JTextField)this.labelTagEditor.getEditorComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.onAddLabelTagButton();
            }
        });
        labelTagsTopPanel.add(new JLabel("Tag: "));
        labelTagsTopPanel.add(this.labelTagEditor.getEditorComponent());
        JButton addLabelTagButton = new JButton("+");
        addLabelTagButton.setMargin(new Insets(0, 4, 0, 4));
        addLabelTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.onAddLabelTagButton();
            }
        });
        labelTagsTopPanel.add(addLabelTagButton);
        JButton removeLabelTagButton = new JButton("-");
        removeLabelTagButton.setMargin(new Insets(0, 6, 0, 6));
        removeLabelTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedValues;
                for (Object value : selectedValues = LabelSettingsView.this.labelTagList.getSelectedValues()) {
                    LabelSettingsView.this.listModel.removeElement(value);
                }
            }
        });
        labelTagsTopPanel.add(removeLabelTagButton);
        labelTagsPanel.add((Component)labelTagsTopPanel, "North");
        mainPanel.addTab("Tags", labelTagsPanel);
        JPanel environmentMainPanel = new JPanel(new FlowLayout());
        JPanel environmentPanel = new JPanel(new BorderLayout());
        JPanel environmentTopPanel = new JPanel(new FlowLayout(3, 0, 5));
        this.environmentTableModel = new EnvironmentEntryTableModel(templateModel.getEnvironmentSource());
        this.environmentTable = new JTable(this.environmentTableModel);
        this.environmentTable.setAutoCreateRowSorter(true);
        this.environmentTable.setAutoCreateColumnsFromModel(false);
        JScrollPane scrollPane = new JScrollPane(this.environmentTable);
        scrollPane.setPreferredSize(new Dimension(450, 200));
        environmentPanel.add((Component)scrollPane, "Center");
        JPanel environmentEditorPanel = new JPanel(new FlowLayout(3));
        this.environmentKeyEditor = new StringEditor(false);
        ((JTextField)this.environmentKeyEditor.getEditorComponent()).setColumns(12);
        ((JTextField)this.environmentKeyEditor.getEditorComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.onAddEnvironmentButton();
            }
        });
        environmentEditorPanel.add(new JLabel("Key:"));
        environmentEditorPanel.add(this.environmentKeyEditor.getEditorComponent());
        this.environmentValueEditor = new StringEditor(false);
        ((JTextField)this.environmentValueEditor.getEditorComponent()).setColumns(12);
        ((JTextField)this.environmentValueEditor.getEditorComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.onAddEnvironmentButton();
            }
        });
        environmentEditorPanel.add(new JLabel("Value:"));
        environmentEditorPanel.add(this.environmentValueEditor.getEditorComponent());
        environmentTopPanel.add(environmentEditorPanel);
        JButton addEnvironmentButton = new JButton("+");
        addEnvironmentButton.setMargin(new Insets(0, 4, 0, 4));
        addEnvironmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.onAddEnvironmentButton();
            }
        });
        environmentTopPanel.add(addEnvironmentButton);
        JButton removeEnvironmentButton = new JButton("-");
        removeEnvironmentButton.setMargin(new Insets(0, 6, 0, 6));
        removeEnvironmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                for (int selectedRow : selectedRows = LabelSettingsView.this.environmentTable.getSelectedRows()) {
                    LabelSettingsView.this.environmentTableModel.removeEntry((String)LabelSettingsView.this.environmentTableModel.getValueAt(LabelSettingsView.this.environmentTable.convertRowIndexToModel(selectedRow), 0));
                }
            }
        });
        environmentTopPanel.add(removeEnvironmentButton);
        environmentPanel.add((Component)environmentTopPanel, "North");
        environmentMainPanel.add(environmentPanel);
        mainPanel.addTab("Environment", environmentMainPanel);
        this.dialog.add((Component)mainPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.onSaveButton();
            }
        });
        buttonPanel.add(saveButton);
        this.dialog.add((Component)buttonPanel, "South");
        this.dialog.setPreferredSize(new Dimension(460, 340));
        this.dialog.setResizable(false);
        this.dialog.getRootPane().setDefaultButton(saveButton);
        this.registerEscapeKeyAction();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentFrame);
        this.dialog.setVisible(true);
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsView.this.dialog.setVisible(false);
                LabelSettingsView.this.dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void onAddEnvironmentButton() {
        this.environmentKeyEditor.validate();
        this.environmentValueEditor.validate();
        if (!this.environmentKeyEditor.hasErrors() && !this.environmentValueEditor.hasErrors()) {
            String key = this.environmentKeyEditor.getValue();
            String value = this.environmentValueEditor.getValue();
            this.environmentTableModel.addEntry(key, value);
            this.environmentKeyEditor.clear();
            this.environmentValueEditor.clear();
        }
    }

    protected void onAddLabelTagButton() {
        this.labelTagEditor.validate();
        if (!this.labelTagEditor.hasErrors() && !this.listModel.contains(this.labelTagEditor.getValue())) {
            this.listModel.addElement(this.labelTagEditor.getValue());
            this.labelTagEditor.clear();
        }
    }

    protected void typeChanged() {
        if (!this.labelChangesInProgress) {
            this.labelChangesInProgress = true;
            this.labelEditor.validate();
            if (!this.labelEditor.hasErrors()) {
                this.changeLabelIdFromLabelType(((DisplayLabelType)this.typeList.getSelectedItem()).getLabelType());
            }
            this.labelChangesInProgress = false;
        }
    }

    private void changeLabelIdFromLabelType(LabelType labelType) {
        Set codesForType = DefaultLabelTypeMapping.getCodesForType((LabelType)labelType);
        if (codesForType.size() > 0) {
            Integer labelTypeCode = (Integer)codesForType.iterator().next();
            String labelTypePrefix = String.format("%02X", labelTypeCode);
            String labelIdString = this.labelEditor.getLabelId().getLabelIdString();
            String newLabelIdString = labelTypePrefix + labelIdString.substring(2);
            try {
                this.labelEditor.setLabelId(LabelId.fromString((String)newLabelIdString));
            }
            catch (SerializeException exc) {
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }

    protected void labelContentChanged() {
        if (!this.labelChangesInProgress) {
            this.labelChangesInProgress = true;
            this.labelEditor.validate();
            if (!this.labelEditor.hasErrors()) {
                this.changeLabelTypeFromLabelId(this.labelEditor.getLabelId());
            }
            this.labelChangesInProgress = false;
        }
    }

    private void changeLabelTypeFromLabelId(LabelId labelId) {
        for (int index = 0; index < this.typeList.getItemCount(); ++index) {
            if (!((DisplayLabelType)this.typeList.getItemAt(index)).getLabelType().equals((Object)labelId.getLabelType())) continue;
            if (this.typeList.getSelectedIndex() == index) break;
            this.typeList.setSelectedIndex(index);
            break;
        }
    }

    protected void onSaveButton() {
        this.longEditor.validate();
        this.labelEditor.validate();
        if (!this.longEditor.hasErrors() && !this.labelEditor.hasErrors()) {
            this.templateModel.setExternalId(this.longEditor.getValue());
            this.templateModel.setLabelId(this.labelEditor.getLabelId());
            this.templateModel.setPage((Page)this.pageList.getSelectedItem());
            this.templateModel.setLabelTags(this.getLabelTagSet());
            this.templateModel.setEnvironmentSource(this.environmentTableModel.getEntries());
            this.templateModel.settingsChanged();
            this.dialog.dispose();
        }
    }

    private Set<String> getLabelTagSet() {
        Object[] tags = new String[this.listModel.getSize()];
        this.listModel.copyInto(tags);
        return new HashSet<Object>(Arrays.asList(tags));
    }

    private void initTypeMap() {
        try {
            for (Map.Entry mapping : DefaultLabelTypeMapping.INSTANCE.getMapping().entrySet()) {
                LabelType labelType = (LabelType)mapping.getValue();
                LabelId labelId = LabelId.fromString((String)String.format("%02X000000", mapping.getKey()));
                this.typeMap.put(new DisplayLabelType(labelType), labelId);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void createTypeList() {
        this.typeList = new JComboBox<DisplayLabelType>(this.typeMap.keySet().toArray(new DisplayLabelType[this.typeMap.size()]));
        this.typeList.setName("Label Types");
        this.typeList.setEditable(false);
        this.generalPanel.add(this.typeList);
    }

    private void addChangeListener() {
        this.typeList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LabelSettingsView.this.typeChanged();
            }
        });
    }

    private void createPageList() {
        this.pageList = new JComboBox();
        this.pageList.setName("Page List");
        for (Page page : Page.values()) {
            if (!page.isValid()) continue;
            this.pageList.addItem(page);
        }
        this.pageList.setEditable(false);
        this.generalPanel.add(this.pageList);
    }

    private class DisplayLabelType {
        private final LabelType labelType;

        public DisplayLabelType(LabelType labelType) {
            this.labelType = labelType;
        }

        public LabelType getLabelType() {
            return this.labelType;
        }

        public String toString() {
            return this.labelType.toString() + " (" + this.labelType.getDisplayWidth() + "x" + this.labelType.getDisplayHeight() + ")";
        }
    }
}

