/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JPanel;

public class ImagePreviewView
extends JPanel {
    private double zoom = 1.0;
    private double zoomPercentage;
    private Image image;

    public ImagePreviewView(Image image, double zoomPercentage) {
        this.image = image;
        this.zoomPercentage = zoomPercentage / 100.0;
    }

    @Override
    public void paintComponent(Graphics grp) {
        Graphics2D graphics = (Graphics2D)grp;
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.scale(this.zoom, this.zoom);
        graphics.drawImage(this.image, 0, 0, this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.image.getWidth(this) + (double)this.image.getWidth(this) * (this.zoom - 1.0)), (int)((double)this.image.getHeight(this) + (double)this.image.getHeight(this) * (this.zoom - 1.0)));
    }

    public void setZoomPercentage(int zoomPercentage) {
        this.zoomPercentage = (double)zoomPercentage / 100.0;
    }

    public void originalSize() {
        this.zoom = 1.0;
    }

    public void zoomIn() {
        this.zoom += this.zoomPercentage;
    }

    public void zoomOut() {
        this.zoom -= this.zoomPercentage;
        if (this.zoom < this.zoomPercentage) {
            if (this.zoomPercentage > 1.0) {
                this.zoom = 1.0;
            } else {
                this.zoomIn();
            }
        }
    }

    public double getZoomedTo() {
        return this.zoom * 100.0;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }
}

