/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.esl.gui.editor.FloatEditor;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.editor.model.FontPreviewConfiguration;
import at.mrdevelopment.esl.template.editor.model.FontPreviewContainer;
import at.mrdevelopment.esl.template.editor.model.FontPreviewTableModel;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;

public class FontsView {
    static ESLLogger logger = ESLLogger.getLogger(FontsView.class);
    private static final int FONT_SIZE_COUNT = 20;
    private static final int FONT_SIZE_INTERVAL = 2;
    private static final int DEFAULT_ROW_HEIGHT = 16;
    private final JFrame frame = new ESLFrame();
    private final JCheckBox italicBox;
    private final JCheckBox boldBox;
    private final JTextField textField;
    private final JComboBox fontSizeBox;
    private FloatEditor condenseEditor;
    private final JTable table;
    private final FontPreviewTableModel tableModel;
    private final FontPreviewContainer fontPreviewContainer;

    public FontsView(Component parent) throws InitializationException {
        this.frame.setTitle("Font Preview");
        this.frame.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        String[] fontSizes = new String[20];
        for (int i = 2; i <= 40; i += 2) {
            fontSizes[i / 2 - 1] = String.valueOf(i);
        }
        this.fontPreviewContainer = new FontPreviewContainer(this);
        this.tableModel = new FontPreviewTableModel(this.fontPreviewContainer);
        this.table = new JTable(this.tableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.setTransferHandler(new FontTransferHandler());
        this.table.setDefaultRenderer(BufferedImage.class, new ImageRenderer());
        this.fontSizeBox = new JComboBox<String>(fontSizes);
        this.fontSizeBox.setSelectedIndex(5);
        this.fontSizeBox.setPrototypeDisplayValue(999);
        this.fontSizeBox.setEditable(true);
        JPanel firstRowPanel = new JPanel(new FlowLayout(0));
        firstRowPanel.add(new JLabel("Font size:"));
        firstRowPanel.add(this.fontSizeBox);
        this.condenseEditor = new FloatEditor(0.01f, Float.MAX_VALUE);
        ((JTextField)this.condenseEditor.getEditorComponent()).setColumns(4);
        this.condenseEditor.setValue((Object)Float.valueOf(1.0f));
        firstRowPanel.add(new JLabel("Condense Factor:"));
        firstRowPanel.add(this.condenseEditor.getEditorComponent());
        this.italicBox = new JCheckBox("italic");
        firstRowPanel.add(this.italicBox);
        this.boldBox = new JCheckBox("bold");
        firstRowPanel.add(this.boldBox);
        topPanel.add((Component)firstRowPanel, "North");
        upperPanel.add((Component)topPanel, "North");
        JPanel textPanel = new JPanel(new FlowLayout(0));
        this.textField = new JTextField(30);
        this.textField.setText("Text");
        textPanel.add(new JLabel("Text:"));
        textPanel.add(this.textField);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontsView.this.onUpdateButton();
            }
        });
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add(updateButton);
        upperPanel.add((Component)textPanel, "South");
        this.frame.add((Component)upperPanel, "North");
        this.frame.add((Component)new JScrollPane(this.table), "Center");
        this.frame.add((Component)bottomPanel, "South");
        this.frame.setPreferredSize(new Dimension(600, 800));
        this.registerEscapeKeyAction();
        this.frame.pack();
        this.frame.setLocationRelativeTo(parent);
        this.frame.setVisible(false);
    }

    private void registerEscapeKeyAction() {
        this.frame.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontsView.this.frame.setVisible(false);
                FontsView.this.frame.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public FontRenderContext getFontRenderContext() {
        return this.frame.getGraphics().getFontMetrics().getFontRenderContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateButton() {
        try {
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            ExecutionStatus status = new ExecutionStatus();
            this.render(status);
            if (status.getElements().size() > 0) {
                StringBuilder builder = new StringBuilder();
                for (ExecutionStatusElement<?> element : status.getElements()) {
                    if (element instanceof ExceptionElement) {
                        builder.append(((ExceptionElement)element).getElement().getMessage());
                        builder.append("\n");
                        continue;
                    }
                    builder.append(element.getElement().toString());
                }
                JOptionPane.showMessageDialog(this.frame, builder.toString(), "Error(s) during rendering", 0);
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.frame, exc.getMessage(), String.format("Error: %s", exc.getClass().getSimpleName()), 0);
        }
        finally {
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void render(ExecutionStatus status) throws ImageRenderingException, NumberFormatException, SerializeException, InitializationException {
        this.condenseEditor.validate();
        if (!this.condenseEditor.hasErrors()) {
            FontPreviewConfiguration fontPreviewConfiguration = this.generateConfiguration();
            this.fontPreviewContainer.render(fontPreviewConfiguration, status);
            this.tableModel.fireTableDataChanged();
        }
    }

    private FontPreviewConfiguration generateConfiguration() throws NumberFormatException, InitializationException {
        return new FontPreviewConfiguration(Integer.valueOf(this.fontSizeBox.getSelectedItem().toString()), this.condenseEditor.getValue().floatValue(), this.italicBox.isSelected(), this.boldBox.isSelected(), this.textField.getText());
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public String createClipboardString(String fontName, FontPreviewConfiguration configuration) {
        StringBuilder builder = new StringBuilder();
        return builder.append("<text font-family=\"").append(fontName).append("\" font-size=\"").append(configuration.getFontSize()).append("\" font-weight=\"").append(configuration.isBold() ? "bold" : "normal").append("\" font-style=\"").append(configuration.isItalic() ? "italic" : "normal").append("\" condense=\"").append(configuration.getCondenseFactor()).append("\"></text>").toString();
    }

    private class FontTransferHandler
    extends TransferHandler {
        private FontTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent aComponent, Clipboard aClipboard, int aAction) throws IllegalStateException {
            if (FontsView.this.table.getSelectedRowCount() > 0) {
                String fontName = FontsView.this.tableModel.getFontName(FontsView.this.table.convertRowIndexToModel(FontsView.this.table.getSelectedRow()));
                try {
                    FontPreviewConfiguration configuration = FontsView.this.generateConfiguration();
                    StringSelection stringSelection = new StringSelection(FontsView.this.createClipboardString(fontName, configuration));
                    aClipboard.setContents(stringSelection, stringSelection);
                }
                catch (NumberFormatException exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                }
                catch (InitializationException exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
        }
    }

    class ImageRenderer
    extends DefaultTableCellRenderer {
        ImageRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel();
            label.setBorder(null);
            if (value != null) {
                BufferedImage image = (BufferedImage)value;
                if (table.getRowHeight(row) != image.getHeight()) {
                    if (image.getHeight() > 16) {
                        table.setRowHeight(row, image.getHeight());
                    } else if (table.getRowHeight(row) != 16) {
                        table.setRowHeight(row, 16);
                    }
                }
                label.setIcon(new ImageIcon(image));
            }
            return label;
        }
    }
}

