/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.gui.editor.IntegerEditor;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditRotationDialog {
    private JFrame parent;
    private JDialog dialog;
    private IntegerEditor editor;
    private final int fieldId;
    private final Path path;
    private final DisplayableOption option;
    private int result = -1;
    private JSlider slider;
    private boolean changeInProgress = false;

    public EditRotationDialog(JFrame parent, int fieldId, Path path, DisplayableOption option) {
        this.parent = parent;
        this.fieldId = fieldId;
        this.path = path;
        this.option = option;
    }

    protected void onOkButton() {
        this.result = 0;
        this.close();
    }

    protected void onCancelButton() {
        this.result = 1;
        this.close();
    }

    private void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public int show() {
        this.result = -1;
        this.dialog = new JDialog(this.parent, "Edit rotation", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setResizable(false);
        JPanel topPanel = new JPanel(new FlowLayout(3));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        bottomPanel.add((Component)buttonPanel, "South");
        this.editor = new IntegerEditor(0, 359);
        this.editor.setCanBeNull(false);
        this.editor.setValue((Object)Integer.valueOf(this.option.getValue()));
        ((JTextField)this.editor.getEditorComponent()).setColumns(10);
        ((JTextField)this.editor.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditRotationDialog.this.editorUpdated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditRotationDialog.this.editorUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditRotationDialog.this.editorUpdated();
            }
        });
        topPanel.add(new JLabel("Rotation Value:"));
        topPanel.add((Component)this.editor.getEditorComponent(), "Center");
        JPanel sliderPanel = new JPanel(new BorderLayout());
        this.slider = new JSlider(0, 0, 359, 0);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!EditRotationDialog.this.changeInProgress) {
                    EditRotationDialog.this.changeInProgress = true;
                    EditRotationDialog.this.editor.setValue((Object)EditRotationDialog.this.slider.getValue());
                    EditRotationDialog.this.changeInProgress = false;
                }
            }
        });
        this.slider.setMajorTickSpacing(90);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        sliderPanel.add((Component)this.slider, "Center");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRotationDialog.this.onCancelButton();
            }
        });
        buttonPanel.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRotationDialog.this.onOkButton();
            }
        });
        buttonPanel.add(okButton);
        this.dialog.add((Component)topPanel, "North");
        this.dialog.add((Component)sliderPanel, "Center");
        this.dialog.add((Component)bottomPanel, "South");
        this.dialog.getRootPane().setDefaultButton(okButton);
        this.registerEscapeKeyAction();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setVisible(true);
        return this.result;
    }

    protected void editorUpdated() {
        if (!this.changeInProgress) {
            this.changeInProgress = true;
            this.slider.setValue(this.editor.getValue());
            this.changeInProgress = false;
        }
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRotationDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public String getOptionText() {
        return String.valueOf(this.editor.getValue());
    }

    public boolean isCancelled() {
        return this.result != 0;
    }

    public OptionChangeEvent getResult() {
        if (!this.isCancelled()) {
            return new OptionChangeEvent(this.path, this.fieldId, this.getOptionText());
        }
        return null;
    }
}

