/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLTreeEntry;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;

public class EditOptionDialog {
    private static final String XSL_VALUE_OF_TEXT = "<xsl:value-of select=\"%s\" />";
    private JFrame parent;
    private JDialog dialog;
    private JTextArea textArea;
    private final int fieldId;
    private final Path path;
    private final DisplayableOption option;
    private int result = -1;
    private final AbstractTemplateModel templateModel;
    private JTree tree;

    public EditOptionDialog(JFrame parent, int fieldId, Path path, DisplayableOption option, AbstractTemplateModel templateModel) {
        this.parent = parent;
        this.fieldId = fieldId;
        this.path = path;
        this.option = option;
        this.templateModel = templateModel;
    }

    protected void onOkButton() {
        this.result = 0;
        this.close();
    }

    protected void onCancelButton() {
        this.result = 1;
        this.close();
    }

    private void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public int show() {
        this.result = -1;
        this.dialog = new JDialog(this.parent, "Edit property", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setResizable(false);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder("Text:"));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        bottomPanel.add((Component)buttonPanel, "South");
        this.textArea = new JTextArea(10, 60);
        this.textArea.setText(this.option.getValue());
        topPanel.add((Component)new JScrollPane(this.textArea), "Center");
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.setBorder(BorderFactory.createTitledBorder("References:"));
        this.tree = new JTree();
        this.tree.setModel(new DefaultTreeModel(this.templateModel.getXMLRecord().getRootTreeNode()));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int row = EditOptionDialog.this.tree.getRowForLocation(e.getX(), e.getY());
                    EditOptionDialog.this.onAddCurrentTreeNode(row);
                }
            }
        });
        JPanel treeButtonPanel = new JPanel(new FlowLayout());
        JButton insertReferenceButton = new JButton("Insert reference");
        insertReferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditOptionDialog.this.onInsertReferenceButton();
            }
        });
        treeButtonPanel.add(insertReferenceButton);
        treePanel.add((Component)treeButtonPanel, "South");
        treePanel.add((Component)new JScrollPane(this.tree), "Center");
        bottomPanel.add((Component)treePanel, "Center");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditOptionDialog.this.onCancelButton();
            }
        });
        buttonPanel.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditOptionDialog.this.onOkButton();
            }
        });
        buttonPanel.add(okButton);
        this.dialog.add((Component)topPanel, "North");
        this.dialog.add((Component)bottomPanel, "South");
        this.dialog.getRootPane().setDefaultButton(okButton);
        this.registerEscapeKeyAction();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setVisible(true);
        return this.result;
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditOptionDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void onInsertReferenceButton() {
        int[] selectedRows = this.tree.getSelectionRows();
        if (selectedRows.length > 0) {
            this.onAddCurrentTreeNode(selectedRows[0]);
        }
    }

    protected void onAddCurrentTreeNode(int row) {
        if (row >= 0) {
            this.tree.setSelectionRow(row);
            XMLTreeEntry selectedEntry = (XMLTreeEntry)this.tree.getLastSelectedPathComponent();
            if (selectedEntry.isLeaf()) {
                int caretPosition = this.textArea.getCaretPosition();
                this.textArea.insert(String.format(XSL_VALUE_OF_TEXT, selectedEntry.getPath()), caretPosition >= 0 ? caretPosition : 0);
            }
        }
    }

    public String getOptionText() {
        return this.textArea.getText();
    }

    public boolean isCancelled() {
        return this.result != 0;
    }

    public OptionChangeEvent getResult() {
        if (!this.isCancelled()) {
            return new OptionChangeEvent(this.path, this.fieldId, this.getOptionText());
        }
        return null;
    }
}

