/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.common.CoordinatesMouseListener;
import at.mrdevelopment.esl.template.editor.controller.undoredo.UndoRedoKeyListener;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.view.DesignTemplateView;
import at.mrdevelopment.esl.template.editor.view.Zoomable;
import at.mrdevelopment.esl.template.editor.view.components.TemplateCanvas;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.OptionsTableCellEditorFactory;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.options.OptionsView;
import at.mrdevelopment.toolkit.tree.TreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class DesignView
extends AbstractView
implements View,
Observer,
Zoomable {
    private static final String TITLE_ACTIVATED = "Design";
    private static final String TITLE_DEACTIVATED = "Design (deactivated)";
    private TemplateCanvas canvas;
    private OptionsView optionsPanel;
    private JSplitPane splitPane;
    private JTabbedPane propertiesPane = new JTabbedPane();
    private JPanel panel = new JPanel(new BorderLayout());
    private String title = "Design";

    public DesignView(JToolBar toolBar, UndoRedoKeyListener keyListener, EventDispatcher eventDispatcher, JFrame parentFrame, DesignTemplateView templateView, DesignTemplateModel templateModel) throws InitializationException {
        this.canvas = new TemplateCanvas(keyListener, eventDispatcher, parentFrame);
        this.canvas.getPanel().addMouseMotionListener(new CoordinatesMouseListener(templateView, this));
        this.panel.add((Component)toolBar, "First");
        this.optionsPanel = new OptionsView("Properties", new OptionsTableCellEditorFactory(templateView, this.canvas.getViewState(), templateModel), eventDispatcher, this.canvas.getViewState());
        this.propertiesPane.addTab(this.optionsPanel.getTitle(), this.optionsPanel.getPanel());
        JScrollPane scrollPane = new JScrollPane(this.canvas.getComponent());
        scrollPane.setMinimumSize(new Dimension(300, scrollPane.getHeight()));
        this.propertiesPane.setMinimumSize(new Dimension(100, this.propertiesPane.getHeight()));
        this.splitPane = new JSplitPane(1, scrollPane, this.propertiesPane);
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setDividerLocation(300);
        this.panel.add((Component)this.splitPane, "Center");
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public TemplateCanvas getCanvas() {
        return this.canvas;
    }

    public OptionsView getOptionsPanel() {
        return this.optionsPanel;
    }

    public void update(TreeNode<DisplayableOption, String> fieldOptions, int fieldId) {
        this.optionsPanel.update(fieldOptions);
        this.propertiesPane.setTitleAt(0, this.optionsPanel.getTitle());
    }

    public void activate() {
        this.splitPane.setEnabled(true);
        this.propertiesPane.setEnabled(true);
        this.title = TITLE_ACTIVATED;
    }

    public void deactivate() {
        this.splitPane.setEnabled(false);
        this.propertiesPane.setEnabled(false);
        this.title = TITLE_DEACTIVATED;
    }

    @Override
    public int getXCoordinate(int mouseXCoordinate) {
        return Math.round((mouseXCoordinate - this.canvas.getViewState().getViewX()) / this.canvas.getViewState().getScale());
    }

    @Override
    public int getYCoordinate(int mouseYCoordinate) {
        return Math.round((mouseYCoordinate - this.canvas.getViewState().getViewY()) / this.canvas.getViewState().getScale());
    }
}

