/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.controller.DesignTemplateController;
import at.mrdevelopment.esl.template.editor.controller.event.DragAndDropEvent;
import at.mrdevelopment.esl.template.editor.controller.event.EnableDesignViewEvent;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AbstractDesignUndoable;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.view.DefaultTemplateView;
import at.mrdevelopment.esl.template.editor.view.DesignView;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.event.CanvasFocusEvent;
import at.mrdevelopment.toolkit.gui.event.ElementDoubleClickEvent;
import at.mrdevelopment.toolkit.gui.event.ElementFocusChangedEvent;
import at.mrdevelopment.toolkit.gui.event.Event;
import at.mrdevelopment.toolkit.gui.event.FinishedInsertingElementEvent;
import at.mrdevelopment.toolkit.gui.event.FinishedResizingEvent;
import at.mrdevelopment.toolkit.gui.event.FocusElementEvent;
import at.mrdevelopment.toolkit.gui.event.MoveElementEvent;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.gui.event.ScaleEvent;
import at.mrdevelopment.toolkit.gui.event.ShowEditOptionDialogEvent;
import at.mrdevelopment.toolkit.gui.event.StartingToResizeEvent;
import at.mrdevelopment.toolkit.gui.event.TranslateViewportEvent;
import at.mrdevelopment.toolkit.gui.options.OptionsTable;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class DesignTemplateView
extends DefaultTemplateView {
    private static final int DEFAULT_ICON_SIZE = 16;
    private Menu insertMenu;
    private DesignView designView;
    private AbstractDesignUndoable currentInsertUndoable = null;
    private List<DesignButton> buttons = new ArrayList<DesignButton>();
    private boolean ignoreChanges = false;

    public DesignTemplateView(DesignTemplateController templateController, DesignTemplateModel templateModel) throws InitializationException {
        super(templateController, templateModel);
        this.buttons.add(new DesignButton("Barcode", "Barcode", new AddBarcodeActionListener()));
        this.buttons.add(new DesignButton("Image", "Image", new AddImageActionListener()));
        this.buttons.add(new DesignButton("Text", "Text", new AddTextFieldActionListener()));
        this.buttons.add(new DesignButton("Line", "Line", new AddLineActionListener()));
        this.buttons.add(new DesignButton("Rectangle", "Rectangle", new AddRectActionListener()));
        this.buttons.add(new DesignButton("Ellipse", "Ellipse", new AddEllipseActionListener()));
        this.insertMenu = new Menu("Insert");
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        DesignButtonGroup group = new DesignButtonGroup();
        for (DesignButton button : this.buttons) {
            this.insertMenu.add(button.getMenuItem());
            toolBar.add(button.getButton());
            group.add(button.getButton());
        }
        this.designView = new DesignView(toolBar, this.undoRedoKeyListener, this, this.templateViewJFrame, this, templateModel);
        this.mainViewArea.addView(this.designView);
        this.editMenu.add(this.insertMenu);
        if (templateModel.isDesignViewEnabled()) {
            this.xslView.setEditable(false);
        } else {
            this.disableDesignView();
            this.insertMenu.setEnabled(false);
            this.mainViewArea.removeView(this.designView);
            this.mainViewArea.getComponent().repaint();
        }
    }

    public BufferedImage resize(ImageIcon originalImage, int requestedWidth, int requestedHeight) {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        int width = originalImage.getIconWidth();
        int height = originalImage.getIconHeight();
        BufferedImage resizedImage = new BufferedImage(requestedWidth, requestedHeight, 2);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.drawImage(originalImage.getImage(), 0, 0, requestedWidth, requestedHeight, 0, 0, width, height, null);
        graphics.dispose();
        return resizedImage;
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.updateCanvas();
        if (((DesignTemplateModel)this.templateModel).getTemplate() != null) {
            this.updateButtons(((DesignTemplateModel)this.templateModel).getFieldType(this.designView.getCanvas().getViewState().getElementFocused()));
        }
        this.updateProperties(this.designView.getCanvas().getViewState().getElementFocused());
    }

    private void updateCanvas() {
        this.designView.getCanvas().refreshCanvas((DesignTemplateModel)this.templateModel);
        this.designView.getComponent().repaint();
    }

    private void updateProperties(int fieldId) {
        if (!this.ignoreChanges && ((DesignTemplateModel)this.templateModel).getTemplate() != null) {
            this.designView.getOptionsPanel().clearElements();
            if (fieldId < 0 || ((DesignTemplateModel)this.templateModel).getTemplate().getFieldIds().size() == 0) {
                this.designView.update(((DesignTemplateModel)this.templateModel).getTemplate().getTemplateOptions(), fieldId);
            } else {
                this.designView.update(((DesignTemplateModel)this.templateModel).getTemplate().getFieldOptions(fieldId), fieldId);
            }
        }
        this.ignoreChanges = false;
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof StartingToResizeEvent) {
            if (((StartingToResizeEvent)event).getFieldId() >= 0) {
                ((DesignTemplateController)this.templateController).startingToResizeElement(((StartingToResizeEvent)event).getFieldId());
            }
            this.designView.getCanvas().getViewState().setUserEditing(true);
        } else if (event instanceof FinishedResizingEvent) {
            ((DesignTemplateController)this.templateController).finishedResizingElement();
            this.designView.getCanvas().getViewState().setUserEditing(false);
            this.updateContent();
        } else if (event instanceof ScaleEvent) {
            this.designView.getCanvas().getViewState().setScale(this.designView.getCanvas().getViewState().getScale() + ((ScaleEvent)event).getRelativeScale());
            this.updateContent();
        } else if (event instanceof TranslateViewportEvent) {
            this.designView.getCanvas().getViewState().setViewX(this.designView.getCanvas().getViewState().getViewX() + ((TranslateViewportEvent)event).getRelativeX());
            this.designView.getCanvas().getViewState().setViewY(this.designView.getCanvas().getViewState().getViewY() + ((TranslateViewportEvent)event).getRelativeY());
            this.updateContent();
        } else if (event instanceof ElementFocusChangedEvent) {
            this.updateCanvas();
            this.updateProperties(this.designView.getCanvas().getViewState().getElementFocused());
            this.updateButtons(((DesignTemplateModel)this.templateModel).getFieldType(this.designView.getCanvas().getViewState().getElementFocused()));
        } else if (event instanceof FocusElementEvent) {
            FocusElementEvent focusEvent = (FocusElementEvent)event;
            this.designView.getCanvas().getViewState().setElementFocused(focusEvent.getFieldId());
            this.dispatchEvent(new ElementFocusChangedEvent());
            if (focusEvent.isActivateView()) {
                this.mainViewArea.viewActivated(this.designView);
            }
        } else if (event instanceof EnableDesignViewEvent) {
            EnableDesignViewEvent enableDesignViewEvent = (EnableDesignViewEvent)event;
            if (enableDesignViewEvent.isEnabled() && !((DesignTemplateModel)this.templateModel).isDesignViewEnabled()) {
                this.mainViewArea.addView(this.designView);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                this.enableDesignView();
                this.xslView.setEditable(false);
                this.mainViewArea.getComponent().repaint();
                if (this.templateModel.hasXSLFileName()) {
                    this.templateModel.refresh();
                }
            } else if (!enableDesignViewEvent.isEnabled() && ((DesignTemplateModel)this.templateModel).isDesignViewEnabled()) {
                this.disableDesignView();
                if (this.mainViewArea.getActivatedComponent().equals(this.designView)) {
                    this.mainViewArea.viewActivated(this.xslView);
                }
                this.xslView.setEditable(true);
                this.mainViewArea.removeView(this.designView);
                this.mainViewArea.getComponent().repaint();
                this.templateModel.refresh();
            }
        } else if (event instanceof FinishedInsertingElementEvent) {
            if (this.currentInsertUndoable != null) {
                FinishedInsertingElementEvent insertEvent = (FinishedInsertingElementEvent)event;
                this.currentInsertUndoable.setFieldBounds(insertEvent.getShape());
                this.currentInsertUndoable.perform();
                ((DesignTemplateController)this.templateController).finishedInsertingElement(this.currentInsertUndoable);
                this.designView.getCanvas().getViewState().setElementFocused(this.currentInsertUndoable.getFieldId());
                this.designView.getCanvas().getViewState().setUserEditing(false);
                this.deselectToggleButtons();
                this.dispatchEvent(new ElementFocusChangedEvent());
            }
        } else if (!(event instanceof ShowEditOptionDialogEvent)) {
            if (event instanceof OptionChangeEvent) {
                OptionChangeEvent optionChangeEvent = (OptionChangeEvent)event;
                this.ignoreChanges = true;
                if (optionChangeEvent.isRootTag()) {
                    ((DesignTemplateController)this.templateController).rootOptionChanged(optionChangeEvent.getOptionPath(), optionChangeEvent.getValue());
                } else {
                    ((DesignTemplateController)this.templateController).optionChanged(optionChangeEvent.getFieldId(), optionChangeEvent.getOptionPath(), optionChangeEvent.getValue());
                }
            } else if (event instanceof CanvasFocusEvent) {
                this.designView.getOptionsPanel().cancelEdit();
            } else if (event instanceof ElementDoubleClickEvent) {
                ((DesignTemplateController)this.templateController).handleDoubleClickOnField(this.designView.getCanvas().getViewState().getElementFocused());
            } else if (event instanceof DragAndDropEvent) {
                DragAndDropEvent dragAndDropEvent = (DragAndDropEvent)event;
                ((DesignTemplateController)this.templateController).handleDragAndDrop(dragAndDropEvent.getFiles());
            } else if (event instanceof MoveElementEvent) {
                MoveElementEvent moveEvent = (MoveElementEvent)event;
                ((DesignTemplateController)this.templateController).moveField(moveEvent.getFieldId(), moveEvent.getDirection());
            }
        }
        super.onEvent(event);
    }

    private void updateButtons(FieldType fieldType) {
    }

    @Override
    public void update(Observable paramObservable, Object paramObject) {
        if (paramObject != null && paramObject.toString().equals("Disable Design")) {
            this.dispatchEvent(new EnableDesignViewEvent(false));
        } else if (paramObject != null && paramObject.toString().equals("Refresh Design")) {
            this.updateProperties(this.designView.getCanvas().getViewState().getElementFocused());
            this.updateCanvas();
        }
        this.updateButtons();
        super.update(paramObservable, paramObject);
    }

    private void updateButtons() {
        for (DesignButton button : this.buttons) {
            button.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        }
    }

    private void enableDesignView() {
        if (!((DesignTemplateModel)this.templateModel).isDesignViewEnabled()) {
            this.designView.activate();
            this.mainViewArea.viewUpdated(this.designView);
            this.insertMenu.setEnabled(true);
            ((DesignTemplateModel)this.templateModel).setDesignViewEnabled(true);
        }
    }

    private void disableDesignView() {
        if (((DesignTemplateModel)this.templateModel).isDesignViewEnabled()) {
            if (this.mainViewArea.getActivatedComponent().equals(this.designView.getComponent())) {
                this.mainViewArea.viewActivated(this.xslView);
            }
            this.insertMenu.setEnabled(false);
            this.designView.deactivate();
            this.mainViewArea.viewUpdated(this.designView);
            ((DesignTemplateModel)this.templateModel).setDesignViewEnabled(false);
        }
    }

    private void deselectToggleButtons() {
        for (DesignButton button : this.buttons) {
            button.getButton().setSelected(false);
        }
    }

    public OptionsTable getOptionsTable() {
        return (OptionsTable)this.designView.getOptionsPanel().getTable();
    }

    private class DesignButton {
        private final JToggleButton button;
        private final MenuItem menuItem;

        public DesignButton(String iconName, String title, ActionListener action) {
            this.button = new JToggleButton(title, new ImageIcon(DesignTemplateView.this.resize(IconUtils.loadImageIcon(iconName), 16, 16)));
            this.button.addItemListener(new ToggleButtonItemListener(action));
            this.button.setFocusable(false);
            this.button.setEnabled(false);
            this.menuItem = new MenuItem(title);
            this.menuItem.addActionListener(new DesignButtonMenuItemActionListener(this.button));
            this.menuItem.setEnabled(false);
        }

        public JToggleButton getButton() {
            return this.button;
        }

        public MenuItem getMenuItem() {
            return this.menuItem;
        }

        public void setEnabled(boolean enabled) {
            this.button.setEnabled(enabled);
            this.menuItem.setEnabled(enabled);
        }
    }

    private class AddTextFieldActionListener
    implements ActionListener {
        private AddTextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DesignTemplateView.this.currentInsertUndoable = ((DesignTemplateController)DesignTemplateView.this.templateController).createTextFieldUndoable();
            DesignTemplateView.this.designView.getCanvas().activateRectangleInsertMode();
        }
    }

    private class AddImageActionListener
    implements ActionListener {
        private AddImageActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DesignTemplateView.this.currentInsertUndoable = ((DesignTemplateController)DesignTemplateView.this.templateController).createImageFieldUndoable();
            DesignTemplateView.this.designView.getCanvas().activateRectangleInsertMode();
        }
    }

    private class AddBarcodeActionListener
    implements ActionListener {
        private AddBarcodeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DesignTemplateView.this.currentInsertUndoable = ((DesignTemplateController)DesignTemplateView.this.templateController).createBarcodeUndoable();
            DesignTemplateView.this.designView.getCanvas().activateRectangleInsertMode();
        }
    }

    private class AddEllipseActionListener
    implements ActionListener {
        private AddEllipseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignTemplateView.this.currentInsertUndoable = ((DesignTemplateController)DesignTemplateView.this.templateController).createEllipseUndoable();
            DesignTemplateView.this.designView.getCanvas().activateRectangleInsertMode();
        }
    }

    private class AddRectActionListener
    implements ActionListener {
        private AddRectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignTemplateView.this.currentInsertUndoable = ((DesignTemplateController)DesignTemplateView.this.templateController).createRectUndoable();
            DesignTemplateView.this.designView.getCanvas().activateRectangleInsertMode();
        }
    }

    private class AddLineActionListener
    implements ActionListener {
        private AddLineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignTemplateView.this.currentInsertUndoable = ((DesignTemplateController)DesignTemplateView.this.templateController).createLineUndoable();
            DesignTemplateView.this.designView.getCanvas().activateTwoPointInsertMode();
        }
    }

    private class DesignButtonMenuItemActionListener
    implements ActionListener {
        private final JToggleButton button;

        public DesignButtonMenuItemActionListener(JToggleButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.button.setSelected(!this.button.isSelected());
        }
    }

    private class ToggleButtonItemListener
    implements ItemListener {
        private ActionListener actionListener;

        public ToggleButtonItemListener(ActionListener actionListener) {
            this.actionListener = actionListener;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.actionListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
            } else {
                DesignTemplateView.this.designView.getCanvas().cancelInsertMode();
            }
        }
    }

    private class DesignButtonGroup
    extends ButtonGroup {
        private DesignButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
        }
    }
}

