/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.gui.AboutDialog;
import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.esl.template.editor.TemplateEditor;
import at.mrdevelopment.esl.template.editor.common.RecordRenderingExceptionElement;
import at.mrdevelopment.esl.template.editor.common.RecordRenderingProblem;
import at.mrdevelopment.esl.template.editor.controller.DesignTemplateController;
import at.mrdevelopment.esl.template.editor.controller.TemplateController;
import at.mrdevelopment.esl.template.editor.controller.TemplateCreationController;
import at.mrdevelopment.esl.template.editor.controller.event.UndoRedoEvent;
import at.mrdevelopment.esl.template.editor.controller.undoredo.UndoRedoKeyListener;
import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.view.ChooseServerDialog;
import at.mrdevelopment.esl.template.editor.view.ConfigurationView;
import at.mrdevelopment.esl.template.editor.view.FontsView;
import at.mrdevelopment.esl.template.editor.view.LabelSettingsView;
import at.mrdevelopment.esl.template.editor.view.PreviewView;
import at.mrdevelopment.esl.template.editor.view.SearchAndReplaceDialog;
import at.mrdevelopment.esl.template.editor.view.SourceEditorView;
import at.mrdevelopment.esl.template.editor.view.TemplateView;
import at.mrdevelopment.esl.template.editor.view.TextModificationListener;
import at.mrdevelopment.esl.template.editor.view.XMLRecordsView;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RenderingExceptionElement;
import at.mrdevelopment.toolkit.RenderingStringElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.TableRenderingExceptionElement;
import at.mrdevelopment.toolkit.TableRenderingExecutionStatusElement;
import at.mrdevelopment.toolkit.TableRenderingStringElement;
import at.mrdevelopment.toolkit.XMLValidationElement;
import at.mrdevelopment.toolkit.gui.CheckMark;
import at.mrdevelopment.toolkit.gui.CrossMark;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.ProblemsView;
import at.mrdevelopment.toolkit.gui.SplitButton;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.gui.ViewArea;
import at.mrdevelopment.toolkit.gui.ViewUpdateListener;
import at.mrdevelopment.toolkit.gui.event.Event;
import at.mrdevelopment.toolkit.gui.event.FocusElementEvent;
import at.mrdevelopment.toolkit.gui.event.FocusTableElementEvent;
import at.mrdevelopment.toolkit.gui.event.RefreshViewEvent;
import at.mrdevelopment.toolkit.gui.event.RemoveCanvasElementEvent;
import at.mrdevelopment.toolkit.gui.event.ResizeElementEvent;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.problem.MessageProblem;
import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.problem.ProblemSeverity;
import at.mrdevelopment.toolkit.problem.RenderingProblem;
import at.mrdevelopment.toolkit.problem.RenderingTableProblem;
import at.mrdevelopment.toolkit.problem.XMLProblem;
import at.mrdevelopment.toolkit.text.gui.SymbolDialog;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.prefs.BackingStoreException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import org.apache.commons.io.FilenameUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class DefaultTemplateView
extends TemplateView
implements ViewUpdateListener,
MouseListener,
TextModificationListener {
    public static final String EDIT = "Edit";
    public static final String NEW_TEMPLATE = "New Template";
    public static final String OPEN_RECORD = "Open Record XML";
    public static final String OPEN_RECORD_DIRECTORY = "Open Record XML Directory";
    public static final String LOAD_SERVER_RECORDS = "Load Records from Server";
    public static final String OPEN_TEMPLATE = "Open Template";
    public static final String SAVE_TEMPLATE = "Save Template";
    public static final String SAVE_RECORD = "Save Record";
    public static final String NEW_RECORD = "New Record";
    public static final String EXPORT_RECORDS = "Export images for all records";
    public static final String PRINT = "Print";
    public static final String PRINT_IMAGE = "Print Image";
    public static final String QUIT = "Quit";
    public static final String REDO = "Redo";
    public static final String UNDO = "Undo";
    public static final String FILE = "File";
    public static final String INSERT_SYMBOL = "Insert symbol";
    public static final String INSERT = "Insert";
    public static final String BARCODE = "Barcode";
    public static final String TEXTFIELD = "Text";
    public static final String LIST = "List";
    public static final String IMAGE = "Image";
    public static final String SETTINGS = "Settings";
    public static final String LINE = "Line";
    public static final String RECT = "Rectangle";
    public static final String LABEL_SETTINGS = "Label Settings";
    private static final String CONFIGURATION = "Configuration";
    public static final String DEFAULT_TEMPLATE_PATH = System.getProperty("user.home");
    private static final String RECENT_TEMPLATES = "Recent Templates";
    private static final String RECENT_RECORDS = "Recent Records";
    private static final String HELP = "Help";
    private static final String AUTOMATIC_RENDERING = "Render Automatically";
    private static final String RENDER = "Render Template               F5";
    private static final String ABOUT = "About";
    private static final String HELP_CONTENT = "Help Content";
    private static final String LIST_FONTS = "Fonts..";
    private static final String SEARCH = "Search/Replace";
    private static final Icon CROSSMARK = new CrossMark(Color.RED, 2);
    private static final Icon CHECKMARK = new CheckMark(Color.GREEN);
    private static final String DEFAULT_NEW_TEMPLATE_FILENAME = "template";
    public static final String ELLIPSE = "Ellipse";
    protected JFrame templateViewJFrame = new ESLFrame(ESLFrame.ESL_ICONS_WHITE);
    protected JSplitPane verticalSplitPane;
    protected JSplitPane horizontalSplitPane;
    private ProblemsView problemsView;
    protected ViewArea viewArea;
    private JLabel coordinatesLabel;
    protected MenuBar menuBar;
    protected JToolBar toolBar;
    private Menu fileMenu;
    protected Menu editMenu;
    protected Menu settingsMenu;
    protected Menu helpMenu;
    private Menu recentTemplatesMenu;
    private Menu recentRecordsMenu;
    private MenuItem aboutMenuItem;
    private MenuItem helpContentMenuItem;
    private MenuItem listFontsMenuItem;
    private MenuItem quitMenuItem;
    private MenuItem undoMenuItem;
    private MenuItem redoMenuItem;
    private MenuItem exportRecordsMenuItem;
    private MenuItem saveTemplateMenuItem;
    private MenuItem saveAllMenuItem;
    private MenuItem newTemplateMenuItem;
    private MenuItem newRecordMenuItem;
    private MenuItem saveRecordMenuItem;
    private MenuItem loadTemplateMenuItem;
    private MenuItem loadRecordMenuItem;
    private MenuItem loadRecordDirectoryMenuItem;
    private MenuItem loadServerRecordsMenuItem;
    private MenuItem labelSettingsMenuItem;
    private MenuItem printMenuItem;
    private MenuItem printImageMenuItem;
    protected MenuItem configurationMenuItem;
    private MenuItem renderMenuItem;
    private MenuItem findReplaceMenuItem;
    private CheckboxMenuItem automaticRenderingMenuItem;
    private JFileChooser newTemplateDialog;
    private JFileChooser newRecordDialog;
    private JFileChooser openTemplateDialog;
    private JFileChooser saveRecordDialog;
    private JFileChooser saveTemplateDialog;
    private JFileChooser openRecordDialog;
    private JFileChooser openRecordDirectoryDialog;
    private JFileChooser exportRecordsDialog;
    protected ViewArea mainViewArea;
    protected SourceEditorView xslView;
    protected UndoRedoKeyListener undoRedoKeyListener;
    private PreviewView previewView;
    private XMLRecordsView xmlView;
    private JLabel statusLabel;
    private boolean newTemplateCreated = false;
    private int newTemplateCount = 0;
    private JButton renderButton;
    private JButton saveAllButton;
    private JButton saveButton;
    private JMenuItem loadServerRecordsItem;
    private JMenuItem openRecordDirectoryItem;
    private JMenuItem openRecordItem;
    private JMenuItem openTemplateItem;
    private JMenuItem newRecordPopupMenuItem;
    private JToggleButton enableDebugButton;
    private JButton zoomOutButton;
    private JButton zoomInButton;
    private JButton saveImageButton;
    private JButton searchButton;
    private SearchAndReplaceDialog searchAndReplaceDialog;
    private JMenuItem printCurrentDocumentMenuItem;
    private JMenuItem printImagePopupMenuItem;
    private JButton sendImageButton;
    private MenuItem insertSymbolMenuItem;
    private JButton symbolButton;

    public DefaultTemplateView(TemplateController templateController, AbstractTemplateModel templateModel) throws InitializationException {
        super(templateController, templateModel);
        this.templateViewJFrame.setTitle("Template Editor");
        this.templateViewJFrame.setLayout(new BorderLayout());
        this.templateViewJFrame.setDefaultCloseOperation(0);
        this.initHelpers();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new SaveCurrentDocumentKeyEventDispatcher());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new OpenCurrentDocumentTypeKeyEventDispatcher());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new RenderingKeyEventDispatcher());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new HelpContentKeyEventDispatcher());
        this.mainViewArea = new ViewArea(true);
        this.undoRedoKeyListener = new UndoRedoKeyListener(this);
        this.xslView = new SourceEditorView(this, this.undoRedoKeyListener, templateModel, "XSL", null, "Template", true, true, this, null, true, true);
        this.xmlView = new XMLRecordsView(this, templateController, this.undoRedoKeyListener, templateModel, "XML Record");
        this.previewView = new PreviewView(this, this.undoRedoKeyListener, templateModel);
        this.mainViewArea.addView(this.xslView);
        this.mainViewArea.addView(this.xmlView);
        this.mainViewArea.viewActivated(this.xslView);
        this.problemsView = new ProblemsView(this);
        this.viewArea = new ViewArea(true);
        this.viewArea.addView(this.problemsView);
        this.viewArea.viewActivated(this.problemsView);
        this.menuBar = new MenuBar();
        this.toolBar = new JToolBar();
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.fileMenu = new Menu(FILE);
        this.editMenu = new Menu(EDIT);
        this.settingsMenu = new Menu(SETTINGS);
        this.helpMenu = new Menu(HELP);
        this.recentTemplatesMenu = new Menu(RECENT_TEMPLATES);
        this.recentRecordsMenu = new Menu(RECENT_RECORDS);
        this.loadRecentEntries();
        this.labelSettingsMenuItem = new MenuItem(LABEL_SETTINGS);
        this.configurationMenuItem = new MenuItem(CONFIGURATION);
        this.automaticRenderingMenuItem = new CheckboxMenuItem(AUTOMATIC_RENDERING, templateModel.isAutomaticRenderingEnabled());
        this.renderMenuItem = new MenuItem(RENDER);
        this.renderMenuItem.setEnabled(!templateModel.isAutomaticRenderingEnabled() && templateModel.hasXSLFileName());
        this.quitMenuItem = new MenuItem(QUIT);
        this.undoMenuItem = new MenuItem(UNDO, new MenuShortcut(90));
        this.redoMenuItem = new MenuItem(REDO, new MenuShortcut(89));
        this.findReplaceMenuItem = new MenuItem(SEARCH, new MenuShortcut(70));
        this.insertSymbolMenuItem = new MenuItem(INSERT_SYMBOL);
        this.newTemplateMenuItem = new MenuItem(NEW_TEMPLATE, new MenuShortcut(78));
        this.newRecordMenuItem = new MenuItem(NEW_RECORD);
        this.newRecordMenuItem.setEnabled(false);
        this.saveTemplateMenuItem = new MenuItem(SAVE_TEMPLATE);
        this.saveRecordMenuItem = new MenuItem(SAVE_RECORD);
        this.aboutMenuItem = new MenuItem(ABOUT);
        this.helpContentMenuItem = new MenuItem(HELP_CONTENT);
        this.listFontsMenuItem = new MenuItem(LIST_FONTS);
        this.exportRecordsMenuItem = new MenuItem(EXPORT_RECORDS);
        this.printMenuItem = new MenuItem(PRINT, new MenuShortcut(80));
        this.printMenuItem.setEnabled(false);
        this.printImageMenuItem = new MenuItem(PRINT_IMAGE);
        this.printImageMenuItem.setEnabled(false);
        this.saveAllMenuItem = new MenuItem("Save All");
        this.exportRecordsMenuItem.setEnabled(false);
        this.loadTemplateMenuItem = new MenuItem(OPEN_TEMPLATE);
        this.loadRecordMenuItem = new MenuItem(OPEN_RECORD);
        this.loadRecordMenuItem.setEnabled(false);
        this.loadRecordDirectoryMenuItem = new MenuItem(OPEN_RECORD_DIRECTORY);
        this.loadRecordDirectoryMenuItem.setEnabled(false);
        this.loadServerRecordsMenuItem = new MenuItem(LOAD_SERVER_RECORDS);
        this.loadServerRecordsMenuItem.setEnabled(false);
        this.saveAllMenuItem.setEnabled(false);
        this.labelSettingsMenuItem.addActionListener(new LabelSettingsActionListener());
        this.quitMenuItem.addActionListener(new QuitActionListener());
        this.undoMenuItem.addActionListener(new UndoActionListener());
        this.redoMenuItem.addActionListener(new RedoActionListener());
        this.insertSymbolMenuItem.addActionListener(new InsertSymbolActionListener());
        this.newTemplateMenuItem.addActionListener(new NewTemplateActionListener());
        this.saveTemplateMenuItem.addActionListener(new SaveTemplateActionListener());
        this.saveRecordMenuItem.addActionListener(new SaveRecordActionListener());
        this.loadTemplateMenuItem.addActionListener(new LoadTemplateActionListener());
        this.loadRecordMenuItem.addActionListener(new LoadRecordActionListener(this.openRecordDialog));
        this.loadRecordDirectoryMenuItem.addActionListener(new LoadRecordActionListener(this.openRecordDirectoryDialog));
        this.loadServerRecordsMenuItem.addActionListener(new LoadServerRecordsActionListener());
        this.newRecordMenuItem.addActionListener(new NewRecordActionListener());
        this.aboutMenuItem.addActionListener(new AboutActionListener());
        this.helpContentMenuItem.addActionListener(new HelpContentActionListener());
        this.listFontsMenuItem.addActionListener(new ListFontsActionListener());
        this.automaticRenderingMenuItem.addItemListener(new AutomaticRenderingChangedItemListener());
        this.renderMenuItem.addActionListener(new RenderActionListener());
        this.findReplaceMenuItem.addActionListener(new SearchAndReplaceActionListener());
        this.exportRecordsMenuItem.addActionListener(new ExportAllRecordsActionListener(this.exportRecordsDialog));
        this.configurationMenuItem.addActionListener(new ConfigurationActionListener());
        this.saveAllMenuItem.addActionListener(new SaveAllActionListener());
        this.printMenuItem.addActionListener(new PrintActionListener());
        this.printImageMenuItem.addActionListener(new PrintImageActionListener());
        this.fileMenu.add(this.newTemplateMenuItem);
        this.fileMenu.add(this.newRecordMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.loadTemplateMenuItem);
        this.fileMenu.add(this.loadRecordMenuItem);
        this.fileMenu.add(this.loadRecordDirectoryMenuItem);
        this.fileMenu.add(this.loadServerRecordsMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveTemplateMenuItem);
        this.fileMenu.add(this.saveRecordMenuItem);
        this.fileMenu.add(this.saveAllMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.recentTemplatesMenu);
        this.fileMenu.add(this.recentRecordsMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.printMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.renderMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exportRecordsMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.quitMenuItem);
        this.editMenu.add(this.undoMenuItem);
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.add(this.findReplaceMenuItem);
        this.editMenu.add(this.insertSymbolMenuItem);
        this.settingsMenu.add(this.labelSettingsMenuItem);
        this.settingsMenu.add(this.configurationMenuItem);
        this.settingsMenu.add(this.automaticRenderingMenuItem);
        this.helpMenu.add(this.listFontsMenuItem);
        this.helpMenu.add(this.helpContentMenuItem);
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.settingsMenu);
        this.menuBar.add(this.helpMenu);
        this.templateViewJFrame.setMenuBar(this.menuBar);
        this.toolBar.setLayout(new FlowLayout(3, 0, 0));
        this.createToolBarButtons();
        this.toolBar.add(this.xmlView.getNavigationPanel().getComponent());
        this.toolBar.setMargin(new Insets(0, 0, 0, 0));
        this.templateViewJFrame.add((Component)this.toolBar, "First");
        this.saveRecordDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.saveRecordDialog.setDialogType(1);
        this.saveRecordDialog.setFileSelectionMode(0);
        this.saveRecordDialog.setMultiSelectionEnabled(false);
        this.saveRecordDialog.setFileFilter(new FileNameExtensionFilter("XML (.xml)", "xml"));
        this.newRecordDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.newRecordDialog.setDialogType(1);
        this.newRecordDialog.setFileSelectionMode(0);
        this.newRecordDialog.setMultiSelectionEnabled(false);
        this.newRecordDialog.setFileFilter(new FileNameExtensionFilter("XML (.xml)", "xml"));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(this.viewArea.getComponent(), "Center");
        JPanel statusPanel = new JPanel(new BorderLayout(0, 0));
        JPanel coordinatesPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.coordinatesLabel = new JLabel();
        coordinatesPanel.add(this.coordinatesLabel);
        statusPanel.add((Component)coordinatesPanel, "East");
        this.statusLabel = new JLabel();
        statusPanel.add((Component)this.statusLabel, "West");
        bottomPanel.add((Component)statusPanel, "South");
        this.searchAndReplaceDialog = new SearchAndReplaceDialog(this.templateViewJFrame, this);
        this.horizontalSplitPane = new JSplitPane(1, this.mainViewArea.getComponent(), this.previewView.getComponent());
        this.horizontalSplitPane.setResizeWeight(0.8);
        this.verticalSplitPane = new JSplitPane(0, this.horizontalSplitPane, bottomPanel);
        this.verticalSplitPane.setResizeWeight(1.0);
        this.verticalSplitPane.setDividerLocation(450);
        this.templateViewJFrame.add((Component)this.verticalSplitPane, "Center");
        this.templateViewJFrame.setSize(1000, 700);
        this.templateViewJFrame.setLocation(0, 0);
        this.templateViewJFrame.setDefaultCloseOperation(0);
        this.templateViewJFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DefaultTemplateView.this.onShutdown();
            }
        });
    }

    private void createToolBarButtons() {
        JLabel newButton = new JLabel(IconUtils.loadIcon("new"));
        newButton.setToolTipText("New");
        JPopupMenu newMenu = new JPopupMenu();
        JMenuItem newTemplateMenuItem = new JMenuItem(NEW_TEMPLATE);
        newTemplateMenuItem.addActionListener(new NewTemplateActionListener());
        newMenu.add(newTemplateMenuItem);
        this.newRecordPopupMenuItem = new JMenuItem(NEW_RECORD);
        this.newRecordPopupMenuItem.addActionListener(new NewRecordActionListener());
        newMenu.add(this.newRecordPopupMenuItem);
        this.toolBar.add(new SplitButton(newButton, new NewCurrentDocumentActionListener(), newMenu));
        JLabel openButton = new JLabel(IconUtils.loadIcon("open"));
        openButton.setToolTipText("Open");
        JPopupMenu openMenu = new JPopupMenu();
        this.openTemplateItem = new JMenuItem(OPEN_TEMPLATE);
        this.openTemplateItem.addActionListener(new LoadTemplateActionListener());
        openMenu.add(this.openTemplateItem);
        this.openRecordItem = new JMenuItem(OPEN_RECORD);
        this.openRecordItem.addActionListener(new LoadRecordActionListener(this.openRecordDialog));
        openMenu.add(this.openRecordItem);
        this.openRecordDirectoryItem = new JMenuItem(OPEN_RECORD_DIRECTORY);
        this.openRecordDirectoryItem.addActionListener(new LoadRecordActionListener(this.openRecordDirectoryDialog));
        openMenu.add(this.openRecordDirectoryItem);
        this.loadServerRecordsItem = new JMenuItem(LOAD_SERVER_RECORDS);
        this.loadServerRecordsItem.addActionListener(new LoadServerRecordsActionListener());
        openMenu.add(this.loadServerRecordsItem);
        this.toolBar.add(new SplitButton(openButton, new OpenCurrentDocumentActionListener(), openMenu));
        this.saveButton = new JButton(IconUtils.loadIcon("save"));
        this.saveButton.setToolTipText("Save");
        this.saveButton.setFocusable(false);
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new SaveCurrentDocumentActionListener());
        this.toolBar.add(this.saveButton);
        this.saveAllButton = new JButton(IconUtils.loadIcon("saveAll"));
        this.saveAllButton.setToolTipText("Save All");
        this.saveAllButton.setEnabled(false);
        this.saveAllButton.setFocusable(false);
        this.saveAllButton.addActionListener(new SaveAllActionListener());
        this.toolBar.add(this.saveAllButton);
        this.saveImageButton = new JButton(IconUtils.loadIcon("saveImage"));
        this.saveImageButton.setToolTipText("Save Preview Image");
        this.saveImageButton.setEnabled(false);
        this.saveImageButton.setFocusable(false);
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTemplateView.this.previewView.saveImage();
            }
        });
        this.toolBar.add(this.saveImageButton);
        this.sendImageButton = new JButton(IconUtils.loadIcon("sendImage"));
        this.sendImageButton.setToolTipText("Send Preview Image");
        this.sendImageButton.setEnabled(false);
        this.sendImageButton.setFocusable(false);
        this.sendImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTemplateView.this.previewView.sendImageToLabels();
            }
        });
        this.toolBar.add(this.sendImageButton);
        JLabel printButton = new JLabel(IconUtils.loadIcon(PRINT));
        JPopupMenu printMenu = new JPopupMenu();
        this.printCurrentDocumentMenuItem = new JMenuItem("Print Current Document");
        this.printCurrentDocumentMenuItem.addActionListener(new PrintActionListener());
        printMenu.add(this.printCurrentDocumentMenuItem);
        this.printImagePopupMenuItem = new JMenuItem(PRINT_IMAGE);
        this.printImagePopupMenuItem.addActionListener(new PrintImageActionListener());
        printMenu.add(this.printImagePopupMenuItem);
        this.toolBar.add(new SplitButton(printButton, new PrintActionListener(), printMenu));
        JToolBar.Separator toolBarSeparator = new JToolBar.Separator(new Dimension(1, 24));
        toolBarSeparator.setOrientation(1);
        this.toolBar.add(toolBarSeparator);
        this.searchButton = new JButton(IconUtils.loadIcon("Search"));
        this.searchButton.setToolTipText(SEARCH);
        this.searchButton.setFocusable(false);
        this.searchButton.setEnabled(false);
        this.searchButton.addActionListener(new SearchAndReplaceActionListener());
        this.toolBar.add(this.searchButton);
        toolBarSeparator = new JToolBar.Separator(new Dimension(1, 24));
        toolBarSeparator.setOrientation(1);
        this.toolBar.add(toolBarSeparator);
        this.zoomInButton = new JButton(IconUtils.loadIcon("zoomIn"));
        this.zoomInButton.setToolTipText("Zoom In");
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTemplateView.this.previewView.zoomIn();
            }
        });
        this.zoomInButton.setEnabled(false);
        this.zoomInButton.setFocusable(false);
        this.toolBar.add(this.zoomInButton);
        this.zoomOutButton = new JButton(IconUtils.loadIcon("zoomOut"));
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTemplateView.this.previewView.zoomOut();
            }
        });
        this.zoomOutButton.setEnabled(false);
        this.zoomOutButton.setFocusable(false);
        this.toolBar.add(this.zoomOutButton);
        toolBarSeparator = new JToolBar.Separator(new Dimension(1, 24));
        toolBarSeparator.setOrientation(1);
        this.toolBar.add(toolBarSeparator);
        this.renderButton = new JButton(IconUtils.loadIcon("Render"));
        this.renderButton.setToolTipText("Render");
        this.renderButton.setFocusable(false);
        this.renderButton.addActionListener(new RenderActionListener());
        this.renderButton.setEnabled(!this.templateModel.isAutomaticRenderingEnabled() && this.templateModel.hasXSLFileName());
        this.toolBar.add(this.renderButton);
        this.enableDebugButton = new JToggleButton(IconUtils.loadIcon("Debug"), false);
        this.enableDebugButton.setToolTipText("Enable Debug Mode");
        this.enableDebugButton.setEnabled(false);
        this.enableDebugButton.setFocusable(false);
        this.enableDebugButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTemplateView.this.templateModel.setDebugEnabled(DefaultTemplateView.this.enableDebugButton.isSelected());
            }
        });
        this.toolBar.add(this.enableDebugButton);
        JLabel settingsButton = new JLabel(IconUtils.loadIcon(SETTINGS));
        settingsButton.setToolTipText(SETTINGS);
        JPopupMenu settingsPopupMenu = new JPopupMenu();
        JMenuItem labelSettingsPopupMenuItem = new JMenuItem(LABEL_SETTINGS);
        labelSettingsPopupMenuItem.addActionListener(new LabelSettingsActionListener());
        settingsPopupMenu.add(labelSettingsPopupMenuItem);
        JMenuItem configurationPopupMenuItem = new JMenuItem(CONFIGURATION);
        configurationPopupMenuItem.addActionListener(new ConfigurationActionListener());
        settingsPopupMenu.add(configurationPopupMenuItem);
        this.toolBar.add(new SplitButton(settingsButton, new LabelSettingsActionListener(), settingsPopupMenu));
        toolBarSeparator = new JToolBar.Separator(new Dimension(1, 24));
        toolBarSeparator.setOrientation(1);
        this.toolBar.add(toolBarSeparator);
        this.symbolButton = new JButton(IconUtils.loadIcon("symbol"));
        this.symbolButton.setToolTipText(INSERT_SYMBOL);
        this.symbolButton.setFocusable(false);
        this.symbolButton.addActionListener(new InsertSymbolActionListener());
        this.symbolButton.setEnabled(!this.templateModel.isAutomaticRenderingEnabled() && this.templateModel.hasXSLFileName());
        this.toolBar.add(this.symbolButton);
        this.toolBar.add(toolBarSeparator);
    }

    private void initHelpers() {
        this.newTemplateDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.newTemplateDialog.setDialogType(1);
        this.newTemplateDialog.setFileSelectionMode(0);
        this.newTemplateDialog.setMultiSelectionEnabled(false);
        this.newTemplateDialog.setFileFilter(new FileNameExtensionFilter("Templates (.xsl)", "xsl"));
        this.openTemplateDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.openTemplateDialog.setDialogType(0);
        this.openTemplateDialog.setFileSelectionMode(0);
        this.openTemplateDialog.setMultiSelectionEnabled(false);
        this.openTemplateDialog.setFileFilter(new FileNameExtensionFilter("Templates (.xsl)", "xsl"));
        this.saveTemplateDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.saveTemplateDialog.setDialogType(1);
        this.saveTemplateDialog.setFileSelectionMode(0);
        this.saveTemplateDialog.setMultiSelectionEnabled(false);
        this.saveTemplateDialog.setFileFilter(new FileNameExtensionFilter("Templates (.xsl)", "xsl"));
        this.openRecordDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.openRecordDialog.setDialogType(0);
        this.openRecordDialog.setFileSelectionMode(0);
        this.openRecordDialog.setMultiSelectionEnabled(true);
        this.openRecordDialog.setFileFilter(new FileNameExtensionFilter("XML Files (.xml)", "xml"));
        this.openRecordDirectoryDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.openRecordDirectoryDialog.setDialogType(0);
        this.openRecordDirectoryDialog.setFileSelectionMode(1);
        this.openRecordDirectoryDialog.setMultiSelectionEnabled(true);
        this.openRecordDirectoryDialog.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Directories";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        this.exportRecordsDialog = new JFileChooser(new File(DEFAULT_TEMPLATE_PATH));
        this.exportRecordsDialog.setDialogType(1);
        this.exportRecordsDialog.setFileSelectionMode(1);
        this.exportRecordsDialog.setMultiSelectionEnabled(false);
        this.exportRecordsDialog.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Directories";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    private void loadRecentEntries() {
        List<String> recentTemplates = this.templateModel.getRecentTemplates();
        this.recentTemplatesMenu.removeAll();
        this.recentTemplatesMenu.setEnabled(recentTemplates.size() > 0);
        for (String recentTemplate : recentTemplates) {
            MenuItem menuItem = new MenuItem(recentTemplate);
            menuItem.addActionListener(new LoadRecentTemplateActionListener());
            this.recentTemplatesMenu.add(menuItem);
        }
        List<String> recentRecords = this.templateModel.getRecentRecords();
        this.recentRecordsMenu.removeAll();
        this.recentRecordsMenu.setEnabled(recentRecords.size() > 0);
        for (String recentRecord : recentRecords) {
            MenuItem menuItem = new MenuItem(recentRecord);
            menuItem.addActionListener(new LoadRecentRecordActionListener());
            this.recentRecordsMenu.add(menuItem);
        }
    }

    private void onShutdown() {
        if (this.doCloseTemplate() && this.doCloseAllRecords()) {
            this.shutdown();
        }
    }

    @Override
    public void show() {
        this.updateContent();
        this.templateViewJFrame.setVisible(true);
    }

    public void updateCoordinates(int xPos, int yPos) {
        this.coordinatesLabel.setText("X: " + String.valueOf(xPos) + ", Y: " + String.valueOf(yPos));
    }

    @Override
    public void update(Observable paramObservable, Object paramObject) {
        this.updateContent();
        this.updateXSLView();
        this.loadRecentEntries();
    }

    private void updateXSLView() {
        this.xslView.setModified(this.templateModel.isXSLModified());
        this.mainViewArea.viewUpdated(this.xslView);
    }

    protected void updateContent() {
        this.updateMenu();
        this.updateProblems();
        this.updateStatusPanel();
    }

    private void updateStatusPanel() {
        Boolean renderingSuccessful = this.templateModel.wasRenderingSuccessful();
        if (renderingSuccessful == null) {
            this.statusLabel.setIcon(null);
        } else if (renderingSuccessful.booleanValue()) {
            this.statusLabel.setIcon(CHECKMARK);
        } else {
            this.statusLabel.setIcon(CROSSMARK);
        }
    }

    private void updateMenu() {
        this.saveRecordMenuItem.setEnabled(!this.templateModel.xmlDocumentIsEmpty() && this.templateModel.getRecordsContainer().getCurrentRecord().isModified());
        this.saveTemplateMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty() && this.templateModel.isXSLModified());
        if (this.saveRecordMenuItem.isEnabled() || this.saveTemplateMenuItem.isEnabled()) {
            this.saveAllButton.setEnabled(true);
        } else {
            this.saveAllButton.setEnabled(false);
        }
        this.saveAllMenuItem.setEnabled(this.saveAllButton.isEnabled());
        if (this.mainViewArea.getActivatedComponent().equals(this.xmlView.getComponent())) {
            this.saveButton.setEnabled(this.saveRecordMenuItem.isEnabled());
        } else {
            this.saveButton.setEnabled(this.saveTemplateMenuItem.isEnabled());
        }
        this.printImageMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.printImagePopupMenuItem.setEnabled(this.printImageMenuItem.isEnabled());
        this.printMenuItem.setEnabled(this.mainViewArea.getActivatedComponent().equals(this.xmlView.getComponent()) ? !this.templateModel.xmlDocumentIsEmpty() : !this.templateModel.xslDocumentIsEmpty());
        this.printCurrentDocumentMenuItem.setEnabled(this.printMenuItem.isEnabled());
        this.findReplaceMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.insertSymbolMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.symbolButton.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.searchButton.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.zoomInButton.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.zoomOutButton.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.saveImageButton.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.sendImageButton.setEnabled(!this.templateModel.xslDocumentIsEmpty() && this.templateModel.canSendImageToLabels());
        this.enableDebugButton.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.enableDebugButton.setSelected(this.templateModel.isDebugEnabled());
        this.renderButton.setEnabled(!this.templateModel.isAutomaticRenderingEnabled() && !this.templateModel.xslDocumentIsEmpty());
        this.renderMenuItem.setEnabled(this.loadRecordMenuItem.isEnabled());
        this.newRecordMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.newRecordPopupMenuItem.setEnabled(this.newRecordMenuItem.isEnabled());
        this.loadRecordMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.openRecordItem.setEnabled(this.loadRecordMenuItem.isEnabled());
        this.recentRecordsMenu.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.loadRecordDirectoryMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.openRecordDirectoryItem.setEnabled(this.loadRecordDirectoryMenuItem.isEnabled());
        this.loadServerRecordsMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.loadServerRecordsItem.setEnabled(this.loadServerRecordsMenuItem.isEnabled());
        this.exportRecordsMenuItem.setEnabled(!this.templateModel.xslDocumentIsEmpty());
        this.undoMenuItem.setLabel(UNDO);
        this.redoMenuItem.setLabel(REDO);
        this.undoMenuItem.setEnabled(false);
        this.redoMenuItem.setEnabled(false);
        if (this.templateController.getUndoManager() != null && this.templateController.getUndoManager().canUndo()) {
            this.undoMenuItem.setEnabled(true);
        }
        if (this.templateController.getUndoManager() != null && this.templateController.getUndoManager().canRedo()) {
            this.redoMenuItem.setEnabled(true);
        }
        this.templateViewJFrame.repaint();
    }

    private void updateProblems() {
        ExecutionStatus status = this.templateModel.getStatus();
        if (status != null) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            for (ExecutionStatusElement<?> element : status.getElements()) {
                TableRenderingExecutionStatusElement tableElement;
                ExecutionStatusElement renderingElement;
                String message = null;
                String identifier = element.toString();
                ProblemSeverity problemSeverity = this.toProblemSeverity(element.getErrorLevel());
                if (element instanceof RecordRenderingExceptionElement) {
                    renderingElement = (RecordRenderingExceptionElement)element;
                    problems.add(new RecordRenderingProblem(problemSeverity, identifier, ((ExceptionElement)renderingElement).getElement().getMessage() + " (" + ((RecordRenderingExceptionElement)renderingElement).getRecord().getDisplayName() + ")", ((RenderingExceptionElement)renderingElement).getFieldId(), ((RecordRenderingExceptionElement)renderingElement).getRecord()));
                } else if (element instanceof RenderingExceptionElement) {
                    renderingElement = (RenderingExceptionElement)element;
                    problems.add(new RenderingProblem(problemSeverity, identifier, ((ExceptionElement)renderingElement).getElement().getMessage(), ((RenderingExceptionElement)renderingElement).getFieldId()));
                } else if (element instanceof RenderingStringElement) {
                    renderingElement = (RenderingStringElement)element;
                    problems.add(new RenderingProblem(problemSeverity, identifier, ((StringElement)renderingElement).getElement(), ((RenderingStringElement)renderingElement).getFieldId()));
                } else if (element instanceof TableRenderingExceptionElement) {
                    tableElement = (TableRenderingExceptionElement)element;
                    problems.add(new RenderingTableProblem(problemSeverity, identifier, ((Exception)tableElement.getElement()).getMessage() + " " + tableElement.getTableDescription(), tableElement.getFieldId(), tableElement.getRowNumber(), tableElement.getColumnNumber()));
                } else if (element instanceof TableRenderingStringElement) {
                    tableElement = (TableRenderingStringElement)element;
                    problems.add(new RenderingTableProblem(problemSeverity, identifier, (String)tableElement.getElement() + " " + tableElement.getTableDescription(), tableElement.getFieldId(), tableElement.getRowNumber(), tableElement.getColumnNumber()));
                } else if (element instanceof StringElement) {
                    message = (String)element.getElement();
                } else if (element instanceof ExceptionElement) {
                    Exception e = (Exception)element.getElement();
                    String string = e.getMessage() != null ? e.getMessage() : (message = e.getCause() != null ? e.getCause().getMessage() : null);
                }
                if (element instanceof XMLValidationElement) {
                    XMLValidationElement xmlElement = (XMLValidationElement)element;
                    message = xmlElement.getElement().getMessage() + " Line: " + xmlElement.getElement().getLineNumber() + " Column: " + xmlElement.getElement().getColumnNumber();
                    problems.add(new XMLProblem(xmlElement, problemSeverity, identifier, message));
                    continue;
                }
                if (message == null || identifier == null) continue;
                problems.add(new MessageProblem(problemSeverity, identifier, message));
            }
            this.problemsView.update(problems);
        }
    }

    private ProblemSeverity toProblemSeverity(ExecutionStatusElement.ErrorLevel errorLevel) {
        if (errorLevel == ExecutionStatusElement.ErrorLevel.WARNING) {
            return ProblemSeverity.WARNING;
        }
        if (errorLevel == ExecutionStatusElement.ErrorLevel.INFO) {
            return ProblemSeverity.INFO;
        }
        return ProblemSeverity.ERROR;
    }

    @Override
    public UndoManager getCurrentlyActiveUndoManager() {
        if (this.mainViewArea.getActivatedComponent().equals(this.xmlView.getComponent())) {
            SourceEditorView currentView = this.xmlView.getCurrentView();
            if (currentView != null) {
                return currentView.getUndoManager();
            }
        } else if (!this.templateModel.isDesignViewEnabled()) {
            return this.xslView.getUndoManager();
        }
        return null;
    }

    public void undo() {
        try {
            UndoManager undoManager = this.templateController.getUndoManager();
            if (undoManager.canUndo()) {
                undoManager.undo();
            }
        }
        catch (Exception exc) {
            logger.logException(exc);
        }
    }

    public void redo() {
        try {
            UndoManager undoManager = this.templateController.getUndoManager();
            if (undoManager.canRedo()) {
                undoManager.redo();
            }
        }
        catch (Exception exc) {
            logger.logException(exc);
        }
    }

    @Override
    public int showConfirmDialog(String message) {
        return JOptionPane.showConfirmDialog(this.templateViewJFrame, message);
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof ResizeElementEvent) {
            ResizeElementEvent resizeElementEvent = (ResizeElementEvent)event;
            ((DesignTemplateController)this.templateController).resizeElement(resizeElementEvent.getFieldId(), resizeElementEvent.getShape());
        } else if (event instanceof RemoveCanvasElementEvent) {
            RemoveCanvasElementEvent removeCanvasElementEvent = (RemoveCanvasElementEvent)event;
            boolean safeToDelete = ((DesignTemplateModel)this.templateModel).isFieldSafeToDelete(removeCanvasElementEvent.getFieldId());
            if (safeToDelete) {
                ((DesignTemplateController)this.templateController).removeField(removeCanvasElementEvent.getFieldId(), false);
            } else {
                GUIUtils.issueNotificationPopup(this.templateViewJFrame, "Field might not be fully reproducible. Deletion not allowed.", "Stopping Operation");
            }
        } else if (event instanceof RefreshViewEvent) {
            ((DesignTemplateModel)this.templateModel).refresh();
        } else if (event instanceof UndoRedoEvent) {
            UndoRedoEvent undoRedoEvent = (UndoRedoEvent)((Object)event);
            if (undoRedoEvent.isUndo()) {
                this.undo();
            } else {
                this.redo();
            }
        }
    }

    @Override
    public void viewUpdated(View view) {
    }

    @Override
    public void viewActivated(View view) {
    }

    @Override
    public void viewCleared(View view) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof JList) {
            JList list = (JList)e.getSource();
            Problem value = (Problem)list.getSelectedValue();
            if (value instanceof XMLProblem) {
                XMLValidationElement element = ((XMLProblem)value).getValidationElement();
                if (element.getView() != null && element.getView() instanceof SourceEditorView) {
                    SourceEditorView view = (SourceEditorView)element.getView();
                    if (this.xmlView.containsView(view)) {
                        this.xmlView.activateView(view.getIdentifier().toString());
                    } else if (view.getIdentifier().equals("RENDERING")) {
                        this.previewView.changeView(view);
                    } else {
                        this.mainViewArea.viewActivated(view);
                    }
                    view.goTo(element.getElement().getLineNumber(), element.getElement().getColumnNumber());
                } else if (element.getIdentifier() != null) {
                    this.xmlView.activateView(element.getIdentifier().toString());
                    this.xmlView.getCurrentView().goTo(element.getElement().getLineNumber(), element.getElement().getColumnNumber());
                }
            } else if (value instanceof RenderingProblem) {
                RenderingProblem problem = (RenderingProblem)value;
                this.previewView.setCaretToField(problem.getFieldId());
                if (value instanceof RecordRenderingProblem) {
                    this.xmlView.activateView(((RecordRenderingProblem)value).getRecord().toString());
                    this.mainViewArea.viewActivated(this.xmlView);
                }
                this.dispatchEvent(new FocusElementEvent(problem.getFieldId(), false));
            } else if (value instanceof RenderingTableProblem) {
                RenderingTableProblem problem = (RenderingTableProblem)value;
                this.previewView.setCaretToTableElement(problem.getFieldId(), problem.getRowNumber(), problem.getColumnNumber());
                this.dispatchEvent(new FocusTableElementEvent(problem.getRowNumber(), problem.getColumnNumber()));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private boolean doCloseTemplate() {
        if (this.templateModel.isXSLModified()) {
            int confirmReturn = JOptionPane.showConfirmDialog(this.templateViewJFrame, "The template has been modified. Do you want to save the template?");
            switch (confirmReturn) {
                case 0: {
                    return new SaveTemplateActionListener().saveTemplate();
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean doCloseAllRecords() {
        return this.templateController.closeAllRecords();
    }

    @Override
    public void notifyTextModified(SourceEditorView view) {
        this.templateModel.setXSLModified();
    }

    @Override
    public JTextArea getCurrentTextArea() {
        Component component = this.templateViewJFrame.getMostRecentFocusOwner();
        if (component != null && component instanceof RSyntaxTextArea) {
            return (RSyntaxTextArea)component;
        }
        return null;
    }

    @Override
    public String showSaveAsDialog() {
        int returnValue = this.saveRecordDialog.showSaveDialog(this.templateViewJFrame);
        if (returnValue == 0) {
            int confirmReturn;
            if (this.saveRecordDialog.getSelectedFile().exists() && (confirmReturn = JOptionPane.showConfirmDialog(this.templateViewJFrame, "The file already exists. Do you want to overwrite it?")) == 2) {
                return null;
            }
            return this.saveRecordDialog.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    @Override
    public String showSaveDialog(String fileName) {
        this.saveRecordDialog.setSelectedFile(new File(fileName));
        int returnValue = this.saveRecordDialog.showSaveDialog(this.templateViewJFrame);
        if (returnValue == 0) {
            return this.saveRecordDialog.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private class LoadServerRecordsActionListener
    implements ActionListener {
        private LoadServerRecordsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTemplateView.this.templateModel.getPreferences().getRecentServiceAddresses();
            ChooseServerDialog dialog = new ChooseServerDialog(DefaultTemplateView.this.templateViewJFrame, DefaultTemplateView.this.templateModel.getPreferences().getRecentServiceAddresses());
            dialog.show();
            if (!dialog.isCancelled()) {
                try {
                    ServiceAddress address = dialog.getAddress();
                    DefaultTemplateView.this.templateModel.getPreferences().setServiceAddresses(dialog.getEntries());
                    DefaultTemplateView.this.templateController.loadServerRecords(address);
                }
                catch (MalformedURLException exc) {
                    JOptionPane.showMessageDialog(DefaultTemplateView.this.templateViewJFrame, "Invalid server address", exc.getMessage(), 0);
                }
                catch (BackingStoreException exc) {
                    TemplateView.logger.warn("Error storing service addresses to preferences: %s", exc.getMessage());
                    TemplateView.logger.logExceptionIfDebugEnabled(exc);
                }
            }
        }
    }

    private class LoadRecordActionListener
    implements ActionListener {
        private final JFileChooser fileDialog;

        public LoadRecordActionListener(JFileChooser openRecordDialog) {
            this.fileDialog = openRecordDialog;
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            int returnVal = this.fileDialog.showOpenDialog(DefaultTemplateView.this.templateViewJFrame);
            if (returnVal == 0) {
                File[] selectedFiles = this.fileDialog.getSelectedFiles();
                DefaultTemplateView.this.templateController.loadRecords(new ArrayList<File>(Arrays.asList(selectedFiles)));
                DefaultTemplateView.this.loadRecentEntries();
            }
        }
    }

    private class LoadTemplateActionListener
    implements ActionListener {
        private LoadTemplateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            int returnVal;
            if (DefaultTemplateView.this.doCloseTemplate() && (returnVal = DefaultTemplateView.this.openTemplateDialog.showOpenDialog(DefaultTemplateView.this.templateViewJFrame)) == 0) {
                DefaultTemplateView.this.templateController.loadXSLFile(DefaultTemplateView.this.openTemplateDialog.getSelectedFile().getAbsolutePath());
                DefaultTemplateView.this.loadRecentEntries();
                DefaultTemplateView.this.newTemplateCreated = false;
                DefaultTemplateView.this.mainViewArea.viewUpdated(DefaultTemplateView.this.xslView);
            }
        }
    }

    private class SaveCurrentDocumentKeyEventDispatcher
    implements KeyEventDispatcher {
        private SaveTemplateActionListener templateListener;
        private SaveRecordActionListener recordListener;

        private SaveCurrentDocumentKeyEventDispatcher() {
            this.templateListener = new SaveTemplateActionListener();
            this.recordListener = new SaveRecordActionListener();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401 && e.getKeyCode() == 83 && e.getModifiers() == 2) {
                e.consume();
                if (DefaultTemplateView.this.mainViewArea.getActivatedComponent().equals(DefaultTemplateView.this.xmlView.getComponent())) {
                    this.recordListener.actionPerformed(null);
                    return true;
                }
                this.templateListener.actionPerformed(null);
                return true;
            }
            return false;
        }
    }

    private class OpenCurrentDocumentTypeKeyEventDispatcher
    implements KeyEventDispatcher {
        private LoadRecordActionListener recordListener;
        private LoadTemplateActionListener templateListener;
        private boolean inProgress;

        private OpenCurrentDocumentTypeKeyEventDispatcher() {
            this.recordListener = new LoadRecordActionListener(DefaultTemplateView.this.openRecordDialog);
            this.templateListener = new LoadTemplateActionListener();
            this.inProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (!this.inProgress) {
                try {
                    this.inProgress = true;
                    if (e.getID() == 401 && e.getKeyCode() == 79 && e.getModifiers() == 2) {
                        if (DefaultTemplateView.this.mainViewArea.getActivatedComponent().equals(DefaultTemplateView.this.xmlView.getComponent())) {
                            if (DefaultTemplateView.this.loadRecordMenuItem.isEnabled()) {
                                this.recordListener.actionPerformed(null);
                                boolean bl = true;
                                return bl;
                            }
                        } else if (DefaultTemplateView.this.loadTemplateMenuItem.isEnabled()) {
                            this.templateListener.actionPerformed(null);
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                finally {
                    this.inProgress = false;
                }
                return false;
            }
            return false;
        }
    }

    private class OpenCurrentDocumentActionListener
    implements ActionListener {
        private LoadTemplateActionListener templateListener;
        private LoadRecordActionListener recordListener;

        private OpenCurrentDocumentActionListener() {
            this.templateListener = new LoadTemplateActionListener();
            this.recordListener = new LoadRecordActionListener(DefaultTemplateView.this.openRecordDialog);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultTemplateView.this.mainViewArea.getActivatedComponent().equals(DefaultTemplateView.this.xmlView.getComponent())) {
                if (DefaultTemplateView.this.loadRecordMenuItem.isEnabled()) {
                    this.recordListener.actionPerformed(null);
                }
            } else if (DefaultTemplateView.this.loadTemplateMenuItem.isEnabled()) {
                this.templateListener.actionPerformed(null);
            }
        }
    }

    private class HelpContentKeyEventDispatcher
    implements KeyEventDispatcher {
        private HelpContentActionListener helpContentActionListener;

        private HelpContentKeyEventDispatcher() {
            this.helpContentActionListener = new HelpContentActionListener();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401 && e.getKeyCode() == 112) {
                this.helpContentActionListener.actionPerformed(null);
                return true;
            }
            return false;
        }
    }

    private class RenderingKeyEventDispatcher
    implements KeyEventDispatcher {
        private RenderActionListener renderActionListener;

        private RenderingKeyEventDispatcher() {
            this.renderActionListener = new RenderActionListener();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401 && !DefaultTemplateView.this.templateModel.isAutomaticRenderingEnabled() && e.getKeyCode() == 116) {
                this.renderActionListener.actionPerformed(null);
                return true;
            }
            return false;
        }
    }

    private class SaveRecordActionListener
    implements ActionListener {
        private SaveRecordActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DefaultTemplateView.this.templateController.saveCurrentRecord();
        }
    }

    private class SaveTemplateActionListener
    implements ActionListener {
        private SaveTemplateActionListener() {
        }

        public boolean saveTemplate() {
            if (DefaultTemplateView.this.newTemplateCreated || !DefaultTemplateView.this.templateModel.hasXSLFileName() && !DefaultTemplateView.this.templateModel.xslDocumentIsEmpty()) {
                int returnVal;
                if (DefaultTemplateView.this.newTemplateCreated) {
                    DefaultTemplateView.this.saveTemplateDialog.setSelectedFile(new File(DefaultTemplateView.this.templateModel.getXSLFileName()));
                }
                if ((returnVal = DefaultTemplateView.this.saveTemplateDialog.showSaveDialog(DefaultTemplateView.this.templateViewJFrame)) == 0) {
                    int confirmReturn;
                    File selectedFile = DefaultTemplateView.this.saveTemplateDialog.getSelectedFile();
                    if (!FilenameUtils.isExtension((String)selectedFile.getName(), (String)"xsl")) {
                        selectedFile = new File(selectedFile.getAbsolutePath() + ".xsl");
                    }
                    if (selectedFile.exists() && (confirmReturn = JOptionPane.showConfirmDialog(DefaultTemplateView.this.templateViewJFrame, "The file already exists. Do you want to overwrite it?")) != 0) {
                        return false;
                    }
                    DefaultTemplateView.this.templateModel.setXSLFileName(selectedFile.getAbsolutePath());
                    DefaultTemplateView.this.templateController.saveXSLFile();
                    DefaultTemplateView.this.loadRecentEntries();
                    DefaultTemplateView.this.newTemplateCreated = false;
                } else if (returnVal == 1) {
                    return false;
                }
            } else {
                DefaultTemplateView.this.templateController.saveXSLFile();
                DefaultTemplateView.this.loadRecentEntries();
            }
            DefaultTemplateView.this.mainViewArea.viewUpdated(DefaultTemplateView.this.xslView);
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            this.saveTemplate();
        }
    }

    private class NewTemplateActionListener
    implements ActionListener {
        private NewTemplateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            if (DefaultTemplateView.this.doCloseTemplate()) {
                DefaultTemplateView.this.newTemplateCreated = true;
                DefaultTemplateView.this.newTemplateCount++;
                new TemplateCreationController(DefaultTemplateView.DEFAULT_NEW_TEMPLATE_FILENAME + String.valueOf(DefaultTemplateView.this.newTemplateCount) + ".xsl", DefaultTemplateView.this.templateViewJFrame, DefaultTemplateView.this.templateController);
            }
        }
    }

    private class InsertSymbolActionListener
    implements ActionListener {
        private InsertSymbolActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SymbolDialog dialog = new SymbolDialog(DefaultTemplateView.this.templateViewJFrame);
            dialog.showDialog(DefaultTemplateView.this.templateViewJFrame);
            if (dialog.hasResult()) {
                Integer unicode = dialog.getUnicode();
                try {
                    DefaultTemplateView.this.getCurrentTextArea().getDocument().insertString(DefaultTemplateView.this.getCurrentTextArea().getCaretPosition(), String.format("&#%d;", unicode), null);
                }
                catch (BadLocationException exc) {
                    TemplateView.logger.warn("Could not insert unicode character %d at position %d: %s", unicode, DefaultTemplateView.this.getCurrentTextArea().getCaretPosition(), exc.getMessage());
                    TemplateView.logger.logExceptionIfDebugEnabled(exc);
                }
            }
        }
    }

    private class RenderActionListener
    implements ActionListener {
        private RenderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTemplateView.this.templateModel.triggerTemplateRendering();
        }
    }

    private class SearchAndReplaceActionListener
    implements ActionListener {
        private SearchAndReplaceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTemplateView.this.searchAndReplaceDialog.showDialog();
        }
    }

    private class ExportAllRecordsActionListener
    implements ActionListener {
        private final JFileChooser exportRecordsDialog;

        public ExportAllRecordsActionListener(JFileChooser exportRecordsDialog) {
            this.exportRecordsDialog = exportRecordsDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File selectedFile;
            int returnValue = this.exportRecordsDialog.showSaveDialog(DefaultTemplateView.this.templateViewJFrame);
            if (returnValue == 0 && (selectedFile = this.exportRecordsDialog.getSelectedFile()).isDirectory()) {
                DefaultTemplateView.this.templateController.exportRecordsAsImage(selectedFile);
            }
        }
    }

    private class ListFontsActionListener
    implements ActionListener {
        private FontsView fontsView = null;

        private ListFontsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fontsView == null) {
                try {
                    this.fontsView = new FontsView(DefaultTemplateView.this.templateViewJFrame);
                }
                catch (InitializationException exc) {
                    TemplateView.logger.logExceptionIfDebugEnabled(exc);
                    JOptionPane.showMessageDialog(DefaultTemplateView.this.templateViewJFrame, exc.getMessage(), "Could not open fonts view", 2);
                }
            }
            this.fontsView.setVisible(true);
        }
    }

    private class HelpContentActionListener
    implements ActionListener {
        private HelpContentActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File helpFile = new File("help/index.html");
            if (helpFile.exists()) {
                try {
                    Desktop.getDesktop().browse(helpFile.toURI());
                }
                catch (IOException exc) {
                    TemplateView.logger.warn("Could not open help index file (%s)", helpFile.getPath());
                    TemplateView.logger.logExceptionIfDebugEnabled(exc);
                }
            } else {
                JOptionPane.showMessageDialog(DefaultTemplateView.this.templateViewJFrame, String.format("The help content was not found at %s. Please make sure the help files where generated correctly.", helpFile.getPath()), "Help content not found", 2);
            }
        }
    }

    private class AutomaticRenderingChangedItemListener
    implements ItemListener {
        private AutomaticRenderingChangedItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DefaultTemplateView.this.templateModel.setAutomaticRenderingEnabled(DefaultTemplateView.this.automaticRenderingMenuItem.getState());
            DefaultTemplateView.this.renderMenuItem.setEnabled(!DefaultTemplateView.this.automaticRenderingMenuItem.getState() && DefaultTemplateView.this.templateModel.hasXSLFileName());
            DefaultTemplateView.this.renderButton.setEnabled(!DefaultTemplateView.this.automaticRenderingMenuItem.getState() && DefaultTemplateView.this.templateModel.hasXSLFileName());
        }
    }

    private class SaveCurrentDocumentActionListener
    implements ActionListener {
        private SaveTemplateActionListener templateListener;
        private SaveRecordActionListener recordListener;

        private SaveCurrentDocumentActionListener() {
            this.templateListener = new SaveTemplateActionListener();
            this.recordListener = new SaveRecordActionListener();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultTemplateView.this.mainViewArea.getActivatedComponent().equals(DefaultTemplateView.this.xmlView.getComponent())) {
                this.recordListener.actionPerformed(e);
            } else {
                this.templateListener.actionPerformed(e);
            }
        }
    }

    private class SaveAllActionListener
    implements ActionListener {
        private SaveTemplateActionListener templateListener;

        private SaveAllActionListener() {
            this.templateListener = new SaveTemplateActionListener();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultTemplateView.this.saveTemplateMenuItem.isEnabled()) {
                this.templateListener.actionPerformed(e);
            }
            DefaultTemplateView.this.templateController.saveAllRecords();
        }
    }

    private class NewCurrentDocumentActionListener
    implements ActionListener {
        private NewTemplateActionListener templateListener;
        private NewRecordActionListener recordListener;

        private NewCurrentDocumentActionListener() {
            this.templateListener = new NewTemplateActionListener();
            this.recordListener = new NewRecordActionListener();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultTemplateView.this.mainViewArea.getActivatedComponent().equals(DefaultTemplateView.this.xmlView.getComponent())) {
                if (DefaultTemplateView.this.newRecordMenuItem.isEnabled()) {
                    this.recordListener.actionPerformed(e);
                }
            } else if (DefaultTemplateView.this.newTemplateMenuItem.isEnabled()) {
                this.templateListener.actionPerformed(e);
            }
        }
    }

    private class NewRecordActionListener
    implements ActionListener {
        private NewRecordActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DefaultTemplateView.this.templateController.newXMLRecord();
            DefaultTemplateView.this.mainViewArea.viewUpdated(DefaultTemplateView.this.xmlView);
        }
    }

    private class RedoActionListener
    implements ActionListener {
        private RedoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DefaultTemplateView.this.redo();
        }
    }

    private class UndoActionListener
    implements ActionListener {
        private UndoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DefaultTemplateView.this.undo();
        }
    }

    private class QuitActionListener
    implements ActionListener {
        private QuitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            DefaultTemplateView.this.onShutdown();
        }
    }

    private class LabelSettingsActionListener
    implements ActionListener {
        private LabelSettingsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            new LabelSettingsView(DefaultTemplateView.this.templateModel, DefaultTemplateView.this.templateViewJFrame);
        }
    }

    private class LoadRecentRecordActionListener
    implements ActionListener {
        private LoadRecentRecordActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            String recordName = paramActionEvent.getActionCommand();
            DefaultTemplateView.this.templateController.loadRecords(Collections.singletonList(new File(recordName)));
            DefaultTemplateView.this.loadRecentEntries();
        }
    }

    private class LoadRecentTemplateActionListener
    implements ActionListener {
        private LoadRecentTemplateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            String templateName = paramActionEvent.getActionCommand();
            DefaultTemplateView.this.templateController.loadXSLFile(templateName);
            DefaultTemplateView.this.loadRecentEntries();
        }
    }

    private class ConfigurationActionListener
    implements ActionListener {
        private ConfigurationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            new ConfigurationView(DefaultTemplateView.this, DefaultTemplateView.this.templateViewJFrame, ((DesignTemplateModel)DefaultTemplateView.this.templateModel).isDesignViewEnabled());
        }
    }

    private class PrintActionListener
    implements ActionListener {
        private PrintActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DefaultTemplateView.this.mainViewArea.getActivatedComponent().equals(DefaultTemplateView.this.xmlView.getComponent())) {
                            if (DefaultTemplateView.this.loadRecordMenuItem.isEnabled()) {
                                DefaultTemplateView.this.xmlView.printCurrentRecord();
                            }
                        } else if (DefaultTemplateView.this.loadRecordMenuItem.isEnabled()) {
                            DefaultTemplateView.this.xslView.print();
                        }
                    }
                    catch (PrinterException exc) {
                        TemplateView.logger.warn("Could not print document: %s", exc.getMessage());
                        TemplateView.logger.logExceptionIfDebugEnabled(exc);
                        DefaultTemplateView.this.templateModel.addExecutionStatus(new ExceptionElement(exc));
                    }
                }
            }).start();
        }
    }

    private class ImagePrintable
    implements Printable {
        private double x;
        private double y;
        private double width;
        private int orientation;
        private BufferedImage image;

        public ImagePrintable(PrinterJob printJob, BufferedImage image) {
            PageFormat pageFormat = printJob.defaultPage();
            this.x = pageFormat.getImageableX();
            this.y = pageFormat.getImageableY();
            this.width = pageFormat.getImageableWidth();
            this.orientation = pageFormat.getOrientation();
            this.image = image;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex == 0) {
                int pWidth = 0;
                int pHeight = 0;
                if (this.orientation == 1) {
                    pWidth = (int)Math.min(this.width, (double)this.image.getWidth());
                    pHeight = pWidth * this.image.getHeight() / this.image.getWidth();
                } else {
                    pHeight = (int)Math.min(this.width, (double)this.image.getHeight());
                    pWidth = pHeight * this.image.getWidth() / this.image.getHeight();
                }
                g.drawImage(this.image, (int)this.x, (int)this.y, pWidth, pHeight, null);
                return 0;
            }
            return 1;
        }
    }

    private class PrintImageActionListener
    implements ActionListener {
        private PrintImageActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultTemplateView.this.loadRecordMenuItem.isEnabled() && DefaultTemplateView.this.templateModel.getRenderedImage() != null && DefaultTemplateView.this.templateModel.getRenderedImage() instanceof BufferedImage) {
                final PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable(new ImagePrintable(printJob, (BufferedImage)DefaultTemplateView.this.templateModel.getRenderedImage()));
                if (printJob.printDialog()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                printJob.print();
                            }
                            catch (PrinterException exc) {
                                TemplateView.logger.warn("Could not print document: %s", exc.getMessage());
                                TemplateView.logger.logExceptionIfDebugEnabled(exc);
                                DefaultTemplateView.this.templateModel.addExecutionStatus(new ExceptionElement(exc));
                            }
                        }
                    }).start();
                }
            }
        }
    }

    private class AboutActionListener
    implements ActionListener {
        private AboutActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            try {
                Info info = Info.load(TemplateEditor.class);
                new AboutDialog(DefaultTemplateView.this.templateViewJFrame, "imagotag Template Editor", info.getVersion());
            }
            catch (IOException exc) {
                TemplateView.logger.logExceptionIfDebugEnabled(exc);
            }
            catch (URISyntaxException exc) {
                TemplateView.logger.logExceptionIfDebugEnabled(exc);
            }
            catch (SerializeException exc) {
                TemplateView.logger.warn("Could not load info xml");
                TemplateView.logger.logExceptionIfDebugEnabled(exc);
            }
            catch (InitializationException exc) {
                TemplateView.logger.warn("Could not load info xml");
                TemplateView.logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }
}

