/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.template.editor.controller.event.EnableDesignViewEvent;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;

public class ConfigurationView {
    private JPanel mainPanel;
    private JDialog dialog;
    private JCheckBox enableDesign;
    private final EventDispatcher dispatcher;

    public ConfigurationView(EventDispatcher dispatcher, JFrame parentFrame, boolean designViewEnabled) {
        this.dispatcher = dispatcher;
        this.dialog = new JDialog(parentFrame, "Configuration", true);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(2);
        this.mainPanel = new JPanel(new SpringLayout());
        this.enableDesign = new JCheckBox("Enable Design Mode", designViewEnabled);
        this.mainPanel.add(this.enableDesign);
        SpringUtilities.makeCompactGrid(this.mainPanel, 1, 1, 5, 5, 5, 5);
        this.dialog.add((Component)this.mainPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationView.this.onSaveButton();
            }
        });
        buttonPanel.add(saveButton);
        this.dialog.add((Component)buttonPanel, "South");
        this.dialog.setPreferredSize(new Dimension(300, 150));
        this.dialog.setResizable(false);
        this.dialog.getRootPane().setDefaultButton(saveButton);
        this.registerEscapeKeyAction();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentFrame);
        this.dialog.setVisible(true);
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationView.this.dialog.setVisible(false);
                ConfigurationView.this.dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void onSaveButton() {
        this.dispatcher.dispatchEvent(new EnableDesignViewEvent(this.enableDesign.isSelected()));
        this.dialog.dispose();
    }
}

