/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.view;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.core.TasksSubmittedNotify;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.gui.ConnectionStatusTableCellRenderer;
import at.mrdevelopment.esl.gui.DateTimeTableCellRenderer;
import at.mrdevelopment.esl.gui.LabelErrorsTableCellRenderer;
import at.mrdevelopment.esl.gui.LabelIdTableCellRenderer;
import at.mrdevelopment.esl.gui.LabelTypeTableCellRenderer;
import at.mrdevelopment.esl.gui.PowerStatusTableCellRenderer;
import at.mrdevelopment.esl.gui.StatusTableCellRenderer;
import at.mrdevelopment.esl.gui.SyncQualityTableCellRenderer;
import at.mrdevelopment.esl.gui.UpdateErrorTableCellRenderer;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.service.ServiceClient;
import at.mrdevelopment.esl.tasks.BinaryImageTask;
import at.mrdevelopment.esl.template.editor.model.LabelInfoFilter;
import at.mrdevelopment.esl.template.editor.model.LabelInfoTableModel;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.Transaction;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.http.WebserviceException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.joda.time.DateTime;

public class ChooseLabelsView
implements TasksSubmittedNotify {
    private ServiceClient client;
    private LabelInfoTableModel model;
    private JTable table;
    private JDialog dialog;
    private TemplateModel templateModel;

    public ChooseLabelsView(JFrame parent, ServiceAddress serviceAddress, TemplateModel templateModel) throws InitializationException {
        this.templateModel = templateModel;
        this.client = new ServiceClient(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL());
        this.client.setCredentials("admin", "admin");
        try {
            this.client.queryServiceStatus();
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
        try {
            Collection<LabelInfo> labelInfos = this.queryLabelInfos();
            this.model = new LabelInfoTableModel(labelInfos);
            this.table = new JTable(this.model);
            this.table.setAutoCreateRowSorter(true);
            this.table.setFillsViewportHeight(true);
            this.table.setDefaultRenderer(DateTime.class, (TableCellRenderer)new DateTimeTableCellRenderer());
            this.table.setDefaultRenderer(PowerStatus.class, (TableCellRenderer)new PowerStatusTableCellRenderer());
            this.table.setDefaultRenderer(LabelErrors.class, (TableCellRenderer)new LabelErrorsTableCellRenderer());
            this.table.setDefaultRenderer(SyncQuality.class, (TableCellRenderer)new SyncQualityTableCellRenderer());
            this.table.setDefaultRenderer(Status.class, (TableCellRenderer)new StatusTableCellRenderer());
            this.table.setDefaultRenderer(ConnectionStatus.class, (TableCellRenderer)new ConnectionStatusTableCellRenderer());
            this.table.setDefaultRenderer(LabelId.class, (TableCellRenderer)new LabelIdTableCellRenderer());
            this.table.setDefaultRenderer(UpdateError.class, (TableCellRenderer)new UpdateErrorTableCellRenderer());
            this.table.setDefaultRenderer(LabelType.class, (TableCellRenderer)new LabelTypeTableCellRenderer());
            JScrollPane labelScrollPane = new JScrollPane(this.table);
            LabelInfoFilter labelFilter = new LabelInfoFilter(this.model, this.table);
            this.dialog = new JDialog((Frame)parent, "Choose labels");
            this.dialog.setPreferredSize(new Dimension(1000, 600));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setLayout(new BorderLayout());
            this.dialog.setAlwaysOnTop(true);
            this.dialog.add((Component)labelScrollPane, "Center");
            JToolBar toolBar = new JToolBar();
            toolBar.setRollover(true);
            toolBar.setFloatable(false);
            JPanel refreshPanel = new JPanel(new FlowLayout(3));
            JButton refreshButton = new JButton(IconUtils.loadIcon("reload"));
            refreshButton.setMargin(new Insets(0, 0, 0, 0));
            refreshButton.setFocusable(false);
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseLabelsView.this.onRefreshButton();
                }
            });
            refreshPanel.add(refreshButton);
            toolBar.add(refreshPanel);
            toolBar.add(labelFilter.getFilterPanel());
            this.dialog.add((Component)toolBar, "First");
            JPanel bottomPanel = new JPanel(new FlowLayout());
            JButton sendImageButton = new JButton("Send image");
            sendImageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseLabelsView.this.onSendImageButton();
                }
            });
            bottomPanel.add(sendImageButton);
            this.dialog.add((Component)bottomPanel, "South");
            this.registerEscapeKeyAction();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(parent);
            this.dialog.setVisible(true);
        }
        catch (WebserviceException exc) {
            throw new InitializationException(exc);
        }
    }

    private Collection<LabelInfo> queryLabelInfos() throws WebserviceException {
        Collection labelInfos = this.client.queryLabelInfo();
        ArrayList<LabelInfo> filteredLabelInfos = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : labelInfos) {
            LabelType labelType = labelInfo.getLabelId().getLabelType();
            if (labelType.getDisplayHeight() != this.getImage().getHeight() || labelType.getDisplayWidth() != this.getImage().getWidth()) continue;
            filteredLabelInfos.add(labelInfo);
        }
        return filteredLabelInfos;
    }

    protected void onRefreshButton() {
        try {
            Collection<LabelInfo> labelInfos = this.queryLabelInfos();
            this.model.refresh(labelInfos);
        }
        catch (WebserviceException exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc), true);
        }
    }

    protected void onSendImageButton() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<LabelInfo> selectedLabels = new ArrayList<LabelInfo>();
        for (int index : selectedRows) {
            selectedLabels.add(this.model.getLabelInfo(this.table.convertRowIndexToModel(index)));
        }
        ArrayList<BinaryImageTask> taskList = new ArrayList<BinaryImageTask>();
        for (LabelInfo labelInfo : selectedLabels) {
            taskList.add(new BinaryImageTask(labelInfo.getLabelId(), TaskPriority.DEFAULT, 0L, true, this.getImage(), Page.DEFAULT, false));
        }
        TaskOrder taskOrder = new TaskOrder("Sent from template editor", 0L, taskList);
        try {
            this.client.sendTasks(taskOrder, (TasksSubmittedNotify)this);
        }
        catch (Exception exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc), true);
        }
    }

    private BufferedImage getImage() {
        return (BufferedImage)this.templateModel.getRenderedImage();
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseLabelsView.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void tasksSubmitted(Transaction transaction, int taskCount) {
        this.templateModel.addExecutionStatus(new StringElement(String.format("Submitted %d task(s)", taskCount), ExecutionStatusElement.ErrorLevel.INFO), true);
    }
}

