/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTextField;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class XSLTextFieldContainer
extends XSLTag {
    public static final String OPTION_CONTAINER_NAME = "";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Text Field Container";
    private List<XSLTextField> nestedTextFields = new ArrayList<XSLTextField>();

    public XSLTextFieldContainer(int fieldId, DesignTemplateModel templateModel) throws OptionException {
        super(fieldId, null, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[0]);
    }

    public void addTextField(Element textElement) throws OptionException {
        this.nestedTextFields.add(new XSLTextField(this.getFieldId(), textElement, this.getTemplateModel()));
        this.getOptions().addNode(this.nestedTextFields.get(this.nestedTextFields.size() - 1).getOptions());
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        for (XSLTextField textField : this.nestedTextFields) {
            textField.unregisterOptionsRecursively(changeset);
        }
    }

    @Override
    public void updateTemplateTreeNode(TemplateTreeNode templateTreeNode) throws TreeException, OptionException {
        this.nestedTextFields.get(0).updateTemplateTreeNode(templateTreeNode);
    }

    @Override
    protected void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        optionPath = optionPath.removeFirstElement();
        this.nestedTextFields.get(0).setOption(optionPath, value, changeset, complex);
    }

    @Override
    public boolean isComprehensible() {
        boolean comprehensible = true;
        for (XSLTextField textField : this.nestedTextFields) {
            if (textField.isComprehensible()) continue;
            comprehensible = false;
        }
        return comprehensible;
    }
}

