/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLListField;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTextOption;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLTextField
extends XSLTag {
    public static final String OPTION_CONTAINER_NAME = "textOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Text Field Options";
    public static final String TYPE = "text";
    private boolean comprehensible = true;
    private XSLListField listField = null;

    public XSLTextField(int fieldId, Element textElement, DesignTemplateModel templateModel) throws OptionException {
        super(fieldId, textElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.TEXT});
        NodeList orderedNodeList = textElement.getElementsByTagName("ol");
        NodeList unorderedNodeList = textElement.getElementsByTagName("ul");
        try {
            if (orderedNodeList.getLength() > 0) {
                this.listField = new XSLListField(this.getFieldId(), (Element)orderedNodeList.item(0), this.getTemplateModel(), textElement);
            } else if (unorderedNodeList.getLength() > 0) {
                this.listField = new XSLListField(this.getFieldId(), (Element)unorderedNodeList.item(0), this.getTemplateModel(), textElement);
            }
            if (this.listField != null) {
                this.getOptions().addNode(this.listField.getOptions());
            } else {
                this.parseTextContents();
            }
        }
        catch (Exception exc) {
            throw new OptionException(exc);
        }
    }

    @Override
    public void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        if (optionPath.getSize() != 1) {
            if (this.listField == null) {
                throw new OptionException("Can't set an option on this path: [" + optionPath.toString() + "]");
            }
            this.listField.setOption(optionPath, value, changeset, complex);
            return;
        }
        String optionKey = optionPath.getFirstElement();
        this.setOption(optionKey, value, changeset);
    }

    private void parseTextContents() throws OptionException {
        this.registerOption(TYPE, new XSLTextOption("", this.getXSLElement()));
    }

    @Override
    public boolean isComprehensible() {
        return this.comprehensible;
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }
}

