/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.Field;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.ImageXMLSerializer;
import at.mrdevelopment.esl.template.TemplateTree;
import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.TemplateAttributeParameter;
import at.mrdevelopment.esl.template.editor.common.TemplateCompletionProvider;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.OptionTreeNode;
import at.mrdevelopment.esl.template.editor.model.XSLAttributeOption;
import at.mrdevelopment.esl.template.editor.model.XSLEllipse;
import at.mrdevelopment.esl.template.editor.model.XSLField;
import at.mrdevelopment.esl.template.editor.model.XSLLine;
import at.mrdevelopment.esl.template.editor.model.XSLOption;
import at.mrdevelopment.esl.template.editor.model.XSLRect;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateElement;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateTreeNode;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import at.mrdevelopment.toolkit.tree.TreeNode;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLTemplate {
    static ESLLogger logger = ESLLogger.getLogger(XSLTemplate.class);
    public static final String OPTION_CONTAINER_NAME = "templateOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Template Options";
    protected static final int DEFAULT_WIDTH = 264;
    protected static final int DEFAULT_HEIGHT = 176;
    protected static final int DEFAULT_ROTATION = 0;
    private Element xslTemplateElement;
    private Element templateElement;
    private DesignTemplateModel templateModel;
    private int elementIDCounter = 0;
    private int fieldNumberCounter = 0;
    private Map<Integer, XSLTemplateElement> fields = new LinkedHashMap<Integer, XSLTemplateElement>();
    private TemplateCompletionProvider completionProvider = new TemplateCompletionProvider();
    private OptionTreeNode optionTreeNode;

    protected XSLTemplate(Element xslTemplateElement, DesignTemplateModel templateModel) throws SerializeException, OptionException, BarcodeException, TreeException, ImageRenderingException {
        this.xslTemplateElement = xslTemplateElement;
        this.templateModel = templateModel;
        this.templateElement = (Element)xslTemplateElement.getElementsByTagName("image").item(0);
        this.initOptions();
        try {
            this.parseFields(new File(templateModel.getXSLFileName()).getParentFile());
        }
        catch (InitializationException exc) {
            throw new SerializeException(exc);
        }
        catch (ConversionException exc) {
            throw new OptionException(exc);
        }
    }

    private int getWidth() {
        return Integer.valueOf(this.templateElement.getAttribute("width"));
    }

    private int getHeight() {
        return Integer.valueOf(this.templateElement.getAttribute("height"));
    }

    private Rectangle checkFieldBounds(Rectangle fieldBounds) {
        int imageHeight;
        int imageWidth = this.getWidth();
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight = this.getHeight());
        if (!imageBounds.contains(fieldBounds)) {
            return imageBounds;
        }
        return fieldBounds;
    }

    private void parseTemplateTree(List<XSLTemplateTreeNode> xslTreeNodes, XSLTemplateTreeNode xslTemplateTreeNode, TemplateTreeNode templateTreeNode, Element xslElement) throws OptionException, ConversionException, TreeException {
        XSLTemplateTreeNode currentNode = new XSLTemplateTreeNode(xslTemplateTreeNode, xslElement, templateTreeNode);
        if (xslTemplateTreeNode != null && templateTreeNode.getParent().getTemplateNode().getKey().equals(TemplateNode.ROOT_IMAGE.getKey())) {
            xslTreeNodes.add(currentNode);
        }
        if (xslTemplateTreeNode != null) {
            xslTemplateTreeNode.addChild(currentNode);
        }
        int childIndex = 0;
        block0: for (TemplateTreeNode childNode : templateTreeNode.getChilds()) {
            NodeList xslChildNodes = xslElement.getChildNodes();
            for (int index = childIndex; index < xslChildNodes.getLength(); ++index) {
                Node node = xslChildNodes.item(index);
                if (!node.getNodeName().equals(childNode.getNode().getNodeName()) || childNode.getTemplateNode().equals((Object)TemplateNode.PLAIN_TEXT)) continue;
                childIndex = index + 1;
                this.parseTemplateTree(xslTreeNodes, currentNode, childNode, (Element)node);
                continue block0;
            }
        }
    }

    public void update(TemplateTree templateTree) throws TreeException, OptionException {
        int elementIndex = 0;
        Object[] fieldArray = this.getFieldIds().toArray(new Integer[this.getFieldIds().size()]);
        Arrays.sort(fieldArray);
        for (TemplateTreeNode templateTreeNode : templateTree.getRoot().getChilds()) {
            if (!this.isSupportedTemplateTreeNode(templateTreeNode)) continue;
            elementIndex = this.update(templateTreeNode, elementIndex, (Integer[])fieldArray);
        }
    }

    private boolean isSupportedTemplateTreeNode(TemplateTreeNode templateTreeNode) {
        return templateTreeNode.getTemplateNode().getKey().equals(TemplateNode.FIELD.getKey()) || templateTreeNode.getTemplateNode().getKey().equals(TemplateNode.LINE.getKey()) || templateTreeNode.getTemplateNode().getKey().equals(TemplateNode.RECT.getKey()) || templateTreeNode.getTemplateNode().getKey().equals(TemplateNode.ELLIPSE.getKey()) || templateTreeNode.getTemplateNode().getKey().equals(TemplateNode.TEXT.getKey());
    }

    private int update(TemplateTreeNode templateTreeNode, int elementIndex, Integer[] fieldArray) throws TreeException, OptionException {
        this.getField(fieldArray[elementIndex]).updateTemplateTreeNode(templateTreeNode);
        for (TemplateTreeNode childNode : templateTreeNode.getChilds()) {
            if (!this.isSupportedTemplateTreeNode(childNode)) continue;
        }
        return ++elementIndex;
    }

    private void parseFields(File workingDirectory) throws OptionException, BarcodeException, TreeException, InitializationException, SerializeException, ConversionException, ImageRenderingException {
        ImageXMLSerializer templateXMLSerializer = new ImageXMLSerializer();
        DOMSource imageSource = templateXMLSerializer.transformTemplate((Source)this.templateModel.getXSLDOMSource(), (Source)this.templateModel.getRecordSource());
        ImageTemplate imageTemplate = templateXMLSerializer.parseImage(workingDirectory, imageSource);
        TemplateTreeNode root = imageTemplate.getTemplateTree().getRoot();
        ArrayList<XSLTemplateTreeNode> xslTreeNodes = new ArrayList<XSLTemplateTreeNode>();
        this.parseTemplateTree(xslTreeNodes, null, root, this.templateElement);
        for (XSLTemplateTreeNode xslTreeNode : xslTreeNodes) {
            if (xslTreeNode.getTemplateTreeNode().getTemplateNode().getKey().equals(TemplateNode.FIELD.getKey())) {
                XSLField xslField = new XSLField(xslTreeNode.getNodeElement(), this.elementIDCounter, this.templateModel, this.elementIDCounter);
                this.fields.put(new Integer(this.elementIDCounter), xslField);
                ++this.elementIDCounter;
                ++this.fieldNumberCounter;
                continue;
            }
            if (xslTreeNode.getTemplateTreeNode().getTemplateNode().getKey().equals(TemplateNode.RECT.getKey())) {
                XSLRect xslRect = new XSLRect(this.elementIDCounter, xslTreeNode.getNodeElement(), xslTreeNode.getTemplateTreeNode(), this.templateModel);
                this.fields.put(new Integer(this.elementIDCounter), xslRect);
                ++this.elementIDCounter;
                continue;
            }
            if (!xslTreeNode.getTemplateTreeNode().getTemplateNode().getKey().equals(TemplateNode.LINE.getKey())) continue;
            XSLLine xslLine = new XSLLine(this.elementIDCounter, xslTreeNode.getNodeElement(), xslTreeNode.getTemplateTreeNode(), this.templateModel);
            this.fields.put(new Integer(this.elementIDCounter), xslLine);
            ++this.elementIDCounter;
        }
    }

    private void initOptions() throws OptionException {
        this.optionTreeNode = new OptionTreeNode(OPTION_CONTAINER_NAME, null, OPTION_CONTAINER_PRINT_NAME);
        for (Attribute attribute : TemplateNode.ROOT_IMAGE.getAttributeList()) {
            try {
                this.registerOption(attribute.createOption());
            }
            catch (Exception exc) {
                throw new OptionException(exc);
            }
        }
    }

    public void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        String optionKey = optionPath.getFirstElement();
        TreeNode nodeToSet = this.optionTreeNode.getNode(optionKey);
        String oldValue = ((DisplayableOption)nodeToSet.getNodeElement()).getValue();
        ((XSLOption)nodeToSet.getNodeElement()).setValue(value);
        changeset.addChange(-1, TemplateNode.ROOT_IMAGE, nodeToSet.getNodePath(), oldValue, value);
    }

    private void registerOption(Option<?> option) throws OptionException {
        this.optionTreeNode.addNode(new OptionTreeNode(option.getKey(), new XSLAttributeOption(option, this.templateElement, this.getToolTipText(option)), option.getKey()));
    }

    private String getToolTipText(Option<?> option) {
        for (Completion completion : this.completionProvider.getCompletions()) {
            if (!(completion instanceof MarkupTagCompletion)) continue;
            MarkupTagCompletion tagCompletion = (MarkupTagCompletion)completion;
            TemplateNode templateNode = TemplateNode.ROOT_IMAGE;
            if (!tagCompletion.getName().equals(templateNode.getKey())) continue;
            for (Object object : tagCompletion.getAttributes()) {
                TemplateAttributeParameter attribute;
                if (!(object instanceof TemplateAttributeParameter) || !(attribute = (TemplateAttributeParameter)object).getName().equals(option.getKey())) continue;
                return "<html>" + attribute.getDescription() + "</html>";
            }
        }
        return null;
    }

    public TreeNode<DisplayableOption, String> getTemplateOptions() {
        return this.optionTreeNode;
    }

    protected int addBarcodeField(Changeset changeset, Shape fieldBounds) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Barcode Field");
        return this.addField(this.createBarcodeFieldElement(fieldBounds));
    }

    protected int addBarcodeField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Barcode Field with ID " + fieldId);
        return this.addField(fieldId, tagElement);
    }

    protected void removeField(int fieldId, Changeset changeset) throws OptionException, TreeException {
        XSLTemplateElement field = this.getField(fieldId);
        field.unregisterOptionsRecursively(changeset);
        this.templateElement.removeChild(field.getXSLElement());
        this.fields.remove(fieldId);
    }

    protected int addTextField(Changeset changeset, Shape fieldBounds) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Text Field");
        return this.addField(this.createTextFieldElement(fieldBounds));
    }

    protected int addTextField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Text Field with ID " + fieldId);
        return this.addField(fieldId, tagElement);
    }

    public int addListField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding List Field with ID " + fieldId);
        return this.addField(fieldId, tagElement);
    }

    public int addListField(Changeset changeset, Shape fieldBounds) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding List Field");
        return this.addField(this.createListFieldElement(fieldBounds));
    }

    protected int addImageField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Image Field with ID " + fieldId);
        return this.addField(fieldId, tagElement);
    }

    protected int addImageField(Changeset changeset, Shape fieldBounds) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Image Field");
        return this.addField(this.createImageFieldElement(fieldBounds));
    }

    public int addImageFieldWithData(String base64String, Rectangle fieldBounds) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Image Field with data");
        return this.addField(this.createImageFieldElementWithData(base64String, this.checkFieldBounds(fieldBounds)));
    }

    public int addImageFieldWithSrc(String relativePath, Rectangle fieldBounds) throws OptionException, BarcodeException, TreeException {
        logger.debug("XSLTemplate.java: Adding Image Field with src");
        return this.addField(this.createImageFieldElementWithSrc(relativePath, this.checkFieldBounds(fieldBounds)));
    }

    public int addLineField(Changeset changeset, Shape fieldBounds) throws OptionException, TreeException, ConversionException {
        logger.debug("XSLTemplate.java: Adding Line Field");
        return this.addLine(this.createLineFieldElement(fieldBounds));
    }

    public int addLineField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, TreeException, ConversionException {
        logger.debug("XSLTemplate.java: Adding Line Field");
        return this.addLine(fieldId, tagElement);
    }

    public int addRectField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, TreeException, ConversionException {
        logger.debug("XSLTemplate.java: Adding Rect Field");
        return this.addRect(fieldId, tagElement);
    }

    public int addRectField(Changeset changeset, Shape fieldBounds) throws OptionException, TreeException, ConversionException {
        logger.debug("XSLTemplate.java: Adding Rect Field");
        return this.addRect(this.createRectFieldElement(fieldBounds));
    }

    public int addEllipseField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) throws OptionException, TreeException, ConversionException {
        logger.debug("XSLTemplate.java: Adding Ellipse Field");
        return this.addEllipse(fieldId, tagElement);
    }

    public int addEllipseField(Changeset changeset, Shape fieldBounds) throws OptionException, TreeException, ConversionException {
        logger.debug("XSLTemplate.java: Adding Ellipse Field");
        return this.addEllipse(this.createEllipseFieldElement(fieldBounds));
    }

    private Element createImageFieldElementWithData(String base64String, Rectangle fieldBounds) {
        Element fieldElement = this.templateElement.getOwnerDocument().createElement("field");
        this.templateElement.appendChild(fieldElement);
        fieldElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        fieldElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        fieldElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        fieldElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        Element imageElement = fieldElement.getOwnerDocument().createElement("img");
        fieldElement.appendChild(imageElement);
        imageElement.setAttribute("data", base64String);
        return fieldElement;
    }

    private Element createImageFieldElementWithSrc(String relativePath, Rectangle fieldBounds) {
        Element fieldElement = this.templateElement.getOwnerDocument().createElement("field");
        this.templateElement.appendChild(fieldElement);
        fieldElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        fieldElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        fieldElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        fieldElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        Element imageElement = fieldElement.getOwnerDocument().createElement("img");
        fieldElement.appendChild(imageElement);
        imageElement.setAttribute("src", relativePath);
        return fieldElement;
    }

    private Element createEllipseFieldElement(Shape fieldBounds) {
        Element ellipseElement = this.templateElement.getOwnerDocument().createElement("ellipse");
        this.templateElement.appendChild(ellipseElement);
        ellipseElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        ellipseElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        ellipseElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        ellipseElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        return ellipseElement;
    }

    private Element createRectFieldElement(Shape fieldBounds) {
        Element rectElement = this.templateElement.getOwnerDocument().createElement("rect");
        this.templateElement.appendChild(rectElement);
        rectElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        rectElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        rectElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        rectElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        return rectElement;
    }

    private Element createLineFieldElement(Shape fieldBounds) throws OptionException {
        Element lineElement = this.templateElement.getOwnerDocument().createElement("line");
        this.templateElement.appendChild(lineElement);
        if (!(fieldBounds instanceof Line2D)) {
            throw new OptionException(String.format("Cannot set bounds: Expected Line2D shape and not %s", fieldBounds.getClass().getSimpleName()));
        }
        Line2D line2d = (Line2D)fieldBounds;
        lineElement.setAttribute("x-from", String.valueOf((int)line2d.getX1()));
        lineElement.setAttribute("y-from", String.valueOf((int)line2d.getY1()));
        lineElement.setAttribute("x-to", String.valueOf((int)line2d.getX2()));
        lineElement.setAttribute("y-to", String.valueOf((int)line2d.getY2()));
        lineElement.setAttribute("thickness", "1");
        return lineElement;
    }

    private Element createImageFieldElement(Shape fieldBounds) {
        Element fieldElement = this.templateElement.getOwnerDocument().createElement("field");
        this.templateElement.appendChild(fieldElement);
        fieldElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        fieldElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        fieldElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        fieldElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        Element imageElement = fieldElement.getOwnerDocument().createElement("img");
        fieldElement.appendChild(imageElement);
        imageElement.setAttribute("data", XSLTemplate.createBase64DummyImage(fieldBounds.getBounds().width, fieldBounds.getBounds().height));
        return fieldElement;
    }

    public static String createBase64DummyImage(int width, int height) {
        try {
            BufferedImage dummyImage = ImageUtils.createImage(width, height, 2);
            ImageUtils.drawBorder(dummyImage, 0, 0, width, height, Color.BLACK, new BasicStroke(2.0f));
            return ImageSerializer.toBase64String(dummyImage);
        }
        catch (SerializeException exc) {
            return "";
        }
    }

    private Element createBarcodeFieldElement(Shape fieldBounds) {
        Element fieldElement = this.templateElement.getOwnerDocument().createElement("field");
        this.templateElement.appendChild(fieldElement);
        fieldElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        fieldElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        fieldElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        fieldElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        Element barcodeElement = fieldElement.getOwnerDocument().createElement("barcode");
        fieldElement.appendChild(barcodeElement);
        barcodeElement.setAttribute("type", "ean13");
        return fieldElement;
    }

    private Element createTextFieldElement(Shape fieldBounds) {
        Element fieldElement = this.templateElement.getOwnerDocument().createElement("field");
        this.templateElement.appendChild(fieldElement);
        fieldElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        fieldElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        fieldElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        fieldElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        Element textElement = fieldElement.getOwnerDocument().createElement("text");
        fieldElement.appendChild(textElement);
        textElement.appendChild(this.templateElement.getOwnerDocument().createTextNode(""));
        return fieldElement;
    }

    private Element createListFieldElement(Shape fieldBounds) {
        Element fieldElement = this.templateElement.getOwnerDocument().createElement("field");
        this.templateElement.appendChild(fieldElement);
        fieldElement.setAttribute("x", String.valueOf(fieldBounds.getBounds().x));
        fieldElement.setAttribute("y", String.valueOf(fieldBounds.getBounds().y));
        fieldElement.setAttribute("width", String.valueOf(fieldBounds.getBounds().width));
        fieldElement.setAttribute("height", String.valueOf(fieldBounds.getBounds().height));
        Element textElement = fieldElement.getOwnerDocument().createElement("text");
        Element listElement = fieldElement.getOwnerDocument().createElement("ul");
        Element listElementElement = fieldElement.getOwnerDocument().createElement("li");
        listElementElement.appendChild(this.templateElement.getOwnerDocument().createTextNode(""));
        listElement.appendChild(listElementElement);
        textElement.appendChild(listElement);
        fieldElement.appendChild(textElement);
        return fieldElement;
    }

    public Collection<Integer> getFieldIds() {
        return this.fields.keySet();
    }

    protected XSLTemplateElement getField(int fieldId) {
        return this.fields.get(fieldId);
    }

    public boolean isTwoPointBorder(int fieldId) {
        return this.fields.get(fieldId) instanceof XSLLine;
    }

    public Shape getFieldBounds(int fieldId) {
        return this.fields.get(fieldId).getBounds();
    }

    public TreeNode<DisplayableOption, String> getFieldOptions(int fieldId) {
        return this.fields.get(fieldId).getOptions();
    }

    public DOMSource getDOMSource() {
        return new DOMSource(this.xslTemplateElement.getOwnerDocument().cloneNode(true));
    }

    public Element getRoot() {
        return this.xslTemplateElement;
    }

    private int addField(Element fieldElement) throws OptionException, BarcodeException, TreeException {
        int fieldId = this.elementIDCounter++;
        this.addField(fieldId, fieldElement);
        ++this.fieldNumberCounter;
        return fieldId;
    }

    private int addField(int fieldId, Element fieldElement) throws OptionException, BarcodeException, TreeException {
        XSLField field = new XSLField(fieldElement, fieldId, this.templateModel, this.fieldNumberCounter);
        this.fields.put(fieldId, field);
        return fieldId;
    }

    private int addLine(Element lineElement) throws OptionException, TreeException, ConversionException {
        int fieldId = this.elementIDCounter++;
        this.addLine(fieldId, lineElement);
        return fieldId;
    }

    private int addLine(int fieldId, Element lineElement) throws OptionException, TreeException, ConversionException {
        XSLLine xslLine = new XSLLine(fieldId, lineElement, null, this.templateModel);
        this.fields.put(fieldId, xslLine);
        return fieldId;
    }

    private int addRect(Element rectElement) throws OptionException, TreeException, ConversionException {
        int fieldId = this.elementIDCounter++;
        this.addRect(fieldId, rectElement);
        return fieldId;
    }

    private int addRect(int fieldId, Element rectElement) throws OptionException, TreeException, ConversionException {
        XSLRect xslRect = new XSLRect(fieldId, rectElement, null, this.templateModel);
        this.fields.put(fieldId, xslRect);
        return fieldId;
    }

    private int addEllipse(Element ellipseElement) throws OptionException, TreeException, ConversionException {
        int fieldId = this.elementIDCounter++;
        this.addEllipse(fieldId, ellipseElement);
        return fieldId;
    }

    private int addEllipse(int fieldId, Element ellipseElement) throws OptionException, TreeException, ConversionException {
        XSLEllipse xslRect = new XSLEllipse(fieldId, ellipseElement, null, this.templateModel);
        this.fields.put(fieldId, xslRect);
        return fieldId;
    }

    public void setRelativePostitionsFromTemplate(ImageTemplate imageTemplate) {
        for (Integer index : this.fields.keySet()) {
            XSLField field;
            if (!(this.fields.get(index) instanceof XSLField) || !(field = (XSLField)this.fields.get(index)).hasRelativeY()) continue;
            field.setRelativeY(((Field)imageTemplate.getFields().get(field.getFieldNumber())).getPosY());
        }
    }

    public Rectangle getTemplateBounds() throws OptionException {
        try {
            int width = Integer.valueOf(((DisplayableOption)this.optionTreeNode.getNode("width").getNodeElement()).getValue());
            int height = Integer.valueOf(((DisplayableOption)this.optionTreeNode.getNode("height").getNodeElement()).getValue());
            return new Rectangle(width, height);
        }
        catch (NumberFormatException exc) {
            throw new OptionException(exc);
        }
        catch (TreeException exc) {
            throw new OptionException(exc);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elementIDCounter;
        result = 31 * result + (this.fields == null ? 0 : ((Object)this.fields).hashCode());
        result = 31 * result + (this.templateElement == null ? 0 : this.templateElement.hashCode());
        result = 31 * result + (this.templateModel == null ? 0 : this.templateModel.hashCode());
        result = 31 * result + (this.xslTemplateElement == null ? 0 : this.xslTemplateElement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSLTemplate other = (XSLTemplate)obj;
        if (this.elementIDCounter != other.elementIDCounter) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !((Object)this.fields).equals(other.fields)) {
            return false;
        }
        if (this.templateElement == null ? other.templateElement != null : !this.templateElement.equals(other.templateElement)) {
            return false;
        }
        if (this.templateModel == null ? other.templateModel != null : !this.templateModel.equals(other.templateModel)) {
            return false;
        }
        return !(this.xslTemplateElement == null ? other.xslTemplateElement != null : !this.xslTemplateElement.equals(other.xslTemplateElement));
    }

    public String toString() {
        return "XSLTemplate [xslTemplateElement=" + this.xslTemplateElement + ", templateElement=" + this.templateElement + ", templateModel=" + this.templateModel + ", fieldIDCounter=" + this.elementIDCounter + ", fields=" + this.fields + ", optionTreeNode=" + this.optionTreeNode + "]";
    }

    public void setBounds(int fieldId, Shape shape, Changeset changeset) throws OptionException, TreeException {
        XSLTemplateElement field = this.getField(fieldId);
        if (field.checkBounds(shape)) {
            field.setBounds(shape, changeset);
        }
    }
}

