/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.TemplateAttributeParameter;
import at.mrdevelopment.esl.template.editor.common.TemplateCompletionProvider;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.OptionTreeNode;
import at.mrdevelopment.esl.template.editor.model.XSLAttributeOption;
import at.mrdevelopment.esl.template.editor.model.XSLOption;
import at.mrdevelopment.esl.template.editor.model.XSLTextOption;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionContainer;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import at.mrdevelopment.toolkit.tree.TreeNode;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.w3c.dom.Element;

public abstract class XSLTag {
    public static final String CHOICE_NONE = "None";
    private int fieldId;
    private Element tagElement;
    private DesignTemplateModel templateModel;
    private OptionTreeNode optionTreeNode;
    private final TemplateNode[] templateNodes;
    private final List<Option<?>> defaultOptions;
    private List<Option<?>> optionList;
    private TemplateTreeNode templateTreeNode;
    private TemplateCompletionProvider completionProvider = new TemplateCompletionProvider();

    public XSLTag(int fieldId, Element tagElement, DesignTemplateModel templateModel, String optionContainerName, String optionContainerPrintName, TemplateNode[] templateNodes) throws OptionException {
        this.fieldId = fieldId;
        this.tagElement = tagElement;
        this.templateModel = templateModel;
        this.templateNodes = templateNodes;
        this.optionList = new ArrayList();
        this.optionTreeNode = new OptionTreeNode(optionContainerName, null, optionContainerPrintName);
        this.defaultOptions = this.getDefaultOptions();
        for (Option<?> option : this.defaultOptions) {
            this.registerOption(option);
        }
    }

    public List<Option<?>> getOptionList() {
        return this.optionList;
    }

    public Element getTagElement() {
        return this.tagElement;
    }

    public void updateTemplateTreeNode(TemplateTreeNode templateTreeNode) throws TreeException, OptionException {
        this.templateTreeNode = templateTreeNode;
        if (templateTreeNode != null) {
            for (Option option : templateTreeNode.getOptions().values()) {
                try {
                    TreeNode node = this.optionTreeNode.getNode(option.getKey());
                    if (node == null || !(node.getNodeElement() instanceof XSLOption)) continue;
                    XSLOption xslOption = (XSLOption)node.getNodeElement();
                    xslOption.setInheritatedOption(option);
                }
                catch (TreeException exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    protected List<Option<?>> getDefaultOptions() throws OptionException {
        if (this.defaultOptions == null) {
            ArrayList optionList = new ArrayList();
            for (TemplateNode templateNode : this.templateNodes) {
                for (Attribute attribute : templateNode.getAttributeList()) {
                    try {
                        optionList.add(attribute.createOption());
                    }
                    catch (Exception exc) {
                        throw new OptionException(exc);
                    }
                }
            }
            return optionList;
        }
        return this.defaultOptions;
    }

    protected void unregisterOption(Option<?> option) throws TreeException, OptionException {
        this.unregisterOption(option, option.getKey(), new Changeset());
    }

    protected void unregisterOption(Option<?> option, Changeset changeset) throws TreeException, OptionException {
        this.unregisterOption(option, option.getKey(), changeset);
    }

    protected void unregisterOption(Option<?> option, String key, Changeset changeset) throws TreeException, OptionException {
        TreeNode optionNode = this.optionTreeNode.getNode(key);
        Path optionPath = optionNode.getNodePath();
        String oldValue = option.getValueAsString();
        String newValue = null;
        changeset.addChange(this.getFieldId(), this.templateNodes.length > 0 ? this.templateNodes[0] : null, optionPath, oldValue, newValue);
        option.set(null);
        this.optionTreeNode.removeNode(key);
    }

    protected void unregisterOptions(List<Option<?>> optionList, Changeset changeset) throws OptionException, TreeException {
        for (Option<?> option : optionList) {
            this.unregisterOption(option, changeset);
        }
        optionList.clear();
    }

    protected void unregisterOptions(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(this.optionList, changeset);
    }

    protected abstract void unregisterOptionsRecursively(Changeset var1) throws OptionException, TreeException;

    public void registerOption(Option<?> option) throws OptionException {
        this.registerOption(option, this.tagElement, option.getKey());
    }

    protected void registerOption(Option<?> option, Element element, String attributeKey) throws OptionException {
        this.optionTreeNode.addNode(new OptionTreeNode(option.getKey(), new XSLAttributeOption(option, element, this.getToolTipText(option)), option.getKey()));
        this.optionList.add(option);
    }

    private String getToolTipText(Option<?> option) {
        for (Completion completion : this.completionProvider.getCompletions()) {
            if (!(completion instanceof MarkupTagCompletion)) continue;
            MarkupTagCompletion tagCompletion = (MarkupTagCompletion)completion;
            for (TemplateNode templateNode : this.templateNodes) {
                if (!tagCompletion.getName().equals(templateNode.getKey())) continue;
                for (Object object : tagCompletion.getAttributes()) {
                    TemplateAttributeParameter attribute;
                    if (!(object instanceof TemplateAttributeParameter) || !(attribute = (TemplateAttributeParameter)object).getName().equals(option.getKey())) continue;
                    return "<html>" + attribute.getDescription() + "</html>";
                }
            }
        }
        return null;
    }

    protected void registerOption(String optionKey, XSLTextOption textOption) throws OptionException {
        this.optionTreeNode.addNode(new OptionTreeNode(optionKey, textOption, optionKey));
        this.optionList.add(textOption.getOption());
    }

    protected void registerOptions(OptionContainer optionContainer) throws OptionException {
        for (Option<?> option : optionContainer.getOptions()) {
            this.registerOption(option);
        }
    }

    public int getFieldId() {
        return this.fieldId;
    }

    protected Element getXSLElement() {
        return this.tagElement;
    }

    protected Element getImageSourceElement() {
        return this.templateTreeNode != null ? (Element)this.templateTreeNode.getNode() : null;
    }

    protected TemplateTreeNode getTemplateTreeNode() {
        return this.templateTreeNode;
    }

    protected void setOption(String optionKey, String value, Changeset changeset) throws TreeException, OptionException {
        TreeNode nodeToSet = this.optionTreeNode.getNode(optionKey);
        String oldValue = ((DisplayableOption)nodeToSet.getNodeElement()).getValue();
        ((XSLOption)nodeToSet.getNodeElement()).setValue(value);
        changeset.addChange(this.fieldId, this.templateNodes.length > 0 ? this.templateNodes[0] : null, nodeToSet.getNodePath(), oldValue, value);
    }

    protected DesignTemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public OptionTreeNode getOptions() {
        return this.optionTreeNode;
    }

    public String getOptionValue(String key) throws TreeException {
        return ((DisplayableOption)this.optionTreeNode.getNode(key).getNodeElement()).getValue();
    }

    public boolean hasOption(String key) {
        return this.optionTreeNode.hasNode(key);
    }

    protected abstract void setOption(Path var1, String var2, Changeset var3, boolean var4) throws OptionException, TreeException;

    public abstract boolean isComprehensible();
}

