/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.awt.Rectangle;
import java.awt.Shape;
import org.w3c.dom.Element;

public class XSLRect
extends XSLTemplateElement {
    static ESLLogger logger = ESLLogger.getLogger(XSLRect.class);
    public static final String OPTION_CONTAINER_NAME = "rectOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Rect Options";

    public XSLRect(int fieldId, Element tagElement, TemplateTreeNode templateTreeNode, DesignTemplateModel templateModel) throws OptionException, ConversionException, TreeException {
        super(fieldId, tagElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.RECT});
        this.updateTemplateTreeNode(templateTreeNode);
    }

    @Override
    public Shape getBounds() {
        Element currentElement = this.getImageSourceElement() != null ? this.getImageSourceElement() : this.getXSLElement();
        try {
            int x = Integer.valueOf(currentElement.getAttribute(Attribute.X.getKey()));
            int y = Integer.valueOf(currentElement.getAttribute(Attribute.Y.getKey()));
            int width = Integer.valueOf(currentElement.getAttribute(Attribute.WIDTH.getKey()));
            int height = Integer.valueOf(currentElement.getAttribute(Attribute.HEIGHT.getKey()));
            Rectangle bounds = new Rectangle(x, y, width, height);
            return bounds;
        }
        catch (NumberFormatException exc) {
            logger.warn("Rect value is not an integer: %s", exc.getMessage());
            return null;
        }
    }

    @Override
    public boolean checkBounds(Shape shape) throws OptionException {
        return shape.getBounds().x >= 0 && shape.getBounds().y >= 0 && shape.getBounds().width > 0 && shape.getBounds().height > 0;
    }

    @Override
    public void setBounds(Shape shape, Changeset changeset) throws TreeException, OptionException {
        this.setOption("x", String.valueOf(shape.getBounds().x), changeset);
        this.setOption("y", String.valueOf(shape.getBounds().y), changeset);
        this.setOption("width", String.valueOf(shape.getBounds().width), changeset);
        this.setOption("height", String.valueOf(shape.getBounds().height), changeset);
    }

    @Override
    public FieldType getNestedFieldType() {
        return FieldType.RECT;
    }

    @Override
    public XSLTag getNestedField() {
        return null;
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }

    @Override
    protected void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        if (optionPath.getSize() != 1) {
            throw new OptionException("Can't set an option on this path: [" + optionPath.toString() + "]");
        }
        String optionKey = optionPath.getFirstElement();
        this.setOption(optionKey, value, changeset);
    }

    @Override
    public boolean isComprehensible() {
        return true;
    }
}

