/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.optionvalue.XSLOptionValue;
import java.util.List;
import org.w3c.dom.Element;

public abstract class XSLOption
implements DisplayableOption {
    private Option<?> option;
    private final Element element;
    private final XSLOptionValue<?> optionValue;
    private Option<?> inheritatedOption;

    public XSLOption(Option<?> option, Element element) throws OptionException {
        this.option = option;
        this.element = element;
        try {
            this.optionValue = this.createOptionValue(option, element);
        }
        catch (Exception exc) {
            throw new OptionException(exc);
        }
    }

    protected abstract XSLOptionValue<?> createOptionValue(Option<?> var1, Element var2) throws OptionException;

    @Override
    public String getValue() {
        String value = null;
        value = this.optionValue.getValueAsString();
        if (value != null) {
            return value.toString();
        }
        try {
            value = this.option.getDefaultValueAsString();
            if (this.inheritatedOption != null && this.inheritatedOption.getValueAsString() != null && !this.inheritatedOption.getValueAsString().equals(value)) {
                value = this.inheritatedOption.getValueAsString();
            }
        }
        catch (OptionException e1) {
            e1.printStackTrace();
        }
        return value != null ? value.toString() : "";
    }

    @Override
    public String getOptionType() {
        return this.getOption().getClass().getSimpleName();
    }

    @Override
    public List<String> getChoices() {
        return this.getOption().getChoices();
    }

    public Option<?> getOption() {
        return this.option;
    }

    public Element getElement() {
        return this.element;
    }

    public void setValue(String newValue) throws OptionException {
        this.optionValue.setValueFromString(newValue);
    }

    public void setInheritatedOption(Option<?> inheritatedOption) throws OptionException {
        this.inheritatedOption = inheritatedOption;
        this.optionValue.setInheritatedValue(inheritatedOption.getValueAsString());
    }
}

