/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLListElementField;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.StringChoiceOption;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLListField
extends XSLTag {
    public static final String OPTION_CONTAINER_NAME = "listOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "List Options";
    public static final String TYPE_ORDERED = "ol";
    public static final String TYPE_UNORDERED = "ul";
    public static final String TYPE_IDENTIFIER = "list-type";
    private Map<Integer, XSLListElementField> childs = new HashMap<Integer, XSLListElementField>();
    private String listType;

    public XSLListField(int fieldId, Element listElement, DesignTemplateModel templateModel, Element textElement) throws OptionException, BarcodeException, TreeException {
        super(fieldId, listElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.UL, TemplateNode.OL});
        this.listType = listElement.getNodeName();
        ArrayList<String> listTypes = new ArrayList<String>();
        listTypes.add(TYPE_UNORDERED);
        listTypes.add(TYPE_ORDERED);
        this.registerOption(new StringChoiceOption(TYPE_IDENTIFIER, TYPE_UNORDERED, listTypes));
        this.initChilds();
    }

    private void initChilds() throws OptionException {
        NodeList listElements = this.getTagElement().getElementsByTagName("li");
        if (listElements.getLength() > 0) {
            for (int index = 0; index < listElements.getLength(); ++index) {
                Element listElement = (Element)listElements.item(index);
                XSLListElementField listElementField = new XSLListElementField(index, this, this.getFieldId(), listElement, this.getTemplateModel());
                this.childs.put(listElementField.getChildId(), listElementField);
                this.getOptions().addNode(listElementField.getOptions());
            }
        }
    }

    @Override
    public void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        String optionKey = optionPath.getLastElement();
        if (optionPath.getSize() == 3) {
            optionKey = optionPath.getLastElement();
            this.childs.get(0).setOption(optionKey, value, changeset);
        } else if (optionPath.getSize() == 2) {
            if (complex && optionKey.equals(TYPE_IDENTIFIER)) {
                if (!value.equals(TYPE_ORDERED) && !value.equals(TYPE_UNORDERED)) {
                    throw new OptionException(String.format("Unrecognized list type %s", value));
                }
                this.changeListType(value);
                return;
            }
            this.setOption(optionKey, value, changeset);
        }
    }

    private void changeListType(String value) {
        if (!this.listType.equals(value)) {
            this.getTagElement().getOwnerDocument().renameNode(this.getTagElement(), null, value);
            this.listType = value;
        }
    }

    @Override
    public boolean isComprehensible() {
        return true;
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }
}

