/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLListField;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTextOption;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import org.w3c.dom.Element;

public class XSLListElementField
extends XSLTag {
    public static final String OPTION_CONTAINER_NAME = "listElementOptions%d";
    public static final String OPTION_CONTAINER_PRINT_NAME = "List Element %d";
    public static final String TYPE = "LI";
    private boolean comprehensible = true;
    private int childId;

    public XSLListElementField(int childId, XSLListField listField, int fieldId, Element listElement, DesignTemplateModel templateModel) throws OptionException {
        super(fieldId, listElement, templateModel, String.format(OPTION_CONTAINER_NAME, childId), String.format(OPTION_CONTAINER_PRINT_NAME, childId), new TemplateNode[]{TemplateNode.LI});
        this.childId = childId;
        this.parseTextContents();
    }

    public int getChildId() {
        return this.childId;
    }

    @Override
    public void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        if (optionPath.getSize() != 1) {
            throw new OptionException("Can't set an option on this path: [" + optionPath.toString() + "]");
        }
        String optionKey = optionPath.getFirstElement();
        this.setOption(optionKey, value, changeset);
    }

    private void parseTextContents() throws OptionException {
        this.registerOption("text", new XSLTextOption("", this.getXSLElement()));
    }

    @Override
    public boolean isComprehensible() {
        return this.comprehensible;
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }
}

