/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;

public class XSLLine
extends XSLTemplateElement {
    static ESLLogger logger = ESLLogger.getLogger(XSLLine.class);
    public static final String OPTION_CONTAINER_NAME = "lineOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Line Options";
    private static final String KEY_X_FROM = "x-from";
    private static final String KEY_Y_FROM = "y-from";
    private static final String KEY_X_TO = "x-to";
    private static final String KEY_Y_TO = "y-to";

    public XSLLine(int fieldId, Element tagElement, TemplateTreeNode templateTreeNode, DesignTemplateModel templateModel) throws OptionException, ConversionException, TreeException {
        super(fieldId, tagElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.LINE});
        this.updateTemplateTreeNode(templateTreeNode);
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }

    @Override
    protected void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        if (optionPath.getSize() != 1) {
            throw new OptionException("Can't set an option on this path: [" + optionPath.toString() + "]");
        }
        String optionKey = optionPath.getFirstElement();
        this.setOption(optionKey, value, changeset);
    }

    @Override
    public boolean isComprehensible() {
        return true;
    }

    @Override
    public Shape getBounds() {
        Element currentElement = this.getImageSourceElement() != null ? this.getImageSourceElement() : this.getXSLElement();
        int xFrom = Integer.valueOf(currentElement.getAttribute(Attribute.X_FROM.getKey()));
        int yFrom = Integer.valueOf(currentElement.getAttribute(Attribute.Y_FROM.getKey()));
        int xTo = Integer.valueOf(currentElement.getAttribute(Attribute.X_TO.getKey()));
        int yTo = Integer.valueOf(currentElement.getAttribute(Attribute.Y_TO.getKey()));
        Line2D.Double bounds = new Line2D.Double(xFrom, yFrom, xTo, yTo);
        return bounds;
    }

    @Override
    public boolean checkBounds(Shape shape) throws OptionException {
        if (shape instanceof Line2D) {
            Line2D line2d = (Line2D)shape;
            return line2d.getX1() >= 0.0 && line2d.getX2() >= 0.0 && line2d.getY1() >= 0.0 && line2d.getY2() >= 0.0;
        }
        return false;
    }

    @Override
    public void setBounds(Shape shape, Changeset changeset) throws TreeException, OptionException {
        if (!(shape instanceof Line2D)) {
            throw new OptionException(String.format("Cannot set bounds: Expected Line2D shape and not %s", shape.getClass().getSimpleName()));
        }
        Line2D line2d = (Line2D)shape;
        this.setOption(KEY_X_FROM, String.valueOf((int)line2d.getX1()), changeset);
        this.setOption(KEY_Y_FROM, String.valueOf((int)line2d.getY1()), changeset);
        this.setOption(KEY_X_TO, String.valueOf((int)line2d.getX2()), changeset);
        this.setOption(KEY_Y_TO, String.valueOf((int)line2d.getY2()), changeset);
    }

    @Override
    public FieldType getNestedFieldType() {
        return FieldType.LINE;
    }

    @Override
    public XSLTag getNestedField() {
        return null;
    }
}

