/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTemplate;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import org.w3c.dom.Element;

public class XSLImageField
extends XSLTag {
    public static final String OPTION_CONTAINER_NAME = "imageOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Image Options";
    public static final String TYPE = "img";

    public XSLImageField(int fieldId, Element imageElement, DesignTemplateModel templateModel) throws OptionException, TreeException {
        super(fieldId, imageElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.IMAGE});
    }

    @Override
    public void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        if (optionPath.getSize() != 1) {
            throw new OptionException("Can't set an option on this path: [" + optionPath.toString() + "]");
        }
        String optionKey = optionPath.getFirstElement();
        try {
            if (complex) {
                if (optionKey.equals("src")) {
                    this.checkSource(value);
                    this.setSource(value, changeset);
                    return;
                }
                if (optionKey.equals("data")) {
                    this.checkData(value);
                    this.setData(value, changeset);
                    return;
                }
            }
        }
        catch (OptionException exc) {
            String src = null;
            String data = null;
            try {
                src = this.getOptionValue("src");
            }
            catch (TreeException ignore) {
                // empty catch block
            }
            try {
                data = this.getOptionValue("data");
            }
            catch (TreeException ignore) {
                // empty catch block
            }
            if (src == null || src.isEmpty() || data == null || data.isEmpty()) {
                this.setOption("data", XSLTemplate.createBase64DummyImage(1, 1), new Changeset());
            }
            throw exc;
        }
        this.setOption(optionKey, value, changeset);
    }

    private void checkData(String value) throws OptionException {
        try {
            ImageSerializer.fromBase64String(value);
        }
        catch (SerializeException exc) {
            throw new OptionException(String.format("Invalid image: %s", exc.getMessage()), exc);
        }
    }

    private void checkSource(String value) throws OptionException {
        try {
            ImageUtils.loadImageSource(this.getTemplateModel().getWorkingDirectory(), value);
        }
        catch (Exception exc) {
            throw new OptionException(String.format("Could not load image from file %s: %s", value, exc.getMessage()), exc);
        }
    }

    private void setData(String value, Changeset changeset) throws TreeException, OptionException {
        this.setOption("data", value, changeset);
        if (value != null && !value.isEmpty()) {
            this.setOption("src", null, changeset);
        }
    }

    private void setSource(String value, Changeset changeset) throws TreeException, OptionException {
        this.setOption("src", value, changeset);
        if (value != null && !value.isEmpty()) {
            this.setOption("data", null, changeset);
        }
    }

    @Override
    public boolean isComprehensible() {
        return true;
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }
}

