/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLBarcodeField;
import at.mrdevelopment.esl.template.editor.model.XSLImageField;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateElement;
import at.mrdevelopment.esl.template.editor.model.XSLTextFieldContainer;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLField
extends XSLTemplateElement {
    public static final String OPTION_CONTAINER_NAME = "fieldOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Field Options";
    private XSLTag nestedField;
    private final int fieldNumber;
    private int relativeY;

    protected XSLField(Element fieldElement, int fieldId, DesignTemplateModel templateModel, int fieldNumber) throws OptionException, BarcodeException, TreeException {
        super(fieldId, fieldElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.FIELD});
        this.fieldNumber = fieldNumber;
        this.initNestedField();
    }

    private void initNestedField() throws OptionException, BarcodeException, TreeException {
        NodeList textNodes = this.getXSLElement().getElementsByTagName("text");
        NodeList barcodeNodes = this.getXSLElement().getElementsByTagName("barcode");
        NodeList imageNodes = this.getXSLElement().getElementsByTagName("img");
        if (textNodes.getLength() > 0) {
            this.nestedField = this.parseTextFieldContainer(textNodes);
        } else if (barcodeNodes.getLength() > 0) {
            this.nestedField = new XSLBarcodeField(this.getFieldId(), (Element)barcodeNodes.item(0), this.getTemplateModel());
        } else if (imageNodes.getLength() > 0) {
            this.nestedField = new XSLImageField(this.getFieldId(), (Element)imageNodes.item(0), this.getTemplateModel());
        }
        if (this.nestedField != null) {
            this.getOptions().addNode(this.nestedField.getOptions());
        }
    }

    @Override
    public void updateTemplateTreeNode(TemplateTreeNode templateTreeNode) throws TreeException, OptionException {
        super.updateTemplateTreeNode(templateTreeNode);
        if (this.nestedField != null) {
            this.nestedField.updateTemplateTreeNode((TemplateTreeNode)templateTreeNode.getChilds().getFirst());
        }
    }

    private XSLTextFieldContainer parseTextFieldContainer(NodeList textNodes) throws OptionException {
        XSLTextFieldContainer container = new XSLTextFieldContainer(this.getFieldId(), this.getTemplateModel());
        for (int index = 0; index < textNodes.getLength(); ++index) {
            if (!(textNodes.item(index) instanceof Element)) continue;
            Element textElement = (Element)textNodes.item(index);
            container.addTextField(textElement);
        }
        return container;
    }

    @Override
    public FieldType getNestedFieldType() {
        if (this.nestedField == null) {
            return null;
        }
        if (this.nestedField instanceof XSLBarcodeField) {
            return FieldType.BARCODE;
        }
        if (this.nestedField instanceof XSLImageField) {
            return FieldType.IMAGE;
        }
        if (this.nestedField instanceof XSLTextFieldContainer) {
            return FieldType.TEXT;
        }
        return null;
    }

    @Override
    public boolean checkBounds(Shape shape) throws OptionException {
        Dimension dimension = this.calculateDimension(shape);
        return shape.getBounds().x >= 0 && shape.getBounds().y >= 0 && dimension.width > 0 && dimension.height > 0;
    }

    private Dimension calculateDimension(Shape shape) {
        int rotation;
        Element currentElement;
        Rectangle bounds = shape.getBounds();
        Rectangle oldBounds = this.getBounds().getBounds();
        Element element = currentElement = this.getImageSourceElement() != null ? this.getImageSourceElement() : this.getXSLElement();
        if ((bounds.width != oldBounds.width || bounds.height != oldBounds.height) && currentElement.hasAttribute("rotation") && (rotation = Integer.parseInt(currentElement.getAttribute("rotation"))) != 0) {
            Rectangle rotatedBounds = ImageUtils.revertRotation(bounds, rotation);
            return new Dimension(rotatedBounds.width, rotatedBounds.height);
        }
        return new Dimension(shape.getBounds().width, shape.getBounds().height);
    }

    @Override
    public void setBounds(Shape shape, Changeset changeset) throws TreeException, OptionException {
        Rectangle bounds = shape.getBounds();
        Rectangle oldBounds = this.getBounds().getBounds();
        this.setOption("x", String.valueOf(shape.getBounds().x), changeset);
        this.setOption("y", String.valueOf(shape.getBounds().y), changeset);
        if (bounds.width != oldBounds.width || bounds.height != oldBounds.height) {
            Dimension dimension = this.calculateDimension(shape);
            this.setOption("width", String.valueOf(dimension.width), changeset);
            this.setOption("height", String.valueOf(dimension.height), changeset);
        }
    }

    @Override
    public Shape getBounds() {
        int rotation;
        Element currentElement = this.getImageSourceElement() != null ? this.getImageSourceElement() : this.getXSLElement();
        Rectangle bounds = new Rectangle(Integer.parseInt(currentElement.getAttribute("x")), currentElement.hasAttribute("y") ? Integer.parseInt(currentElement.getAttribute("y")) : this.getRelativeY(), Integer.parseInt(currentElement.getAttribute("width")), Integer.parseInt(currentElement.getAttribute("height")));
        if (currentElement.hasAttribute("rotation") && (rotation = Integer.parseInt(currentElement.getAttribute("rotation"))) != 0) {
            Rectangle rotatedBounds = ImageUtils.rotateRectangle(bounds, rotation);
            bounds = new Rectangle(bounds.x, bounds.y, rotatedBounds.width, rotatedBounds.height);
        }
        return bounds;
    }

    public boolean hasRelativeY() {
        Element currentElement = this.getImageSourceElement() != null ? this.getImageSourceElement() : this.getXSLElement();
        return !currentElement.hasAttribute("y");
    }

    private int getRelativeY() {
        return this.relativeY;
    }

    @Override
    protected void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath.getSize() < 1) {
            throw new OptionException("Root option can't be set");
        }
        if (optionPath.getSize() == 1) {
            String optionKey = optionPath.getFirstElement();
            this.setOption(optionKey, value, changeset);
        } else {
            this.nestedField.setOption(optionPath.removeFirstElement(), value, changeset, complex);
        }
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
        this.nestedField.unregisterOptionsRecursively(changeset);
    }

    @Override
    public boolean isComprehensible() {
        if (this.nestedField == null) {
            return false;
        }
        return this.nestedField.isComprehensible();
    }

    @Override
    public XSLTag getNestedField() {
        return this.nestedField;
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public void setRelativeY(int posY) {
        this.relativeY = posY;
    }
}

